/*
 * $Id: bc.h,v 1.10 2003/10/05 19:59:12 nicoo Exp $
 *
 *
 * Copyright (C) 1999-2003 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */

#ifndef __FEM_BC_H__
#define __FEM_BC_H__

#include <fem/bc.h>

#include "dof.h"
#include "matrix.h"
#include "meshing.h"
#include "page.h"


/*-----------------------------------------------------------------------------
                              B C _ P A R T _ T
-----------------------------------------------------------------------------*/

typedef struct bc_part_t
{
	unsigned long	node;
	dofset_t	dof;
	double		coef;
} bc_part_t;


/*-----------------------------------------------------------------------------
                                    B C _ T
-----------------------------------------------------------------------------*/

typedef struct bc_t
{
	unsigned long	nb;
	bc_part_t	*part;
	double		value;
} bc_t;


/*-----------------------------------------------------------------------------
                               B C _ L I S T _ T
-----------------------------------------------------------------------------*/

typedef struct bc_list_t
{
	page_list_t	bc;
} bc_list_t;


/*-----------------------------------------------------------------------------
                                 M A C R O S
-----------------------------------------------------------------------------*/

#define BC_LIST(x)		((bc_list_t *)(x))


/*-----------------------------------------------------------------------------
                              P R O T O T Y P E S
-----------------------------------------------------------------------------*/

#include "numbering.h"

extern bc_list_t __fem_bc_list_create(void);
extern void __fem_bc_list_free(bc_list_t *bc_list);
extern unsigned long __fem_bc_numbering_l1(const bc_list_t *bc_list,
					   const numbering_t *numbering,
					   const meshing_t *meshing,
					   unsigned long node, dofset_t dof,
					   unsigned long current);
extern unsigned long __fem_bc_numbering_l2(const bc_list_t *bc_list,
					   const numbering_t *numbering,
					   const meshing_t *meshing,
					   unsigned long node, dofset_t dof,
					   unsigned long current);
extern unsigned long __fem_bc_numbering_error(const bc_list_t *bc_list,
					      const numbering_t *numbering,
					      unsigned long no,
					      unsigned long n);
extern void __fem_bc_gsm_profile(matrix_t *gsm, const bc_list_t *bc_list,
				 const numbering_t *numbering,	
				 const meshing_t *meshing);
extern double __fem_bc_gsm_compute(matrix_t *gsm, const bc_list_t *bc_list, 
				   const numbering_t *numbering,
				   const meshing_t *meshing);
extern void __fem_bc_vector(vector_t *b, const bc_list_t *bc_list, 
			    const numbering_t *numbering, double beta);

#endif /* __FEM_BC_H__ */
