/*
 * $Id: meshing.h,v 1.9 2003/08/30 21:16:19 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */


#ifndef __HAPLO_FEM_MESHING_H__
#define __HAPLO_FEM_MESHING_H__

#include <haplo/module.h>
#include <haplo.h>

__HAPLO_BEGIN_DECLS


/*-----------------------------------------------------------------------------
                           F E M _ M E S H I N G _ T
-----------------------------------------------------------------------------*/

typedef void fem_meshing_t;


/*-----------------------------------------------------------------------------
                              P R O T O T Y P E S
-----------------------------------------------------------------------------*/

__haplo_function(node_add)
void fem_node_add(fem_meshing_t *meshing, haplo_list_t *list);

__haplo_function(mesh_add)
void fem_mesh_add(fem_meshing_t *meshing, haplo_list_t *list);

__haplo_function(meshing)
fem_meshing_t * fem_meshing_new(const double *dim);

__haplo_function(meshing)
fem_meshing_t * fem_meshing_new_3d(void);

__haplo_type_copy
fem_meshing_t * fem_meshing_copy(const fem_meshing_t *meshing);

__haplo_type_free
void fem_meshing_free(fem_meshing_t *meshing);

__haplo_type_display
void fem_meshing_display(const fem_meshing_t *meshing);

__haplo_function(meshing)
fem_meshing_t * fem_meshing_load(const char *filename);

__haplo_function(meshing_inline)
fem_meshing_t * fem_meshing_inline(void);

__haplo_function(save)
void fem_meshing_save(const char *filename, const fem_meshing_t *meshing);

__haplo_function(print)
void fem_meshing_print(const fem_meshing_t *meshing);

__haplo_function(+)
extern fem_meshing_t *fem_meshing_add(const fem_meshing_t *meshing1,
				      const fem_meshing_t *meshing2);

__HAPLO_END_DECLS

#endif /* __HAPLO_FEM_MESHING_H__ */
