/*
 * $Id: load.h,v 1.2 2003/08/30 13:29:55 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */

#ifndef __HAPLO_FEM_LOAD_H__
#define __HAPLO_FEM_LOAD_H__

#include <haplo/module.h>

#include <fem/group.h>

__HAPLO_BEGIN_DECLS


/*-----------------------------------------------------------------------------
                             F E M _ L O A D _ T
-----------------------------------------------------------------------------*/

typedef void fem_load_t;


/*-----------------------------------------------------------------------------
                             P R O T O T Y P E S
-----------------------------------------------------------------------------*/

__haplo_type_free
extern void fem_load_free(fem_load_t *load);

__haplo_type_display
extern void fem_load_display(const fem_load_t *load);

__haplo_type_copy
extern fem_load_t *fem_load_copy(const fem_load_t *load);

__haplo_function(loading)
extern fem_load_t *fem_load_new(void);

__haplo_function(print)
extern void fem_load_print(const fem_load_t *load);

__haplo_function(add)
extern void fem_load_add(fem_load_t *load, const double *node,
			 const char *force, const double *value);

__haplo_function(add)
extern void fem_load_add_group(fem_load_t *load, const fem_group_t *group,
			       const char *force, const double *value);

__HAPLO_END_DECLS

#endif /* __HAPLO_FEM_LOAD_H__ */
