/*
 * $Id: slink.c,v 1.6 2003/10/14 09:46:43 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 *
 * Gestion basique de listes simplement chaines
 *
 *
 * ,---------.     ,---------.
 * | sink_t  | ,-> | slink_t | ,-> NULL
 * | data    | |   | data    | |
 * | next ---+-'   | next ---+-'
 * `---------'     `---------'
 *
 */

#ifdef HAVE_CONFIG_H
#	include "config.h"
#endif
#include "version.h" 

#include "pool.h"
#include "slink.h"
#include "utils.h"

/*-----------------------------------------------------------------------------
                       G L O B A L   V A R I A B L E S 
-----------------------------------------------------------------------------*/

static pool_t	*slink_pool=NULL;


/*-----------------------------------------------------------------------------
                             P R O T O T Y P E S 
-----------------------------------------------------------------------------*/

slink_t *__haplo_slink_new(void *data);
slink_t *__haplo_slink_append(slink_t *prev, void *data);
slink_t *__haplo_slink_prepend(slink_t *next, void *data);
void __haplo_slink_free(slink_t *first);
void __haplo_slink_free_f(slink_t *first, slink_func_t f);
void __haplo_slink_loop(slink_t *first, slink_func_t f);
unsigned int __haplo_slink_length(slink_t *first);
void __haplo_slink_init(void);
void __haplo_slink_fini(void);


/*-----------------------------------------------------------------------------
                         I M P L E M E N T A T I O N 
-----------------------------------------------------------------------------*/


/**
 * Cration d'un nouveau maillon avec une zone de donne dj alloue
 * Pas de connexion avec d'autre maillon.
 */
slink_t *__haplo_slink_new(void *data)
{
	slink_t	*new;

	new=__haplo_pool_get(slink_pool);
	new->data=data;
	new->next=NULL;
	
	return(new);
}


/**
 * Cration d'un nouveau maillon avec une zone de donne dj alloue
 * Connexion _aprs_ un maillon pass en paramtre.
 */
slink_t *__haplo_slink_append(slink_t *prev, void *data)
{
	slink_t	*new;

	new=__haplo_pool_get(slink_pool);
	new->data=data;
	new->next=prev->next;
	
	prev->next=new;
	
	return(new);
}


/**
 * Cration d'un nouveau maillon avec une zone de donne dj alloue
 * Connexion _avant_ un maillon pass en paramtre.
 * Attention, l'arbre de maillon risque de ne plus etre linaire aprs
 * cet appel.
 */
slink_t *__haplo_slink_prepend(slink_t *next, void *data)
{
	slink_t	*new; 

	new=__haplo_pool_get(slink_pool);
	new->data=data;
	new->next=next;
	
	return(new);
}


/**
 * Libration simple d'une chaine de maillon simple, _sans_ intervention
 * sur les zones de donnes.
 * Idal lorsque les zones de donne ne sont pas alloue dynamiquement!
 * Sinon utiliser l'appel suivant
 */
void __haplo_slink_free(slink_t *first)
{
	slink_t	*s=first;

	while(s)
	{
		slink_t	*next=s->next;
		__haplo_pool_release(slink_pool, s);
		s=next;
	}
	
	/* La construction recursive suivante est plus gourmande en CPU 
	 * mais plus lgante en programmation.
	 *
	 * if (slink)
	 * {
	 *	__haplo_slink_free(slink->next);
	 *	HAPLO_FREE(slink);
	 * }
	 */

	return;
}


/***
 * Libration simple d'une chaine de maillon simple, _avec_ intervention
 * sur les zones de donnes.
 */
void __haplo_slink_free_f(slink_t *first, slink_func_t f)
{
	slink_t	*s=first;
	
	while(s)
	{
		slink_t	*next=s->next;
#ifdef HAPLO_DEBUG_MEMORY
		if (f == SLINK_FUNC(HAPLO_FREE_FUNC))
			HAPLO_FREE(s->data);
		else
#endif
			(*f)(s->data);
		
		__haplo_pool_release(slink_pool, s);
		s=next;
	}
	
	/* voir commentaires dans la fonction prcdente.
	 *
	 * if (slink)
	 * {
	 * 	__haplo_slink_free_f(slink->next, f);
	 *	(*f)(slink->data);
	 *	HAPLO_FREE(slink);
	 * }
	 */

	return;
}


/**
 *
 */
void __haplo_slink_loop(slink_t *first, slink_func_t f)
{
	while(first)
	{
		(*f)(first->data);
		first=first->next;
	}
	return;
}


/**
 *
 */
unsigned int __haplo_slink_length(slink_t *first)
{
	unsigned int	size=0;
	
	for(; first; first=first->next, size++)
		/* nothing */;
	
	return(size);
}


/**
 *
 */
void __haplo_slink_init(void)
{
	slink_pool=__haplo_pool_new(SLINK_POOL_SIZE, sizeof(slink_t));

	return;
}


/**
 *
 */
void __haplo_slink_fini(void)
{
	__haplo_pool_free(slink_pool);

	return;
}
