/*
 * $Id: pool.h,v 1.1 2003/07/03 18:52:36 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */

#ifndef __HAPLO_POOL_H__
#define __HAPLO_POOL_H__

#include <stdlib.h>


/*-----------------------------------------------------------------------------
                                 P O O L _ T 
-----------------------------------------------------------------------------*/

typedef struct pool_t
{
	size_t		size;
	size_t		head;
	size_t		max_size;
	size_t		elem_size;
	void		**slot;
} pool_t;


/*-----------------------------------------------------------------------------
                             P R O T O T Y P E S 
-----------------------------------------------------------------------------*/

extern pool_t *__haplo_pool_new(size_t size, size_t elem_size);
extern void __haplo_pool_free(pool_t *pool);
extern void *__haplo_pool_get(pool_t *pool);
extern void __haplo_pool_release(pool_t *pool, void *slot);

#endif /* __HAPLO_POOL_H__ */
