/*
 * $Id: pool.c,v 1.1 2003/07/03 18:52:35 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */

#include "pool.h"
#include "utils.h"


/*-----------------------------------------------------------------------------
                             P R O T O T Y P E S 
-----------------------------------------------------------------------------*/

pool_t *__haplo_pool_new(size_t size, size_t elem_size);
void __haplo_pool_free(pool_t *pool);
void *__haplo_pool_get(pool_t *pool);
void __haplo_pool_release(pool_t *pool, void *slot);


/*-----------------------------------------------------------------------------
                         I M P L E M E N T A T I O N 
-----------------------------------------------------------------------------*/


/**
 *
 * @param size
 * @param elem_size
 * 
 * @return
 */
pool_t *__haplo_pool_new(size_t size, size_t elem_size)
{
	pool_t *pool;

	HAPLO_ALLOC(pool, 1);

	pool->head=0;
	pool->size=0;
	pool->max_size=size;
	pool->elem_size=elem_size;

	HAPLO_ALLOC(pool->slot, size);	

	return(pool);
}


/**
 *
 * @param pool
 */
void __haplo_pool_free(pool_t *pool)
{
	size_t	i;

	for(i=pool->head; i<pool->size; i++)
		HAPLO_FREE(pool->slot[i]);
	
	HAPLO_FREE(pool->slot);
	HAPLO_FREE(pool);

	return;
}


/**
 *
 * @param pool
 *
 * @return
 */
void *__haplo_pool_get(pool_t *pool)
{
	void *slot;
	
	if (pool->head < pool->size)
		slot=pool->slot[pool->head++];
	else
	{	
		slot=HAPLO_MALLOC(pool->elem_size);
		if (pool->size < pool->max_size)
		{
			pool->head += 1;
			pool->size += 1;
		}
	}
	

	return(slot);
}


/**
 *
 * @param pool
 * @param slot
 */
void __haplo_pool_release(pool_t *pool, void *slot)
{
	if (pool->head > 0)
		pool->slot[--pool->head]=slot;
	else
		HAPLO_FREE(slot);

	return;
}
