/*
 * $Id: utils.h,v 1.11 2003/12/01 09:50:14 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */

#ifndef __HAPLO_HAPLO_UTILS_H__
#define __HAPLO_HAPLO_UTILS_H__

#include <haplo/defs.h>

#ifndef __C2MAN__
#	include <stdlib.h>
#else
typedef int size_t;
#endif

__HAPLO_BEGIN_DECLS


/*-----------------------------------------------------------------------------
                          H A P L O _ T I M E R _ T
-----------------------------------------------------------------------------*/

typedef struct haplo_timer_t
{
	unsigned long sec;	/* seconds */
	unsigned long usec;	/* microseconds */
} haplo_timer_t;	


/*-----------------------------------------------------------------------------
                                 M A C R O S
-----------------------------------------------------------------------------*/	
/*
 * Debuging stuff.
 */
#define __FIXME__	haplo_warning("FIX ME! (%s:%d)", __FILE__, __LINE__);

#ifndef __C2MAN__
#	ifdef HAPLO_DEBUG_MEMORY
#		define HAPLO_ASSERT(c)		if (!(c)) { \
			haplo_fatal("%s:%d: Assertion `%s' failed.", \
			__FILE__, __LINE__, #c); }
#	else
#			define HAPLO_ASSERT(c)		
#	endif /* HAPLO_DEBUG_MEMORY */

#	ifdef HAPLO_DEBUG_MEMORY
#		define HAPLO_DEBUG_MEMORY_ARGS	, __FILE__, __LINE__
#		define HAPLO_MALLOC(size)	\
			haplo_malloc_debug(size, __FILE__, __LINE__)

#		define HAPLO_REALLOC(ptr, size)	\
			haplo_realloc_debug(ptr, size, __FILE__, __LINE__)

#		define HAPLO_FREE(ptr)		\
			haplo_free_debug(ptr, __FILE__, __LINE__)

#		define HAPLO_FREE_FUNC		haplo_free_debug
#		define HAPLO_MEMORY_WATCH(x)	haplo_memory_watch(x)
#		define HAPLO_MEMORY_USAGE()	haplo_memory_usage()
#	else /* ! HAPLO_DEBUG_MEMORY */
#		define HAPLO_DEBUG_MEMORY_ARGS	/* nothing */
#		define HAPLO_MALLOC(size)	haplo_malloc(size)
#		define HAPLO_REALLOC(ptr, size)	\
			haplo_realloc(ptr, size)

#		define HAPLO_FREE(ptr)		free(ptr)
#		define HAPLO_FREE_FUNC		free
#		define HAPLO_MEMORY_WATCH(x)	/* nothing */
#		define HAPLO_MEMORY_USAGE()	0 /* nothing */
#	endif /* HAPLO_DEBUG_MEMORY */
#	define HAPLO_ALLOC(var, size)		\
		var=HAPLO_MALLOC(sizeof(*(var))*(size))

#	define HAPLO_RE_ALLOC(var, size)	\
		var=HAPLO_REALLOC(var, sizeof(*var)*(size))

#	define HAPLO_FREE_FUNC_APPLY(f, x)	\
		((*f)(x HAPLO_DEBUG_MEMORY_ARGS))
#endif /* __C2MAN__ */

#define HAPLO_COLORS_NONE		0
#define HAPLO_COLORS_ANSI		1
#define HAPLO_COLORS_FLASH		2


/*-----------------------------------------------------------------------------
                             P R O T O T Y P E S
-----------------------------------------------------------------------------*/

#ifdef __C2MAN__
typedef int varname;
/*
 * Memory allocation
 *
 * DESCRIPTION: HAPLO_MALLOC assign to varname a pointer to a block of at
 * least n*sizeof(*varname). HAPLO_ALLOC is defined as a macro.
 *
 * If you define HAPLO_DEBUG_MEMORY this function does some extra work and you
 * can track memory leaks by calling HAPLO_MEMORY_USAGE or
 * HAPLO_MEMORY_WATCH. Note that if you allocate memory using HAPLO_ALLOC or
 * HAPLO_MALLOC compiled with HAPLO_DEBUG_MEMORY defined, you should called
 * the HAPLO_FREE function from a file also compiled with
 * HAPLO_DEBUG_MEMORY otherwise you might reach a runtime fatal error.
 */
void HAPLO_ALLOC(varname, /* A declared pointer to any type. */
		 size_t n /* size of the desired vector */);
/*
 * Simple wrapper around standard malloc.
 *
 * DESCRIPTION:
 *
 * RETURN: a pointer to the allocated memory, which is suitably aligned for
 * any kind of variable. This function never returns NULL and will call
 * haplo_fatal on error.
 * 
 */
void * HAPLO_MALLOC(size_t size /* Amount of memory in bytes */);
#endif /* __C2MAN__ */

/*
 * Simple wrapper around standard malloc.
 *
 * DESCRIPTION:
 *
 * RETURN: This function returns a pointer to the allocated memory, which is
 * suitably aligned for any kind of variable. This function never returns
 * NULL and will call haplo_fatal on error.
 *
 * WARNING: do not use this function directly. Use HAPLO_MALLOC or HAPLO_ALLOC
 * instead.
 */
void *haplo_malloc(size_t size /* Amount of memory in bytes */);

/*
 * Simple wrapper around standard malloc.
 *
 * DESCRIPTION:
 *
 * RETURN: a pointer to the allocated memory, which is suitably aligned for
 * any kind of variable. This function never returns NULL and will call
 * haplo_fatal on error.
 *
 * WARNING: do not use this function directly. Use HAPLO_MALLOC or 
 * HAPLO_ALLOC instead. 
 */
void *haplo_malloc_debug(size_t size, /* Amount of memory in bytes */
			 const char *file, /* caller file. Should be __FILE __*/
			 unsigned long line
			 /* Caller line. Should be __LINE__ */);

/*
 * Simple wrapper around standard realloc.
 *
 * DESCRIPTION:
 *
 * WARNING: do not use this function directly. Use HAPLO_RE_ALLOC or 
 * HAPLO_RE_ALLOC instead.
 */
extern void *haplo_realloc(void *ptr, /* The initial memory segment */
			   size_t size /* New totalsize */);

/*
 * Simple wrapper around standard realloc.
 *
 * WARNING: do not use this function directly. Use HAPLO_RE_ALLOC or 
 * HAPLO_RE_ALLOC instead.
 */
extern void *haplo_realloc_debug(void *ptr,
				 size_t size, /* Amount of memory in bytes */
				 const char *file,
				 unsigned long line);

/*
 * Simple wrapper around standard free.
 *
 * WARNING: do not use this function directly. Use HAPLO_FREE or
 * HAPLO_FREE_FUNC instead.
 */
extern void haplo_free_debug(void *ptr,
			     const char *file,
			     unsigned long line);

/*
 * 
 */
extern void haplo_memory_watch(void *ptr);

/*
 *
 */
extern int haplo_memory_usage(void);


#if defined __GNUC__ && __GNUC__ >= 2
#	define HAPLO_CTRL_ARGS __attribute__((format (printf, 1, 2)))
#else
#	define HAPLO_CTRL_ARGS
#endif /* Gcc 2.x */
/*
 *
 */
extern void haplo_fatal(const char *s, /* */
			...) HAPLO_CTRL_ARGS;

/*
 *
 */
extern void haplo_error(const char *s, /* */
			...) HAPLO_CTRL_ARGS;

/*
 *
 */
extern void haplo_warning(const char *s, /* */
			  ...) HAPLO_CTRL_ARGS;

/*
 *
 */
extern void haplo_info(const char *s, /* */
		       ...) HAPLO_CTRL_ARGS;

/*
 *
 */
extern void haplo_debug(const char *s, /* */
			...) HAPLO_CTRL_ARGS;

/*
 *
 */
extern void haplo_centered(const char *s, /* */
			   ...) HAPLO_CTRL_ARGS;

/*
 *
 */
extern void haplo_underlined(const char *s,
			     ...) HAPLO_CTRL_ARGS;

/*
 *
 */
extern void haplo_bordered(const char *s,
			   ...) HAPLO_CTRL_ARGS;
#undef HAPLO_CTRL_ARGS

/*
 * Convert a double value to an integer
 * return a interger or zero.
 */
extern int haplo_int(double in /* */);

/*
 *
 */
extern double haplo_clamp(double in, double min, double max);

/*
 *
 */
extern unsigned int haplo_uint(double in /* */);

extern unsigned short haplo_ushort(double in /* */);
extern unsigned long haplo_ulong(double in /* */);

/*
 * duplicate a string
 * 
 * DESCRIPTION: The function haplo_strdup  is  a  replacement for
 * (quasi-)standard strdup which does not exist on every platforms.
 * The space for the new string is  obtained  using
 * HAPLO_ALLOC.   If  the  new  string  can  not  be created, haplo_fatal
 * is called.
 * 
 * RETURN: haplo_strdup returns a  pointer to a new string which
 * is a duplicate of s.

 */
extern char *haplo_strdup(const char *s /* Pointer to nul terminated string*/);


/*
 * Start a timer
 */
void haplo_timer_start(haplo_timer_t *timer);

/*
 * Stop a timer
 */
void haplo_timer_stop(haplo_timer_t *timer);

#if defined __GNUC__ && __GNUC__ >= 2
#	define HAPLO_CTRL_ARGS __attribute__((format (printf, 2, 3)))
#else
#	define HAPLO_CTRL_ARGS
#endif /* Gcc 2.x */
/*
 * Print the current value of a timer
 */
void haplo_timer_print(const haplo_timer_t *timer, /* The timer */
		       const char *s, /* format */
		       ... /* optional values */)
HAPLO_CTRL_ARGS;
#undef HAPLO_CTRL_ARGS


__HAPLO_END_DECLS

#endif /* __HAPLO_HAPLO_UTILS_H__ */
