
#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <GL/gl.h>
#include <GL/glut.h>
#include <gtk/gtk.h>
#include <gtk/gtkgl.h>
#include <vte/vte.h>


#include "callbacks.h"
#include "draw.h"
#include "interface.h"
#include "support.h"



void on_term_realize(GtkWidget *term)
{
	gtk_widget_grab_default(term);
	gtk_widget_grab_focus(term);
}



void on_term_died(GtkWidget *term)
{
	gtk_widget_show(create_dialog_unexpected());
	
}


GtkWidget*
term_new (gchar *widget_name, gchar *string1, gchar *string2,
                gint int1, gint int2)
{
	GtkWidget *scrollbar;
	GtkWidget *term;
	GtkWidget *hbox;
	int pid;
	char **argv;
	
	argv=malloc(2*sizeof(*argv));
	argv[0]=NULL;
	argv[1]=NULL;
	
	

	
	hbox=gtk_hbox_new (FALSE, 0);
	term=vte_terminal_new();
	scrollbar=gtk_vscrollbar_new(VTE_TERMINAL(term)->adjustment);
	


	GTK_WIDGET_SET_FLAGS (term, GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS (term, GTK_CAN_FOCUS);
	vte_terminal_set_size(VTE_TERMINAL(term), 80, 13);
	vte_terminal_set_cursor_blinks(VTE_TERMINAL(term), TRUE);


	g_signal_connect(G_OBJECT(term), "realize",
			 G_CALLBACK(on_term_realize),
			 NULL);

	g_signal_connect(G_OBJECT(term), "child-exited",
			 G_CALLBACK(on_term_died),
			 NULL);
	
	gtk_box_pack_start (GTK_BOX (hbox), term, TRUE, TRUE, 0);
	
	gtk_box_pack_start (GTK_BOX (hbox), scrollbar, FALSE, FALSE, 0);
	

	vte_terminal_fork_command(VTE_TERMINAL(term),
				  "../../kernel/haplo/haplo", argv, NULL,
				  ".", FALSE, FALSE, FALSE);

	gtk_widget_show(term);
	gtk_widget_show(scrollbar);
	gtk_widget_show(hbox);

	
	return(hbox);	
}




GtkWidget*
glaera_new (gchar *widget_name, gchar *string1, gchar *string2,
                gint int1, gint int2)
{
	GtkWidget *drawing_area; 
	GdkGLConfig *glconfig;
	

	drawing_area = gtk_drawing_area_new();
	glconfig = configure_gl();

	gtk_widget_set_gl_capability (drawing_area,
				      glconfig,
				      NULL,
				      TRUE,
				      GDK_GL_RGBA_TYPE);

	return(drawing_area);
}


gboolean
on_glaera_configure_event              (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
	GdkGLContext *glcontext = gtk_widget_get_gl_context (widget);
	GdkGLDrawable *gldrawable = gtk_widget_get_gl_drawable (widget);
 
	GLfloat w = widget->allocation.width;
	GLfloat h = widget->allocation.height;
 
	
	/*** OpenGL BEGIN ***/
	if (!gdk_gl_drawable_gl_begin (gldrawable, glcontext))
		return FALSE;
 
	/*** Fill in the details here. ***/



	gdk_gl_drawable_gl_end (gldrawable);

	return TRUE;

}


gboolean
on_glaera_expose_event                 (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  GdkGLContext *glcontext = gtk_widget_get_gl_context (widget);
  GdkGLDrawable *gldrawable = gtk_widget_get_gl_drawable (widget);
                                                                                
  if (!gdk_gl_drawable_gl_begin (gldrawable, glcontext))
    return FALSE;


  draw();
                                                                                
  if (gdk_gl_drawable_is_double_buffered (gldrawable))
    gdk_gl_drawable_swap_buffers (gldrawable);
  else
    glFlush ();
                                                                                
  gdk_gl_drawable_gl_end (gldrawable);
  /*** OpenGL END ***/
                                                                                
  return TRUE;

}


void
on_glaera_realize                      (GtkWidget       *widget,
                                        gpointer         user_data)
{
	GLfloat specular [] = { 1.0, 1.0, 1.0, 1.0 };
	GLfloat shininess [] = { 100.0 };
	GLfloat position [] = { 1.0, 1.0, 1.0, 0.0 };



	GdkGLContext *glcontext = gtk_widget_get_gl_context (widget);
	GdkGLDrawable *gldrawable = gtk_widget_get_gl_drawable (widget);
 
	if (!gdk_gl_drawable_gl_begin (gldrawable, glcontext))
		return;
 

	glEnable(GL_AUTO_NORMAL);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_LINE_SMOOTH);
	glLineWidth(2);
	
	glShadeModel(GL_SMOOTH);

	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, specular);
	glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, shininess);

	glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
	glEnable(GL_COLOR_MATERIAL);



	glLightfv(GL_LIGHT0, GL_POSITION, position);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);


	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(-8.0, 16.0, -8.0, 8.0, -8.0, 8.0);

	glMatrixMode(GL_MODELVIEW);

 
	gdk_gl_drawable_gl_end (gldrawable);


}


void
on_glaera_unrealize                    (GtkWidget       *widget,
                                        gpointer         user_data)
{

}




void
on_new1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_open1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_save1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_save_as1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_quit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gtk_widget_show(create_dialog_quit());
}


void
on_cut1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_copy1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_paste1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_delete1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gtk_widget_show(create_dialog_about());

}


gboolean
on_main_delete_event                   (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	gtk_widget_show(create_dialog_quit());
	
	return TRUE;
}

