/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.BtreeCursor;
import org.h2.index.BtreeIndex;
import org.h2.index.BtreePage;
import org.h2.index.BtreePosition;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.DataPage;
import org.h2.table.Column;
import org.h2.util.IntArray;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

public class BtreeNode
extends BtreePage {
    private boolean writePos;
    private IntArray pageChildren;

    BtreeNode(BtreeIndex btreeIndex, DataPage dataPage) throws SQLException {
        super(btreeIndex);
        int n = dataPage.readInt();
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = dataPage.readInt();
        }
        this.pageChildren = new IntArray(nArray);
        this.pageData = btreeIndex.readRowArray(dataPage);
    }

    BtreeNode(BtreeIndex btreeIndex, BtreePage btreePage, SearchRow searchRow, BtreePage btreePage2) {
        super(btreeIndex);
        this.pageChildren = new IntArray();
        this.pageChildren.add(btreePage.getPos());
        this.pageChildren.add(btreePage2.getPos());
        this.pageData = new ObjectArray();
        this.pageData.add(searchRow);
    }

    BtreeNode(BtreeIndex btreeIndex, IntArray intArray, ObjectArray objectArray) {
        super(btreeIndex);
        this.pageChildren = intArray;
        this.pageData = objectArray;
    }

    protected SearchRow getData(int n) throws SQLException {
        SearchRow searchRow = (SearchRow)this.pageData.get(n);
        if (searchRow == null) {
            int n2 = this.pageChildren.get(n + 1);
            Session session = this.index.getDatabase().getSystemSession();
            BtreePage btreePage = this.index.getPage(session, n2);
            searchRow = btreePage.getFirst(session);
            this.pageData.set(n, searchRow);
        }
        return searchRow;
    }

    public int add(Row row, Session session) throws SQLException {
        int n;
        Object object;
        int n2;
        int n3 = 0;
        int n4 = this.pageData.size();
        while (n3 < n4) {
            n2 = n3 + n4 >>> 1;
            object = this.getData(n2);
            n = this.index.compareRows((SearchRow)object, row);
            if (n == 0) {
                if (this.index.indexType.isUnique() && !this.index.isNull(row)) {
                    throw this.index.getDuplicateKeyException();
                }
                n = this.index.compareKeys((SearchRow)object, row);
            }
            if (n > 0) {
                n4 = n2;
                continue;
            }
            n3 = n2 + 1;
        }
        n2 = n3;
        object = this.index.getPage(session, this.pageChildren.get(n2));
        n = ((BtreePage)object).add(row, session);
        if (n == 0) {
            return 0;
        }
        SearchRow searchRow = ((BtreePage)object).getData(n);
        BtreePage btreePage = ((BtreePage)object).split(session, n);
        this.index.deletePage(session, this);
        this.pageChildren.add(n2 + 1, btreePage.getPos());
        this.pageData.add(n2, searchRow);
        n = this.getSplitPoint();
        if (n > 1) {
            return n;
        }
        this.index.updatePage(session, this);
        return 0;
    }

    public SearchRow remove(Session session, Row row) throws SQLException {
        Object object;
        int n;
        int n2 = 0;
        int n3 = this.pageData.size();
        int n4 = 0;
        while (n2 < n3) {
            n = n2 + n3 >>> 1;
            object = this.getData(n);
            n4 = this.index.compareRows((SearchRow)object, row);
            if (n4 == 0) {
                n4 = this.index.compareKeys((SearchRow)object, row);
            }
            if (n4 > 0) {
                n3 = n;
                continue;
            }
            n2 = n + 1;
        }
        n = n2;
        object = this.index.getPage(session, this.pageChildren.get(n));
        SearchRow searchRow = ((BtreePage)object).remove(session, row);
        if (searchRow == null) {
            return null;
        }
        if (searchRow == row) {
            this.index.deletePage(session, this);
            this.pageChildren.remove(n);
            if (this.pageChildren.size() == 0) {
                return row;
            }
            if (n == 0) {
                searchRow = this.getData(0);
                this.pageData.remove(0);
            } else {
                searchRow = null;
                this.pageData.remove(n == 0 ? 0 : n - 1);
            }
            this.index.updatePage(session, this);
            return searchRow;
        }
        if (n == 0) {
            return searchRow;
        }
        this.index.deletePage(session, this);
        this.pageData.set(n - 1, searchRow);
        this.index.updatePage(session, this);
        return null;
    }

    public BtreePage split(Session session, int n) throws SQLException {
        ObjectArray objectArray = new ObjectArray();
        IntArray intArray = new IntArray();
        ++n;
        int n2 = this.pageData.size();
        if (SysProperties.CHECK && this.index.getDatabase().getLogIndexChanges() && !this.getDeleted()) {
            throw Message.getInternalError();
        }
        for (int i = n; i < n2; ++i) {
            objectArray.add(this.getData(n));
            intArray.add(this.getChild(n));
            this.pageData.remove(n);
            this.pageChildren.remove(n);
        }
        intArray.add(this.getChild(n));
        this.pageData.remove(n - 1);
        this.pageChildren.remove(n);
        BtreeNode btreeNode = new BtreeNode(this.index, intArray, objectArray);
        this.index.updatePage(session, this);
        this.index.addPage(session, btreeNode);
        return btreeNode;
    }

    int getChild(int n) {
        return this.pageChildren.get(n);
    }

    public boolean findFirst(BtreeCursor btreeCursor, SearchRow searchRow, boolean bl) throws SQLException {
        int n;
        int n2 = 0;
        int n3 = this.pageData.size();
        while (n2 < n3) {
            int n4 = n2 + n3 >>> 1;
            SearchRow searchRow2 = this.getData(n4);
            int n5 = this.index.compareRows(searchRow2, searchRow);
            if (n5 > 0 || !bl && n5 == 0) {
                n3 = n4;
                continue;
            }
            n2 = n4 + 1;
        }
        if (n2 >= this.pageData.size()) {
            BtreePage btreePage = this.index.getPage(btreeCursor.getSession(), this.pageChildren.get(n2));
            btreeCursor.push(this, n2);
            boolean bl2 = btreePage.findFirst(btreeCursor, searchRow, bl);
            if (bl2) {
                return true;
            }
            btreeCursor.pop();
            return false;
        }
        BtreePage btreePage = this.index.getPage(btreeCursor.getSession(), this.pageChildren.get(n2));
        btreeCursor.push(this, n2);
        if (btreePage.findFirst(btreeCursor, searchRow, bl)) {
            return true;
        }
        btreeCursor.pop();
        for (n = n2 + 1; n < this.pageData.size(); ++n) {
            SearchRow searchRow3 = this.getData(n);
            int n6 = this.index.compareRows(searchRow3, searchRow);
            if (n6 < 0) continue;
            btreePage = this.index.getPage(btreeCursor.getSession(), this.pageChildren.get(n));
            btreeCursor.push(this, n);
            if (btreePage.findFirst(btreeCursor, searchRow, bl)) {
                return true;
            }
            btreeCursor.pop();
        }
        btreePage = this.index.getPage(btreeCursor.getSession(), this.pageChildren.get(n));
        btreeCursor.push(this, n);
        boolean bl3 = btreePage.findFirst(btreeCursor, searchRow, bl);
        if (bl3) {
            return true;
        }
        btreeCursor.pop();
        return false;
    }

    public void next(BtreeCursor btreeCursor, int n) throws SQLException {
        if (++n <= this.pageData.size()) {
            btreeCursor.setStackPosition(n);
            BtreePage btreePage = this.index.getPage(btreeCursor.getSession(), this.pageChildren.get(n));
            btreePage.first(btreeCursor);
            return;
        }
        this.nextUpper(btreeCursor);
    }

    public void previous(BtreeCursor btreeCursor, int n) throws SQLException {
        if (--n >= 0) {
            btreeCursor.setStackPosition(n);
            BtreePage btreePage = this.index.getPage(btreeCursor.getSession(), this.pageChildren.get(n));
            btreePage.last(btreeCursor);
            return;
        }
        this.previousUpper(btreeCursor);
    }

    private void nextUpper(BtreeCursor btreeCursor) throws SQLException {
        btreeCursor.pop();
        BtreePosition btreePosition = btreeCursor.pop();
        if (btreePosition == null) {
            btreeCursor.setCurrentRow(null);
        } else {
            btreeCursor.push(btreePosition.page, btreePosition.position);
            btreePosition.page.next(btreeCursor, btreePosition.position);
        }
    }

    private void previousUpper(BtreeCursor btreeCursor) throws SQLException {
        btreeCursor.pop();
        BtreePosition btreePosition = btreeCursor.pop();
        if (btreePosition == null) {
            btreeCursor.setCurrentRow(null);
        } else {
            btreeCursor.push(btreePosition.page, btreePosition.position);
            btreePosition.page.previous(btreeCursor, btreePosition.position);
        }
    }

    public void first(BtreeCursor btreeCursor) throws SQLException {
        btreeCursor.push(this, 0);
        BtreePage btreePage = this.index.getPage(btreeCursor.getSession(), this.pageChildren.get(0));
        btreePage.first(btreeCursor);
    }

    public void last(BtreeCursor btreeCursor) throws SQLException {
        int n = this.pageChildren.size() - 1;
        btreeCursor.push(this, n);
        BtreePage btreePage = this.index.getPage(btreeCursor.getSession(), this.pageChildren.get(n));
        btreePage.last(btreeCursor);
    }

    public void prepareWrite() throws SQLException {
        this.writePos = this.getRealByteCount() >= 1024;
    }

    public void write(DataPage dataPage) throws SQLException {
        dataPage.writeByte((byte)78);
        int n = this.pageChildren.size();
        dataPage.writeInt(n);
        for (int i = 0; i < n; ++i) {
            dataPage.writeInt(this.pageChildren.get(i));
        }
        n = this.pageData.size();
        dataPage.writeInt(n);
        Column[] columnArray = this.index.getColumns();
        for (int i = 0; i < n; ++i) {
            if (this.writePos) {
                dataPage.writeInt(-1);
                continue;
            }
            SearchRow searchRow = this.getData(i);
            dataPage.writeInt(searchRow.getPos());
            for (int j = 0; j < columnArray.length; ++j) {
                Value value = searchRow.getValue(columnArray[j].getColumnId());
                dataPage.writeValue(value);
            }
        }
        if (dataPage.length() > 1024) {
            throw Message.getInternalError("indexed data overflow");
        }
    }

    int getRealByteCount() throws SQLException {
        DataPage dataPage = this.index.getDatabase().getDataPage();
        int n = this.pageChildren.size();
        int n2 = 2 + dataPage.getIntLen() + dataPage.getIntLen() * n;
        n = this.pageData.size();
        n2 += dataPage.getIntLen();
        n2 += n * dataPage.getIntLen();
        for (int i = 0; i < n; ++i) {
            SearchRow searchRow = this.getData(i);
            n2 += this.getRowSize(dataPage, searchRow);
        }
        return n2 + this.index.getRecordOverhead();
    }

    SearchRow getFirst(Session session) throws SQLException {
        for (int i = 0; i < this.pageChildren.size(); ++i) {
            BtreePage btreePage = this.index.getPage(session, this.pageChildren.get(i));
            if (btreePage == null) continue;
            return btreePage.getFirst(session);
        }
        return null;
    }
}

