/*
 * Decompiled with CFR 0.152.
 */
package hanzitrainer;

import hanzitrainer.Pinyin;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PinyinParser {
    private String to_parse = "";
    private ArrayList<Pinyin> parsed;

    public PinyinParser() {
    }

    public PinyinParser(String input) {
        this.set_string_to_parse(input);
    }

    public void set_string_to_parse(String input) {
        this.to_parse = input;
        this.parsed = PinyinParser.parse_string(input);
        if (this.parsed.size() == 0) {
            this.to_parse = "";
        }
    }

    public String get_string_parsed() {
        return this.to_parse;
    }

    private static ArrayList<Pinyin> parse_string(String pinyin_string) {
        ArrayList<Pinyin> result = new ArrayList<Pinyin>();
        int strophe_index = pinyin_string.indexOf("'");
        if (strophe_index != -1) {
            if (strophe_index == 0) {
                return PinyinParser.parse_string(pinyin_string.substring(1, pinyin_string.length()));
            }
            if (strophe_index == pinyin_string.length()) {
                return PinyinParser.parse_string(pinyin_string.substring(0, pinyin_string.length() - 1));
            }
            ArrayList<Pinyin> temp = PinyinParser.parse_string(pinyin_string.substring(0, strophe_index - 1));
            if (temp.size() == 0) {
                result.clear();
                return result;
            }
            result = temp;
            temp = PinyinParser.parse_string(pinyin_string.substring(strophe_index + 1, pinyin_string.length()));
            if (temp.size() == 0) {
                result.clear();
                return result;
            }
            result.addAll(temp);
            return result;
        }
        for (int i = Math.min(6, pinyin_string.length()); i >= 0; --i) {
            String try_pinyin = pinyin_string.substring(0, i);
            if (!Pinyin.verify_pinyin(try_pinyin)) continue;
            if (i < pinyin_string.length()) {
                String next_step = pinyin_string.substring(i, pinyin_string.length());
                ArrayList<Pinyin> temp = PinyinParser.parse_string(next_step);
                if (temp.size() == 0) continue;
                result = temp;
            }
            String to_add = try_pinyin;
            result.add(0, new Pinyin(to_add));
            return result;
        }
        return result;
    }

    public int get_number_of_elements() {
        if (this.to_parse.equals("")) {
            return 0;
        }
        return this.parsed.size();
    }

    public Pinyin get_element(int index) {
        if (index >= this.get_number_of_elements()) {
            return new Pinyin();
        }
        return this.parsed.get(index);
    }

    public String get_print_version() {
        String result = "";
        for (int i = 0; i < this.get_number_of_elements(); ++i) {
            result = result + this.get_element(i).get_print_version();
        }
        return result;
    }

    public static String convert_to_printed_version(String input) {
        String result = "";
        ArrayList<Pinyin> parsed = PinyinParser.parse_string(input);
        for (int i = 0; i < parsed.size(); ++i) {
            result = result + parsed.get(i).get_print_version();
        }
        return result;
    }
}

