/*
 * Decompiled with CFR 0.152.
 */
package hanzitrainer;

import hanzitrainer.DBTableFiller;
import hanzitrainer.HanziApplicationUpdater;
import hanzitrainer.HanziDB;
import hanzitrainer.HanziTrainerApp;
import hanzitrainer.PinyinParser;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class CharacterReviewPanel
extends JPanel {
    private JScrollPane CharDBScroll;
    private JTable CharDBTable;
    private JButton CharPreviousButton;
    private JButton CharSearchButton;
    private JLabel CharacterLabel;
    private JTextField CharsearchentryTextField;
    private JButton NextCharacterButton;
    private JLabel PinyinsLabel;
    private JLabel PinyinsLabel1;
    private JTextField PinyinsTextfield;
    private DBTableFiller CharTableFiller;
    private ArrayList<String> character_history;
    private HanziDB main_database;
    private HanziApplicationUpdater parent_app;

    public CharacterReviewPanel(HanziDB database, HanziApplicationUpdater updater) {
        this.main_database = database;
        this.parent_app = updater;
        this.initComponents();
        this.CharTableFiller.set_filter("");
        this.character_history = new ArrayList();
    }

    public void CharacterReviewUpdateDB() {
        this.CharTableFiller.fireTableDataChanged();
    }

    private void initComponents() {
        this.CharacterLabel = new JLabel();
        this.NextCharacterButton = new JButton();
        this.CharsearchentryTextField = new JTextField();
        this.CharSearchButton = new JButton();
        this.CharPreviousButton = new JButton();
        this.CharDBScroll = new JScrollPane();
        this.CharDBTable = new JTable();
        this.CharTableFiller = new DBTableFiller(this.main_database);
        this.PinyinsTextfield = new JTextField();
        this.PinyinsLabel = new JLabel();
        this.PinyinsLabel1 = new JLabel();
        this.setName("Form");
        ResourceMap resourceMap = Application.getInstance(HanziTrainerApp.class).getContext().getResourceMap(CharacterReviewPanel.class);
        this.CharacterLabel.setFont(resourceMap.getFont("CharacterLabel.font"));
        this.CharacterLabel.setHorizontalAlignment(0);
        this.CharacterLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.CharacterLabel.setName("CharacterLabel");
        this.NextCharacterButton.setText(resourceMap.getString("NextCharacterButton.text", new Object[0]));
        this.NextCharacterButton.setName("NextCharacterButton");
        this.NextCharacterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CharacterReviewPanel.this.NextCharacterButtonrandom_character_action(evt);
            }
        });
        this.CharsearchentryTextField.setName("CharsearchentryTextField");
        this.CharsearchentryTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CharacterReviewPanel.this.CharsearchentryTextFieldCharSearchButtonAction(evt);
            }
        });
        this.CharsearchentryTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                CharacterReviewPanel.this.CharsearchentryTextFieldFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                CharacterReviewPanel.this.CharsearchentryTextFieldFocusLost(evt);
            }
        });
        this.CharSearchButton.setText(resourceMap.getString("CharSearchButton.text", new Object[0]));
        this.CharSearchButton.setName("CharSearchButton");
        this.CharSearchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CharacterReviewPanel.this.CharSearchButtonAction(evt);
            }
        });
        this.CharPreviousButton.setText(resourceMap.getString("CharPreviousButton.text", new Object[0]));
        this.CharPreviousButton.setName("CharPreviousButton");
        this.CharPreviousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CharacterReviewPanel.this.CharPreviousButtonActionPerformed(evt);
            }
        });
        this.CharDBScroll.setName("CharDBScroll");
        this.CharDBTable.setModel(this.CharTableFiller);
        this.CharDBTable.setName("CharDBTable");
        this.CharDBTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                CharacterReviewPanel.this.CharDBTableMouseClicked(evt);
            }
        });
        this.CharDBScroll.setViewportView(this.CharDBTable);
        this.PinyinsTextfield.setEditable(false);
        this.PinyinsTextfield.setName("PinyinsTextfield");
        this.PinyinsLabel.setText(resourceMap.getString("PinyinsLabel.text", new Object[0]));
        this.PinyinsLabel.setName("PinyinsLabel");
        this.PinyinsLabel1.setText(resourceMap.getString("PinyinsLabel1.text", new Object[0]));
        this.PinyinsLabel1.setName("PinyinsLabel1");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.CharacterLabel, -2, 157, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.PinyinsLabel).addComponent(this.PinyinsLabel1))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addComponent(this.CharsearchentryTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CharSearchButton, -2, 100, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.NextCharacterButton, -2, 81, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CharPreviousButton)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.CharDBScroll, -1, 298, Short.MAX_VALUE).addComponent(this.PinyinsTextfield, -1, 298, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.CharacterLabel, -2, 142, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CharPreviousButton).addComponent(this.NextCharacterButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CharSearchButton).addComponent(this.CharsearchentryTextField, -2, -1, -2))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.PinyinsLabel).addComponent(this.PinyinsTextfield, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.CharDBScroll, -1, 209, Short.MAX_VALUE).addComponent(this.PinyinsLabel1)).addGap(4, 4, 4))).addContainerGap()));
    }

    private void set_character_review(String hanzi) {
        ArrayList<String> pinyins = this.main_database.get_pinyin_from_character(hanzi);
        String pinyin_list = "";
        if (pinyins.size() != 0) {
            int i;
            for (i = pinyins.size() - 1; i >= 0; --i) {
                String pinyin_to_check = pinyins.get(i);
                char tone = pinyin_to_check.charAt(pinyin_to_check.length() - 1);
                boolean found = false;
                if (tone >= '1' && tone <= '4') continue;
                for (int j = 0; j < pinyins.size(); ++j) {
                    if (i == j || !pinyins.get(j).startsWith(pinyin_to_check)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                pinyins.remove(i);
            }
            pinyin_list = PinyinParser.convert_to_printed_version(pinyins.get(0));
            for (i = 1; i < pinyins.size(); ++i) {
                pinyin_list = pinyin_list + ", " + PinyinParser.convert_to_printed_version(pinyins.get(i));
            }
        }
        this.PinyinsTextfield.setText(pinyin_list);
        this.CharacterLabel.setText(hanzi);
        this.CharTableFiller.set_filter(hanzi);
        this.CharTableFiller.fireTableDataChanged();
    }

    private void NextCharacterButtonrandom_character_action(ActionEvent evt) {
        int index;
        String hanzi;
        int num_char = this.main_database.get_number_characters();
        if (num_char == 0) {
            return;
        }
        while (this.character_history.contains(hanzi = this.main_database.get_character_details(index = (int)(Math.random() * (double)num_char) + 1))) {
        }
        this.character_history.add(hanzi);
        if (this.character_history.size() > (num_char - 1) / 2) {
            this.character_history.remove(0);
        }
        this.set_character_review(hanzi);
    }

    private void CharsearchentryTextFieldCharSearchButtonAction(ActionEvent evt) {
        String char_to_search = this.CharsearchentryTextField.getText();
        int num_char = this.main_database.get_number_characters();
        if (char_to_search.codePointCount(0, char_to_search.length()) != 1) {
            return;
        }
        this.character_history.add(char_to_search);
        if (this.character_history.size() > (num_char - 1) / 2) {
            this.character_history.remove(0);
        }
        this.set_character_review(char_to_search);
    }

    private void CharsearchentryTextFieldFocusGained(FocusEvent evt) {
        this.CharsearchentryTextField.getInputContext().selectInputMethod(Locale.CHINA);
    }

    private void CharsearchentryTextFieldFocusLost(FocusEvent evt) {
        this.CharsearchentryTextField.getInputContext().selectInputMethod(Locale.getDefault());
    }

    private void CharSearchButtonAction(ActionEvent evt) {
        String char_to_search = this.CharsearchentryTextField.getText();
        int num_char = this.main_database.get_number_characters();
        if (char_to_search.codePointCount(0, char_to_search.length()) != 1) {
            return;
        }
        this.character_history.add(char_to_search);
        if (this.character_history.size() > (num_char - 1) / 2) {
            this.character_history.remove(0);
        }
        this.set_character_review(char_to_search);
    }

    private void CharPreviousButtonActionPerformed(ActionEvent evt) {
        if (this.character_history.size() <= 1) {
            return;
        }
        String hanzi = this.character_history.get(this.character_history.size() - 2);
        this.character_history.remove(this.character_history.size() - 1);
        this.set_character_review(hanzi);
    }

    private void CharDBTableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            int row = this.CharDBTable.getSelectedRow();
            String chinese_word = (String)this.CharTableFiller.getValueAt(row, 0);
            this.parent_app.edit_word(chinese_word);
        }
    }
}

