/*****
 *       xhackometer - part of the Hackometer project
 *                                                                   
 * xhackometer records keyboard and mouse and cache files
 * for later delivery to hackometer server
 *                                                                   
 *        Copyright (C) 2009 Henrik Sandklef      
 *                                                                   
 * This program is free software; you can redistribute it and/or     
 * modify it under the terms of the GNU General Public License       
 * as published by the Free Software Foundation; either version 3    
 * of the License, or any later version.                             
 *                                                                   
 *                                                                   
 * This program is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of    
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     
 * GNU General Public License for more details.                      
 *                                                                   
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software       
 * Foundation, Inc., 51 Franklin Street, Boston,            
 * MA  02110-1301, USA.                                              
 ****/


#ifndef XHM_COLLECT_SELECT_H
#define XHM_COLLECT_SELECT_H

#include <stdio.h>
#include <time.h>

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>

#include "xhm/xhm.h"

#define NR_OF_EVENTS_MAX 500
#define LOOP_WINDOWS_MAX 5

#define KEY_BUFF_SIZE 256

#define COULD_NOT_SELECT 1
#define KEY_BUFF_SIZE 256
static char key_buff[KEY_BUFF_SIZE];


int
start_query(xhm_data *xd);


int
select_all_windows(xhm_data *xd, Display *dpy, Window root, unsigned long type);


int 
query_error_handler (Display *dpy, XErrorEvent *err);


char *
TranslateKeyCode(XEvent *ev);

char *
xhm_print_event (int ev);


#endif /* XHM_COLLECT_SELECT_H */
