/* config.h: Prototypes and declarations for config.c
 * Copyright (C) 2018 Julian Graham
 *
 * gzochi is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GZOCHID_CONFIG_H
#define GZOCHID_CONFIG_H

#include <glib.h>
#include <glib-object.h>

/* Injectable configuration type definitions. */

#define GZOCHID_TYPE_CONFIGURATION gzochid_configuration_get_type ()

/*
  `GzochidConfiguration' is the global configuration object for gzochid. New
  instances may be constructed by `g_object_new', with the following 
  properties:

  - "key_file": The `GKeyFile' on which to base the configuration. Required.
  - "path": The location of the key file on disk, if this configuration is disk-
    backed / non-synthetic. Optional. This property is readable.

  Note that because neither of these properties is injectable, 
  `GzochidConfiguration' instances cannot be constructed by the resolver, but 
  an explicitly-constructed `GzochidConfiguration' can be added to a require 
  resolution context via `gzochid_resolver_provide'. 
*/

G_DECLARE_FINAL_TYPE (GzochidConfiguration, gzochid_configuration, GZOCHID,
		      CONFIGURATION, GObject);

gboolean gzochid_config_to_boolean (char *, gboolean);
int gzochid_config_to_int (char *, int);
long gzochid_config_to_long (char *, long);

GHashTable *gzochid_config_keyfile_extract_config (GKeyFile *, const char *);

/* Extracts the key-value group with the specified name from the 
   specified `GzochidConfiguration' object and returns it as a `GHashTable',
   which should be freed via `g_hashtable_unref' or `g_hash_table_destroy' when
   no longer necessary. */   

GHashTable *gzochid_configuration_extract_group
(GzochidConfiguration *, const char *);

#endif /* GZOCHID_CONFIG_H */
