/* views.c: Pre-computed view data for gzochi mazewar example game
 * Copyright (C) 2012 Julian Graham
 *
 * This is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "views.h"

/* A table of pre-computed edges for drawing the first-person 3-D view of the 
   maze. This data is partially derived from data in the HP-UX Mazewar 
   distribution by Christopher A. Kent. */

mazewar_edge mazewar_view_edges[] = {
  {{ 33, 166 }, { 33, 33 }}, {{ 33, 166 }, { 166, 166 }},
  {{ 33, 33 }, { 166, 33 }}, {{ 0, 200 }, { 33, 166 }},
  {{ 0, 0 }, { 33, 33 }}, {{ 0, 166 }, { 33, 166 }},
  {{ 0, 33 }, { 33, 33 }}, {{ 166, 166 }, { 166, 33 }},
  {{ 166, 166 }, { 200, 166 }}, {{ 166, 33 }, { 200, 33 }},
  {{ 166, 166 }, { 200, 200 }}, {{ 166, 33 }, { 200, 0 }},
  {{ 60, 140 }, { 60, 60 }}, {{ 60, 140 }, { 140, 140 }},
  {{ 60, 60 }, { 140, 60 }}, {{ 33, 166 }, { 60, 140 }},
  {{ 33, 33 }, { 60, 60 }}, {{ 33, 140 }, { 60, 140 }},
  {{ 33, 60 }, { 60, 60 }}, {{ 140, 140 }, { 140, 60 }},
  {{ 140, 140 }, { 166, 140 }}, {{ 140, 60 }, { 166, 60 }},
  {{ 140, 140 }, { 166, 166 }}, {{ 140, 60 }, { 166, 33 }},
  {{ 71, 128 }, { 71, 71 }}, {{ 71, 128 }, { 128, 128 }},
  {{ 71, 71 }, { 128, 71 }}, {{ 60, 140 }, { 71, 128 }},
  {{ 60, 60 }, { 71, 71 }}, {{ 60, 128 }, { 71, 128 }},
  {{ 60, 71 }, { 71, 71 }}, {{ 128, 128 }, { 128, 71 }},
  {{ 128, 128 }, { 140, 128 }}, {{ 128, 71 }, { 140, 71 }},
  {{ 128, 128 }, { 140, 140 }}, {{ 128, 71 }, { 140, 60 }},
  {{ 78, 122 }, { 78, 78 }}, {{ 78, 122 },  { 122, 122 }},
  {{ 78, 78 }, { 122, 78 }}, {{ 71, 128 }, { 78, 122 }},
  {{ 71, 71 }, { 78, 78 }}, {{ 71, 122 }, { 78, 122 }},
  {{ 71, 78 }, { 78, 78 }}, {{ 122, 122 }, { 122, 78 }},
  {{ 122, 122 }, { 128, 122 }}, {{ 122, 78 }, { 128, 78 }},
  {{ 122, 122 }, { 128, 128 }}, {{ 122, 78 }, { 128, 71 }},
  {{ 82, 118 }, { 82, 82 }}, {{ 82, 118 }, { 118, 118 }},
  {{ 82, 82 }, { 118, 82 }}, {{ 78, 122 }, { 82, 118 }},
  {{ 78, 78 }, { 82, 82 }}, {{ 78, 118 }, { 82, 118 }},
  {{ 78, 82 }, { 82, 82 }}, {{ 118, 118 }, { 118, 82 }},
  {{ 118, 118 }, { 122, 118 }}, {{ 118, 82 }, { 122, 82 }},
  {{ 118, 118 }, { 122, 122 }}, {{ 118, 82 }, { 122, 78 }},
  {{ 85, 115 }, { 85, 85 }}, {{ 85, 115 }, { 115, 115 }},
  {{ 85, 85 }, { 115, 85 }}, {{ 82, 118 }, { 85, 115 }},
  {{ 82, 82 }, { 85, 85 }}, {{ 82, 115 }, { 85, 115 }},
  {{ 82, 85 }, { 85, 85 }}, {{ 115, 115 }, { 115, 85 }},
  {{ 115, 115 }, { 118, 115 }}, {{ 115, 85 }, { 118, 85 }},
  {{ 115, 115 }, { 118, 118 }}, {{ 115, 85 }, { 118, 82 }},
  {{ 87, 113 }, { 87, 87 }}, {{ 87, 113 }, { 113, 113 }},
  {{ 87, 87 }, { 113, 87 }}, {{ 85, 115 }, { 87, 113 }},
  {{ 85, 85 }, { 87, 87 }}, {{ 85, 113 }, { 87, 113 }},
  {{ 85, 87 }, { 87, 87 }}, {{ 113, 113 }, { 113, 87 }},
  {{ 113, 113 }, { 115, 113 }}, {{ 113, 87 }, { 115, 87 }},
  {{ 113, 113 }, { 115, 115 }}, {{ 113, 87 }, { 115, 85 }},
  {{ 88, 111 }, { 88, 88 }}, {{ 88, 111 }, { 111, 111 }},
  {{ 88, 88 }, { 111, 88 }}, {{ 87, 113 }, { 88, 111 }},
  {{ 87, 87 }, { 88, 88 }}, {{ 87, 111 }, { 88, 111 }},
  {{ 87, 88 }, { 88, 88 }}, {{ 111, 111 }, { 111, 88 }},
  {{ 111, 111 }, { 113, 111 }}, {{ 111, 88 }, { 113, 88 }},
  {{ 111, 111 }, { 113, 113 }}, {{ 111, 88 }, { 113, 87 }},
  {{ 89, 110 }, { 89, 89 }}, {{ 89, 110 }, { 110, 110 }},
  {{ 89, 89 }, { 110, 89 }}, {{ 88, 111 }, { 89, 110 }},
  {{ 88, 88 }, { 89, 89 }}, {{ 88, 110 }, { 89, 110 }},
  {{ 88, 89 }, { 89, 89 }}, {{ 110, 110 }, { 110, 89 }},
  {{ 110, 110 }, { 111, 110 }}, {{ 110, 89 }, { 111, 89 }},
  {{ 110, 110 }, { 111, 111 }}, {{ 110, 89 }, { 111, 88 }},
  {{ 90, 109 }, { 90, 90 }}, {{ 90, 109 }, { 109, 109 }},
  {{ 90, 90 }, { 109, 90 }}, {{ 89, 110 }, { 90, 109 }},
  {{ 89, 89 }, { 90, 90 }}, {{ 89, 109 }, { 90, 109 }},
  {{ 89, 90 }, { 90, 90 }}, {{ 109, 109 }, { 109, 90 }},
  {{ 109, 109 }, { 110, 109 }}, {{ 109, 90 }, { 110, 90 }},
  {{ 109, 109 }, { 110, 110 }}, {{ 109, 90 }, { 110, 89 }},
  {{ 91, 108 }, { 91, 91 }}, {{ 91, 108 }, { 108, 108 }},
  {{ 91, 91 }, { 108, 91 }}, {{ 90, 109 }, { 91, 108 }},
  {{ 90, 90 }, { 91, 91 }}, {{ 90, 108 }, { 91, 108 }},
  {{ 90, 91 }, { 91, 91 }}, {{ 108, 108 }, { 108, 91 }},
  {{ 108, 108 }, { 109, 108 }}, {{ 108, 91 }, { 109, 91 }},
  {{ 108, 108 }, { 109, 109 }}, {{ 108, 91 }, { 109, 90 }},
  {{ 92, 108 }, { 92, 92 }}, {{ 92, 108 }, { 108, 108 }},
  {{ 92, 92 }, { 108, 92 }}, {{ 91, 108 }, { 92, 108 }},
  {{ 91, 91 }, { 92, 92 }}, {{ 91, 108 }, { 92, 108 }},
  {{ 91, 92 }, { 92, 92 }}, {{ 108, 108 }, { 108, 92 }},
  {{ 108, 108 }, { 108, 108 }}, {{ 108, 92 }, { 108, 92 }},
  {{ 108, 108 }, { 108, 108 }}, {{ 108, 92 }, { 108, 91 }},
  {{ 93, 107 }, { 93, 93 }}, {{ 93, 107 }, { 107, 107 }},
  {{ 93, 93 }, { 107, 93 }}, {{ 92, 108 }, { 93, 107 }},
  {{ 92, 92 }, { 93, 93 }}, {{ 92, 107 }, { 93, 107 }},
  {{ 92, 93 }, { 93, 93 }}, {{ 107, 107 }, { 107, 93 }},
  {{ 107, 107 }, { 108, 107 }}, {{ 107, 93 }, { 108, 93 }},
  {{ 107, 107 }, { 108, 108 }}, {{ 107, 93 }, { 108, 92 }},
  {{ 93, 106 }, { 93, 93 }}, {{ 93, 106 }, { 106, 106 }},
  {{ 93, 93 }, { 106, 93 }}, {{ 93, 107 }, { 93, 106 }},
  {{ 93, 93 }, { 93, 93 }}, {{ 93, 106 }, { 93, 106 }},
  {{ 93, 93 }, { 93, 93 }}, {{ 106, 106 }, { 106, 93 }},
  {{ 106, 106 }, { 107, 106 }}, {{ 106, 93 }, { 107, 93 }},
  {{ 106, 106 }, { 107, 107 }}, {{ 106, 93 }, { 107, 93 }},
  {{ 94, 106 }, { 94, 94 }}, {{ 94, 106 }, { 106, 106 }},
  {{ 94, 94 }, { 106, 94 }}, {{ 93, 106 }, { 94, 106 }},
  {{ 93, 93 }, { 94, 94 }}, {{ 93, 106 }, { 94, 106 }},
  {{ 93, 94 }, { 94, 94 }}, {{ 106, 106 }, { 106, 94 }},
  {{ 106, 106 }, { 106, 106 }}, {{ 106, 94 }, { 106, 93 }},
  {{ 106, 106 }, { 106, 106 }}, {{ 106, 94 }, { 106, 94 }},
  {{ 94, 106 }, { 94, 94 }}, {{ 94, 106 }, { 106, 106 }},
  {{ 94, 94 }, { 106, 94 }}, {{ 94, 106 }, { 94, 106 }},
  {{ 94, 94 }, { 94, 94 }}, {{ 94, 106 }, { 94, 106 }},
  {{ 94, 94 }, { 94, 94 }}, {{ 106, 106 }, { 106, 94 }},
  {{ 106, 106 }, { 106, 106 }}, {{ 106, 94 }, { 106, 94 }},
  {{ 106, 106 }, { 106, 106 }}, {{ 106, 94 }, { 106, 94 }},
  {{ 94, 105 }, { 94, 94 }}, {{ 94, 105 }, { 105, 105 }},
  {{ 94, 94 }, { 105, 94 }}, {{ 94, 106 }, { 94, 105 }},
  {{ 94, 94 }, { 94, 94 }}, {{ 94, 105 }, { 94, 105 }},
  {{ 94, 94 }, { 94, 94 }}, {{ 105, 105 }, { 105, 94 }},
  {{ 105, 105 }, { 106, 105 }}, {{ 105, 94 }, { 106, 94 }},
  {{ 105, 105 }, { 106, 106 }}, {{ 105, 94 }, { 106, 94 }},
  {{ 95, 105 }, { 95, 95 }}, {{ 95, 105 }, { 105, 105 }},
  {{ 95, 95 }, { 105, 95 }}, {{ 94, 105 }, { 95, 105 }},
  {{ 94, 94 }, { 95, 95 }}, {{ 94, 105 }, { 95, 105 }},
  {{ 94, 95 }, { 95, 95 }}, {{ 105, 105 }, { 105, 95 }},
  {{ 105, 105 }, { 105, 105 }}, {{ 105, 95 }, { 105, 95 }},
  {{ 105, 105 }, { 105, 105 }}, {{ 105, 95 }, { 105, 94 }},
  {{ 95, 105 }, { 95, 95 }}, {{ 95, 105 }, { 105, 105 }},
  {{ 95, 95 }, { 105, 95 }}, {{ 95, 105 }, { 95, 105 }},
  {{ 95, 95 }, { 95, 95 }}, {{ 95, 105 }, { 95, 105 }},
  {{ 95, 95 }, { 95, 95 }}, {{ 105, 105 }, { 105, 95 }},
  {{ 105, 105 }, { 105, 105 }}, {{ 105, 95 }, { 105, 95 }},
  {{ 105, 105 }, { 105, 105 }}, {{ 105, 95 }, { 105, 95 }},
  {{ 95, 104 }, { 95, 95 }}, {{ 95, 104 }, { 104, 104 }},
  {{ 95, 95 }, { 104, 95 }}, {{ 95, 105 }, { 95, 104 }},
  {{ 95, 95 }, { 95, 95 }}, {{ 95, 104 }, { 95, 104 }},
  {{ 95, 95 }, { 95, 95 }}, {{ 104, 104 }, { 104, 95 }},
  {{ 104, 104 }, { 105, 104 }}, {{ 104, 95 }, { 105, 95 }},
  {{ 104, 104 }, { 105, 105 }}, {{ 104, 95 }, { 105, 95 }},
  {{ 95, 104 }, { 95, 95 }}, {{ 95, 104 }, { 104, 104 }},
  {{ 95, 95 }, { 104, 95 }}, {{ 95, 104 }, { 95, 104 }},
  {{ 95, 95 }, { 95, 95 }}, {{ 95, 104 }, { 95, 104 }},
  {{ 95, 95 }, { 95, 95 }}, {{ 104, 104 }, { 104, 95 }},
  {{ 104, 104 }, { 104, 104 }}, {{ 104, 95 }, { 104, 95 }},
  {{ 104, 104 }, { 104, 104 }}, {{ 104, 95 }, { 104, 95 }},
  {{ 96, 104 }, { 96, 96 }}, {{ 96, 104 }, { 104, 104 }},
  {{ 96, 96 }, { 104, 96 }}, {{ 95, 104 }, { 96, 104 }},
  {{ 95, 95 }, { 96, 96 }}, {{ 95, 104 }, { 96, 104 }},
  {{ 95, 96 }, { 96, 96 }}, {{ 104, 104 }, { 104, 96 }},
  {{ 104, 104 }, { 104, 104 }}, {{ 104, 96 }, { 104, 96 }},
  {{ 104, 104 }, { 104, 104 }}, {{ 104, 96 }, { 104, 95 }},
  {{ 96, 104 }, { 96, 96 }}, {{ 96, 104 }, { 104, 104 }},
  {{ 96, 96 }, { 104, 96 }}, {{ 96, 104 }, { 96, 104 }},
  {{ 96, 96 }, { 96, 96 }}, {{ 96, 104 }, { 96, 104 }},
  {{ 96, 96 }, { 96, 96 }}, {{ 104, 104 }, { 104, 96 }},
  {{ 104, 104 }, { 104, 104 }}, {{ 104, 96 }, { 104, 96 }},
  {{ 104, 104 }, { 104, 104 }}, {{ 104, 96 }, { 104, 96 }},
  {{ 96, 104 }, { 96, 96 }}, {{ 96, 104 }, { 104, 104 }},
  {{ 96, 96 }, { 104, 96 }}, {{ 96, 104 }, { 96, 104 }},
  {{ 96, 96 }, { 96, 96 }}, {{ 96, 104 }, { 96, 104 }},
  {{ 96, 96 }, { 96, 96 }}, {{ 104, 104 }, { 104, 96 }},
  {{ 104, 104 }, { 104, 104 }}, {{ 104, 96 }, { 104, 96 }},
  {{ 104, 104 }, { 104, 104 }}, {{ 104, 96 }, { 104, 96 }},
  {{ 96, 103 }, { 96, 96 }}, {{ 96, 103 }, { 103, 103 }},
  {{ 96, 96 }, { 103, 96 }}, {{ 96, 104 }, { 96, 103 }},
  {{ 96, 96 }, { 96, 96 }}, {{ 96, 103 }, { 96, 103 }},
  {{ 96, 96 }, { 96, 96 }}, {{ 103, 103 }, { 103, 96 }},
  {{ 103, 103 }, { 104, 103 }}, {{ 103, 96 }, { 104, 96 }},
  {{ 103, 103 }, { 104, 104 }}, {{ 103, 96 }, { 104, 96 }},
  {{ 96, 103 }, { 96, 96 }}, {{ 96, 103 }, { 103, 103 }},
  {{ 96, 96 }, { 103, 96 }}, {{ 96, 103 }, { 96, 103 }},
  {{ 96, 96 }, { 96, 96 }}, {{ 96, 103 }, { 96, 103 }},
  {{ 96, 96 }, { 96, 96 }}, {{ 103, 103 }, { 103, 96 }},
  {{ 103, 103 }, { 103, 103 }}, {{ 103, 96 }, { 103, 96 }},
  {{ 103, 103 }, { 103, 103 }}, {{ 103, 96 }, { 103, 96 }},
  {{ 96, 103 }, { 96, 96 }}, {{ 96, 103 }, { 103, 103 }},
  {{ 96, 96 }, { 103, 96 }}, {{ 96, 103 }, { 96, 103 }},
  {{ 96, 96 }, { 96, 96 }}, {{ 96, 103 }, { 96, 103 }},
  {{ 96, 96 }, { 96, 96 }}, {{ 103, 103 }, { 103, 96 }},
  {{ 103, 103 }, { 103, 103 }}, {{ 103, 96 }, { 103, 96 }},
  {{ 103, 103 }, { 103, 103 }}, {{ 103, 96 }, { 103, 96 }},
  {{ 96, 103 }, { 96, 96 }}, {{ 96, 103 }, { 103, 103 }},
  {{ 96, 96 }, { 103, 96 }}, {{ 96, 103 }, { 96, 103 }},
  {{ 96, 96 }, { 96, 96 }}, {{ 96, 103 }, { 96, 103 }},
  {{ 96, 96 }, { 96, 96 }}, {{ 103, 103 }, { 103, 96 }},
  {{ 103, 103 }, { 103, 103 }}, {{ 103, 96 }, { 103, 96 }},
  {{ 103, 103 }, { 103, 103 }}, {{ 103, 96 }, { 103, 96 }},
  {{ 97, 103 }, { 97, 97 }}, {{ 97, 103 }, { 103, 103 }},
  {{ 97, 97 }, { 103, 97 }}, {{ 96, 103 }, { 97, 103 }},
  {{ 96, 96 }, { 97, 97 }}, {{ 96, 103 }, { 97, 103 }},
  {{ 96, 97 }, { 97, 97 }}, {{ 103, 103 }, { 103, 97 }},
  {{ 103, 103 }, { 103, 103 }}, {{ 103, 97 }, { 103, 97 }},
  {{ 103, 103 }, { 103, 103 }}, {{ 103, 97 }, { 103, 96 }},
  {{ 97, 103 }, { 97, 97 }}, {{ 97, 103 }, { 103, 103 }},
  {{ 97, 97 }, { 103, 97 }}, {{ 97, 103 }, { 97, 103 }},
  {{ 97, 97 }, { 97, 97 }}, {{ 97, 103 }, { 97, 103 }},
  {{ 97, 97 }, { 97, 97 }}, {{ 103, 103 }, { 103, 97 }},
  {{ 103, 103 }, { 103, 103 }}, {{ 103, 97 }, { 103, 97 }},
  {{ 103, 103 }, { 103, 103 }}, {{ 103, 97 }, { 103, 97 }}
};
