/*  GTKtalog.
 *  Copyright (C) 2001 Yves Mettier
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>

#include "about.h"
#include "splash.h"
#include "setup.h"
#include "config_common.h"

static GtkWidget *splash_window = NULL;


static void
splash_destroy_cb (GtkObject * obj, gpointer data)
{
  splash_window = NULL;
}

static void
splash_button_cb (GtkObject * obj, gpointer data)
{
  if (splash_window)
    {
      gtk_widget_destroy (splash_window);
      splash_window = NULL;
    }
}

static gint
splash_timeout (gpointer t)
{
  if (splash_window)
    {
      gtk_widget_destroy (splash_window);
      splash_window = NULL;
    }

  return FALSE;
}

void
splash_screen (GtkWidget * w)
{
  PIX *pix;
  GtkStyle *style;
  GtkWidget *splash_pixmap;

  if (splash_window)
    return;

  if (!my_config->display_splash)
    return;

  splash_window = gtk_window_new (GTK_WINDOW_POPUP);

  gtk_signal_connect (GTK_OBJECT (splash_window), "destroy",
		      GTK_SIGNAL_FUNC (splash_destroy_cb), NULL);

  gtk_window_set_title (GTK_WINDOW (splash_window), "GTKtalog");
  gtk_window_set_position (GTK_WINDOW (splash_window), GTK_WIN_POS_CENTER);
  gtk_window_set_policy (GTK_WINDOW (splash_window), FALSE, FALSE, FALSE);

  style = gtk_widget_get_style (GTK_WIDGET (w));
  if (!g_file_test (DATA_DIR "/gtktalog/icons/logo.xpm", G_FILE_TEST_IS_REGULAR))
    {
      WARNING_DIALOG (_("Can't find splash pixmap"), main_window);
      gtk_widget_destroy (splash_window);
      return;
    }


  pix = (PIX *) g_malloc (sizeof (PIX));
  pix->mask = (GdkBitmap **) g_malloc (sizeof (GdkBitmap **));
  pix->pixmap =
    gdk_pixmap_create_from_xpm (GTK_WIDGET (w)->window, pix->mask,
				&style->bg[GTK_STATE_NORMAL],
				DATA_DIR "/gtktalog/icons/logo.xpm");

  splash_pixmap = gtk_pixmap_new (pix->pixmap, *(pix->mask));

  if (!splash_pixmap)
    {
      WARNING_DIALOG (_("Could not load splash pixmap"), main_window);
      gtk_widget_destroy (splash_window);
      return;
    }

  gtk_container_add (GTK_CONTAINER (splash_window), splash_pixmap);

  GTK_WIDGET_SET_FLAGS (splash_window, GTK_CAN_DEFAULT);
  gtk_widget_set_events (splash_window, GDK_BUTTON_PRESS_MASK);
  gtk_widget_set_extension_events (splash_window, GDK_EXTENSION_EVENTS_ALL);
  gtk_signal_connect (GTK_OBJECT (splash_window), "button_press_event",
		      GTK_SIGNAL_FUNC (splash_button_cb), NULL);


  gtk_widget_show (splash_pixmap);
  gtk_widget_show (splash_window);

  gtk_window_set_transient_for (GTK_WINDOW (splash_window),
				GTK_WINDOW (main_window));

  gtk_timeout_add (1000, splash_timeout, NULL);
}
