/*  GTKtalog.
 *  Copyright (C) 2000  Yves Mettier
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __CONFIG_STRUCT__
#define __CONFIG_STRUCT__

#include <config.h>
#include <gnome.h>
#include <time.h>

#ifdef __DEBUG__
#include <GML.h>
#endif

#define USER_CONFIG_DIR "/.gtktalog"
#define USER_CONFIG_FILE "gtktalog.cf"

#define FSTAB_FILE "/etc/fstab"

#define CATEGORY_MAX_LENGTH 64
#define DEFINITION_MAX_LENGTH 1024
#define INFORMATION_MAX_LENGTH 128
#define READLINE_MAX_LENGTH 2048

#define MAX_STRING_LENGTH 1024
/*
 *	IIRC, and ISO CD can't have more than 20 chars in its
 *	label? Shouldn't pose a problem, now should it? 
 */
#define MAX_DISK_LABEL_LENGTH 20

#define CAT_TREE_UP	1
#define CAT_TREE_DOWN	2
#define CAT_TREE_0	0
#define CAT_TREE_END	99

#define THREAD_SCAN_RUNNING_NO		1
#define THREAD_SCAN_RUNNING_YES		2
#define THREAD_SCAN_RUNNING_ENDED	3

#define TEST_VFS_NO       1
#define TEST_VFS_YES      2
#define TEST_VFS_EXTENDED 3

#define COMPARE_EXACT	1
#define COMPARE_REGEX	2
#define COMPARE_GLOB	3

#define EVERYTHING_MATCHES 0
#define EXACT_MATCH_CS 1
#define EXACT_MATCH_CU 2
#define CONTAINS_CS 3
#define CONTAINS_CU 4
#define GLOB_CS 5
#define GLOB_CU 6
#define REGULAR_EXPRESSION_CS 7
#define REGULAR_EXPRESSION_CU 8
#define STRING_SM_NB 9		/* Nb of strings in STRING_SM */


#define ERROR_DIALOG(msg, w) gnome_dialog_run_and_close(GNOME_DIALOG(gnome_error_dialog_parented(msg, GTK_WINDOW (w))));
#define WARNING_DIALOG(msg, w) gnome_dialog_run_and_close(GNOME_DIALOG(gnome_warning_dialog_parented(msg, GTK_WINDOW (w))));

#define SAVE_CAT_MODE__ALL         1
#define SAVE_CAT_MODE__ONLY_USED   2

#define FDMASK_CATEGORY		0x1
#define FDMASK_DESCRIPTION	0x2
#define FDMASK_INFORMATION	0x4
#define FDMASK_MIME		0x8

#define CATMASK_CATEGORY	0x2
#define CATMASK_DESCRIPTION	0x1

#define GNOMEAPPBAR_MAIN	0
#define GNOMEAPPBAR_SEARCH	1

#define PROGRESS_BAR_TIMEOUT	2000

#define GNOMEAPPBAR_NB		2

#define	MOUNT_RETRY_TIMEOUT	5



/*********************** structures for the file tree ***********************/
typedef struct
{
  GPtrArray *datas;
  GNode *tree;

  GPtrArray *descriptions;
  GPtrArray *categories;

  GtkWidget *ctree;
  gint ctree_tree_expand_signal_id;

  GNode *selected_folder;
  GNode *currently_displayed_gnode;

  gboolean is_modified;

  GString *catalog_filename;
  gboolean catalog_filename_is_valid;
}
FOLDER;

typedef struct
{
  guint32 id;			/* index in the array containing all the FILE_DATA */
  GString *name;		/* name of the file/dir */
  guint32 taille;		/* length of the file/dir */
  guint16 type;			/* type of the file/dir */
  time_t date;			/* time_t */
  GString *mime;		/* Mime type of the file */
  guint16 categorie;
  guint16 description;
  GString *information;
  GNode *node;			/* gnode associated with this FILE_DATA */
  GtkCTreeNode *ctree_node;	/* ctree_node associated with this FILE_DATA */
  
  gint a_parent_node_is_vfs;	/* This gint means that the file is inside a vfs.
                                 * The content of this gint is the type of vfs
				 */
}
FILE_DATA;

/************ main structure to be used in nearly all functions **************/
typedef struct
{
  GdkPixmap *pixmap;
  GdkBitmap **mask;
  GString *path;
  gboolean used;	/* Warning: this is only used during the garbage collection in
                         * setup.c. Consider this field as unset.
			 */
}
PIX;

typedef struct
{
  GString *mime;
  GString *prog;
  GString *arg;
  gboolean state;
}
MIME_EXTENSIONS;

typedef struct
{
  GString *mime;
  GString *prog;
  GString *args;
  GString *separator;
  gint date;			/* First field is 0 */
  GString *date_format;		/* A string like "DD-MM-YYYY" or "YY-MM-DD" for example */
  gint size;
  gint name;
  gboolean state;
}
MIME_VFS_EXTENSIONS;

typedef struct
{
  gchar *fullname;
  gchar *label;
}
RECENT_FILE;

typedef struct
{
  GTree *mime_icons;		/* key=extension; value=PIX */
  GTree *pix_paths;		/* key=path; value=PIX */
  PIX *default_file_pix;
  PIX *default_dir_pix;
  PIX *default_disk_pix;
  PIX *default_unreadable_pix;
  PIX *default_vfs_pix;
  PIX *default_opened_dir_pix;
  PIX *default_opened_disk_pix;
  PIX *default_opened_vfs_pix;
  GTree *mime_extensions;
  GTree *mime_vfs_extensions;
  
  GTree *mime_to_skip_during_a_scan;

  gboolean getInformation;
  gint testvfs;

  GtkWidget *search_dirtree;
  gboolean update_edit_window;
  gpointer category_widgets;
  gpointer search_widgets;
  gpointer calendar_widgets;

  FOLDER *racine;

  pid_t current_pid;

  GString *mount;
  GString *umount;
  GString *eject_prog;
  GString *mount_point;
  GString *mount_device;
  GString *dummy_prog;
  gboolean use_supermount;
  gboolean use_automount;
  gint mount_retry;

  /* Options */
  gboolean use_du_s;
  gboolean warn_mount;
  gboolean eject_disk;
  gboolean read_cd_name;
  gboolean validate_cd_name;
  gboolean dbclick_opens_info;
  gboolean display_dir_size;
  gboolean save_only_used_categories;
  gboolean scan_mime_types;
  gboolean use_default_information_plugin;
  MIME_EXTENSIONS *default_information_plugin;

  gint compression_level;
  
  GList *recent_files;
  gint nb_max_recent_files;
  gint currently_displayed_recent_files;
  
  gchar *date_format;

  gint previous_search_mode;
  
  gint mainwindow_x;
  gint mainwindow_y;
  gint mainwindow_w;
  gint mainwindow_h;
  gboolean mainwindow_save_xywh;
  
  gint sort_column;

/* What is that? */
  char *fast_name;
  char *working_path;

}
CONFIG;

/* To use an icon, just look for it with:
mypixmap = ((PIX*)(g_tree_lookup(extension)))->pixmap
*/

/*************** Structure to be used in load/save catalogs ****************/
typedef struct
{
  guint type;
  guint32 taille;
  time_t date;
  guint32 categorie;
  guint32 description;
}
DATAS;

/******************** Structures and funcs for lex/yacc **********************/
typedef struct
{
  GString *key;
  gpointer value;
}
KEY_VALUE;

/* Function headers */
/* config_parser. */
gboolean check_supermount (CONFIG * my_config);
void config_struct_free_1 (GList * gl);
int yyerror (char *s);
void yyrestart (FILE * new_file);
CONFIG *init_config (GtkWidget * w);

/* config_lex.l */
int yylex (void);

extern GtkWidget *main_window;
extern GtkWidget *path_entry;
extern GtkWidget *clist;

extern CONFIG *my_config;

#endif
