/*
 * GTKtalog. *  Copyright (C) 1999-2000  Mathieu VILLEGAS * *  This program
 * is free software; you can redistribute it and/or modify *  it under the
 * terms of the GNU General Public License as published by *  the Free
 * Software Foundation; either version 2 of the License, or *  (at your
 * option) any later version. * *  This program is distributed in the hope
 * that it will be useful, *  but WITHOUT ANY WARRANTY; without even the
 * implied warranty of *  MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the *  GNU General Public License for more details. * *  You 
 * should have received a copy of the GNU General Public License *  along
 * with this program; if not, write to the Free Software *  Foundation, Inc., 
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 */

#include <config.h>
#include <gnome.h>

#include "config_common.h"
#include "interface.h"
#include "loadcat.h"
#include "savecat.h"
#include "exit.h"
#include "io.h"
#include "folder.h"

static GtkWidget *fs;
static GtkWidget *toggle_save_cat_mode;


PIX *
get_pix_from_gnode (GNode * gn)
{
  gchar *mime = NULL;
  FILE_DATA *fd;
  PIX *pix;

  if (is_unreadable (gn) == TRUE)
    {
      pix = my_config->default_unreadable_pix;
    }
  else
    {
      fd = get_file_data_from_gnode (gn);


      if (fd->mime)
	mime = g_strdup (fd->mime->str);
      if (!mime)
	mime = g_strdup (gnome_mime_type_or_default (fd->name->str, NULL));
      if (mime)
	{
	  pix = ((PIX *) g_tree_lookup (my_config->mime_icons, mime));
	  if (!pix)
	    {
	      if (is_dir (gn) == TRUE)
		pix = my_config->default_dir_pix;
	      else
		pix = my_config->default_file_pix;

	    }
	  g_free (mime);
	}
      else
	{
	  if (is_dir (gn) == TRUE)
	    pix = my_config->default_dir_pix;
	  else
	    pix = my_config->default_file_pix;

	}
    }
  return (pix);
}

/* This traversefunc creates a gtkctree_node with the data given with gn.
 * This gtkctree_node is inserted to data->ctree where data is FOLDER*.
 * It should better be called as a traversefunc with g_node_traverse
 */

gboolean
add_gnode_to_ctree (GNode * gn, gpointer data)
{
  FOLDER *racine = data;
  FILE_DATA *fd, *parent_fd, *child_fd;
  GtkCTreeNode *gtkparentnode;
  gboolean is_leaf;
  GNode *gn_child;
  PIX *pix;

  fd = get_file_data_from_gnode (gn);
  if (g_node_depth (gn) != 1)
    {
      gn_child = g_node_first_child (gn);
      is_leaf = TRUE;
      while ((gn_child) && (is_leaf == TRUE))
	{
	  child_fd = get_file_data_from_gnode (gn_child);
	  if ((child_fd->type == IS_DIR) || (child_fd->type == IS_VFS)
	      || (child_fd->type == IS_VFS_EXTENDED))
	    is_leaf = FALSE;
	  gn_child = g_node_next_sibling (gn_child);
	}

      if ((is_disk (gn) == TRUE) || (is_dir (gn) == TRUE)
	  || (is_vfs_any (gn) == TRUE))
	{
	  parent_fd = get_file_data_from_gnode (gn->parent);
	  gtkparentnode = parent_fd->ctree_node;
	  if (g_node_depth (gn) == 2)
	    pix = my_config->default_disk_pix;
	  else if (is_vfs_any (gn) == TRUE)
	    pix = my_config->default_vfs_pix;
	  else
	    pix = my_config->default_dir_pix;
	  fd->ctree_node =
	    gtk_ctree_insert_node (GTK_CTREE (racine->ctree),
				   gtkparentnode, NULL, &(fd->name->str), 4,
				   pix->pixmap, *(pix->mask), pix->pixmap,
				   *(pix->mask), is_leaf, FALSE);

	  gtk_ctree_node_set_row_data (GTK_CTREE (racine->ctree),
				       fd->ctree_node, gn);

	}
    }
  return (FALSE);
}

/*affiche la liste des fichiers quand un repertoire est selectionn */
static void
cb_itemsignal (GtkWidget * widget, GtkCTreeNode * node, gint z,
	       FOLDER * racine)
{
  GNode *gnode_data;
  gnode_data = gtk_ctree_node_get_row_data (GTK_CTREE (widget), node);
  if (G_NODE_IS_ROOT (gnode_data) != TRUE)
    {
      racine->selected_folder = gnode_data;

    }
  else
    {
      racine->selected_folder = NULL;
    }
}

/* quand un repertoire est deselectionne dans l'arbre */
static void
cb_itemsignal2 (GtkWidget * widget, GtkCTreeNode * node, gint i,
		FOLDER * racine)
{
  racine->selected_folder = NULL;
}

static gboolean
expand_cb (GtkWidget * widget, GtkCTreeNode * parent_node, FOLDER * racine)
{
  GNode *parent_gn;
  gboolean is_expanded = FALSE;

  parent_gn = gtk_ctree_node_get_row_data (GTK_CTREE (widget), parent_node);

  gtk_ctree_get_node_info (GTK_CTREE (racine->ctree), parent_node, NULL, NULL,
			   NULL, NULL, NULL, NULL, NULL, &is_expanded);

  set_currently_displayed_folder_pixtext (my_config->racine, TRUE);
  gtk_ctree_sort_node (GTK_CTREE (racine->ctree), parent_node);
  return (TRUE);
}

static gint
_clist_g_strnatcmp (GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2)
{
  char *text1 = NULL;
  char *text2 = NULL;
  char *p1, *p2;
  gint n1, n2;
  gint result;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  switch (row1->cell[clist->sort_column].type)
    {
    case GTK_CELL_TEXT:
      text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
      break;
    case GTK_CELL_PIXTEXT:
      text1 = GTK_CELL_PIXTEXT (row1->cell[clist->sort_column])->text;
      break;
    default:
      break;
    }

  switch (row2->cell[clist->sort_column].type)
    {
    case GTK_CELL_TEXT:
      text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;
      break;
    case GTK_CELL_PIXTEXT:
      text2 = GTK_CELL_PIXTEXT (row2->cell[clist->sort_column])->text;
      break;
    default:
      break;
    }

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

  result = 0;
  p1 = text1;
  p2 = text2;
  while ((p1[0] != 0) && (p1[0] != 0) && (result == 0))
    {
      if ((p1[0] >= '0') && (p1[0] <= '9') && (p2[0] >= '0')
	  && (p2[0] <= '9'))
	{
	  n1 = strtol (p1, NULL, 10);
	  n2 = strtol (p2, NULL, 10);
	  if (n1 > n2)
	    result = 1;
	  if (n1 < n2)
	    result = -1;
	  while ((p1[0] >= '0') && (p1[0] <= '9'))
	    p1++;
	  while ((p2[0] >= '0') && (p2[0] <= '9'))
	    p2++;
	}
      else
	{
	  result = strncmp (p1, p2, 1);
	  p1++;
	  p2++;
	}
    }
  if (p1[0] && (!p2[0]))
    result = -1;
  if (p2[0] && (!p1[0]))
    result = 1;

  return (result);
}

void
expand_folder (GNode * gn)
{
  FOLDER *racine;
  FILE_DATA *fd;
  racine = get_catalog_from_gnode (gn);

/*  gtk_signal_disconnect (GTK_OBJECT (racine->ctree),
			 racine->ctree_tree_expand_signal_id);
*/
  while (g_node_depth (gn) >= 2)
    {
      fd = get_file_data_from_gnode (gn);
      gtk_ctree_expand (GTK_CTREE (racine->ctree), fd->ctree_node);
      gn = gn->parent;
    }
/*  racine->ctree_tree_expand_signal_id =
    gtk_signal_connect_after (GTK_OBJECT (racine->ctree), "tree_expand",
			GTK_SIGNAL_FUNC (expand_cb), racine);
*/ }


/* Create the folder tree */
void
create_tree (FOLDER * racine)
{

  racine->ctree = gtk_ctree_new (1, 0);
  gtk_clist_set_column_auto_resize (GTK_CLIST (racine->ctree), 0, TRUE);
  gtk_clist_set_selection_mode (GTK_CLIST (racine->ctree),
				GTK_SELECTION_SINGLE);
  gtk_ctree_set_line_style (GTK_CTREE (racine->ctree),
			    GTK_CTREE_LINES_DOTTED);
  gtk_signal_connect (GTK_OBJECT (racine->ctree), "button_press_event",
		      GTK_SIGNAL_FUNC (tree_pressed), racine);

  racine->ctree_tree_expand_signal_id =
    gtk_signal_connect_after (GTK_OBJECT (racine->ctree), "tree_expand",
			      GTK_SIGNAL_FUNC (expand_cb), racine);
  gtk_signal_connect_after (GTK_OBJECT (racine->ctree), "tree_collapse",
			    GTK_SIGNAL_FUNC (expand_cb), racine);
  gtk_signal_connect_after (GTK_OBJECT (racine->ctree), "tree_select_row",
			    GTK_SIGNAL_FUNC (cb_itemsignal), racine);
  gtk_signal_connect_after (GTK_OBJECT (racine->ctree), "tree_unselect_row",
			    GTK_SIGNAL_FUNC (cb_itemsignal2), racine);

  gtk_object_set_user_data (GTK_OBJECT (racine->ctree), racine->tree);

  gtk_clist_set_compare_func (GTK_CLIST (racine->ctree), _clist_g_strnatcmp);
  gtk_clist_set_sort_column (GTK_CLIST (racine->ctree), 0);
  gtk_clist_set_sort_type (GTK_CLIST (racine->ctree), GTK_SORT_ASCENDING);
}



void
new_file ()
{
  gboolean new_anyway = TRUE;

  if (my_config->racine)
    {
      if (my_config->racine->is_modified == TRUE)
	{
	  if (yes_no_cancel_dialog
	      (_("New dialog"),
	       _("The catalog has not been saved. Lose it anyway?")) != 0)
	    {

	      new_anyway = FALSE;
	    }
	}
    }
  if (new_anyway == TRUE)
    {
      if (my_config->racine)
	{
	  gtk_clist_clear ((GtkCList *) clist);
	  clear_folder (my_config->racine);
	}
      gtk_entry_set_text (GTK_ENTRY (path_entry), "");
      my_config->racine = init_folder ();
      create_tree (my_config->racine);

      ctree_window_add (my_config->racine->ctree);
      update_tree (my_config->racine);
      menus_set_sensitive (TRUE);
    }

}

/*
 * ouverture d'un catalogue 
 */
void
open_cat_ok_sel (GtkWidget * w, gpointer data)
{
  FOLDER *racine = data;
  gchar *s, *p;

  gtk_clist_clear ((GtkCList *) clist);

  if (racine != NULL)
    {
      clear_folder (racine);
    }

  gtk_entry_set_text (GTK_ENTRY (path_entry), "");

  racine = init_folder ();
  create_tree (racine);

  my_config->racine = racine;

  s = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));
  if (load_cat_from_file (s, racine) == -1)
    {
      return;
    }
  g_free (my_config->working_path);
  my_config->working_path = g_strdup (s);
  p = my_config->working_path;
  while (p[0])
    p++;
  while (p[0] != '/')
    p--;
  p[1] = 0;

  gtk_widget_destroy (GTK_WIDGET (fs));
  g_node_traverse (racine->tree,
		   G_PRE_ORDER, G_TRAVERSE_ALL, -1, add_gnode_to_ctree,
		   racine);
  ctree_window_add (racine->ctree);
  update_tree (racine);

  gtk_window_set_title (GTK_WINDOW (main_window),
			racine->catalog_filename->str);
  menus_set_sensitive (TRUE);
}



void
open_cat (FOLDER * racine)
{
  if (racine != NULL)
    {
      if (racine->is_modified == TRUE)
	{
	  if (yes_no_cancel_dialog (_("Open dialog"),
				    _
				    ("The catalog has not been saved. Lose it anyway ?"))
	      != 0)
	    {
	      return;
	    }
	}
    }
  fs = gtk_file_selection_new (_("File selection"));
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fs),
				   my_config->working_path);
  gtk_signal_connect (GTK_OBJECT (fs), "destroy",
		      (GtkSignalFunc) gtk_widget_destroy, &(fs));
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fs)->ok_button),
		      "clicked", (GtkSignalFunc) open_cat_ok_sel, racine);
  gtk_signal_connect_object (GTK_OBJECT
			     (GTK_FILE_SELECTION (fs)->cancel_button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (fs));
  gtk_widget_show (fs);

}

/*
 * permet d'enregistrer le catalogue courant dans un fichier 
 */
void
save_cat_ok_sel (GtkWidget * w, FOLDER * racine)
{
  gchar *s, *p;
  s = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));
  my_config->save_only_used_categories =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (toggle_save_cat_mode));
  racine->catalog_filename_is_valid = FALSE;
  if (save_cat_to_file (s, racine) == 0)
    {
      gtk_window_set_title (GTK_WINDOW (main_window),
			    racine->catalog_filename->str);
      g_free (my_config->working_path);
      my_config->working_path = g_strdup (s);
      p = my_config->working_path;
      while (p[0])
	p++;
      while (p[0] != '/')
	p--;
      p[1] = 0;
    }
  gtk_widget_destroy (GTK_WIDGET (fs));
}



void
save_cat (FOLDER * racine)
{
  GtkWidget *frame;
  fs = gtk_file_selection_new (_("Save catalog to file"));
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fs),
				   my_config->working_path);
  frame = gtk_frame_new (_("Options"));
  gtk_box_pack_start (GTK_BOX (GTK_FILE_SELECTION (fs)->action_area), frame,
		      FALSE, TRUE, 0);
  gtk_widget_show (frame);

  toggle_save_cat_mode =
    gtk_check_button_new_with_label (_("Save only used categories"));
  gtk_container_add (GTK_CONTAINER (frame), toggle_save_cat_mode);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggle_save_cat_mode),
				my_config->save_only_used_categories);
  gtk_widget_show (toggle_save_cat_mode);

  gtk_signal_connect (GTK_OBJECT (fs), "destroy",
		      (GtkSignalFunc) gtk_widget_destroy, &(fs));
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fs)->ok_button),
		      "clicked", (GtkSignalFunc) save_cat_ok_sel, racine);
  gtk_signal_connect_object (GTK_OBJECT
			     (GTK_FILE_SELECTION (fs)->cancel_button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (fs));
  gtk_widget_show (fs);
}


void
fast_save (FOLDER * racine)
{
  if (racine->catalog_filename_is_valid == FALSE)
    {
      save_cat (racine);
    }
  else
    {
      if (save_cat_to_file (racine->catalog_filename->str, racine) == -1)
	{
	  /*
	   * canceled = 1; 
	   */
	  ERROR_DIALOG (_("Can't write file"), main_window);
	}
    }
}

/* string_to_index(descriptions, "my own description") will return the index where the
 * description containing the string "my own description" can be reached.
 * id = string_to_index(descriptions, "my own description");
 * each FILE_DATA where the field FILE_dATA->descriptions is id contains the description
 * "my own description".
 * This can be used with categories the same way.
 */
const gint
string_to_index (GPtrArray * a, gchar * s)
{
  gint i;
  gint result = 0;
  i = a->len;

  while (i > 0)
    {
      i--;
      if (strcmp (((GString *) (g_ptr_array_index (a, i)))->str, s) == 0)
	{
	  result = i + 1;
	  break;
	}
    }
  return (result);
}

gboolean
test_plugin_existence (GString * filename)
{
  gchar *path;
  gchar **paths, **p1;
  gchar *fullname = NULL;
  if (filename->str[0] == '/')
    return (g_file_test (filename->str, G_FILE_TEST_ISFILE));
  path = getenv ("PATH");
  paths = g_strsplit (path, ":", 0);
  p1 = paths;
  while (*p1)
    {
      fullname = g_strconcat (*p1, "/", filename->str, NULL);
      if (g_file_test (fullname, G_FILE_TEST_ISFILE))
	break;
      g_free (fullname);
      fullname = NULL;
      p1++;
    }
  g_strfreev (paths);
  if (fullname)
    {
      g_free (fullname);
      return (TRUE);
    }
  return (FALSE);
}
