/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <sys/types.h>
#include <sys/wait.h>

#include "config_common.h"
#include "exit.h"
#include "setup.h"

gint
yes_no_cancel_dialog (gchar * title, gchar * message)
{
  gint returned_value = -1;
  GtkWidget *dialog, *label;

  dialog = gnome_dialog_new (title,
			     GNOME_STOCK_BUTTON_YES,
			     GNOME_STOCK_BUTTON_NO,
			     GNOME_STOCK_BUTTON_CANCEL, NULL);

  label = gtk_label_new (message);
  gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), label, TRUE,
		      TRUE, 0);
  gtk_widget_show (label);
  returned_value = gnome_dialog_run_and_close (GNOME_DIALOG (dialog));

  return (returned_value);
}

gint
yes_no_dialog (gchar * title, gchar * message)
{
  gint returned_value = -1;
  GtkWidget *dialog, *label;

  dialog = gnome_dialog_new (title,
			     GNOME_STOCK_BUTTON_YES,
			     GNOME_STOCK_BUTTON_NO, NULL);

  label = gtk_label_new (message);
  gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), label, TRUE,
		      TRUE, 0);
  gtk_widget_show (label);
  returned_value = gnome_dialog_run_and_close (GNOME_DIALOG (dialog));

  return (returned_value);
}

void
quit_prog (FOLDER * racine)
{
  gboolean quit_anyway = TRUE;

  if (racine)
    {
      if (racine->is_modified == TRUE)
	{
	  if (yes_no_cancel_dialog (_("Exit dialog"),
				    _
				    ("The catalog has not been saved. Leave anyway?"))
	      != 0)
	    {

	      quit_anyway = FALSE;
	    }
	}
    }
  if (quit_anyway == TRUE)
    {
      gdk_window_get_size (main_window->window, &(my_config->mainwindow_w),
			   &(my_config->mainwindow_h));
      gdk_window_get_root_origin (main_window->window,
				  &(my_config->mainwindow_x),
				  &(my_config->mainwindow_y));

      save_myconfig ();
      gtk_main_quit ();
    }
}
