%option nounput
%{
#include <gnome.h>
#include "config_common.h"
#include "config_parse.h"
%}

separator	[\t ]+

%%
{separator}			;

	/* not used yet
{separator}\-{separator}	{return TO;}
	*/

^[#;].*$			;

^\ *[Aa]dd[Ii]con		{yylval.string = yytext; return ADDEXTICON;}
^\ *[Aa]dd[Mm]ime[Ii]con	{yylval.string = yytext; return ADDMIMEICON;}
^\ *[Dd]efault[Ff]ile[Ii]con	{yylval.string = yytext; return DEFAULTFILEICON;}
^\ *[Dd]efault[Dd]ir[Ii]con	{yylval.string = yytext; return DEFAULTDIRICON;}
^\ *[Dd]efault[Dd]isk[Ii]con	{yylval.string = yytext; return DEFAULTDISKICON;}
^\ *[Dd]efault[Uu]nreadable[Ii]con	{yylval.string = yytext; return DEFAULTUNREADABLEICON;}
^\ *[Dd]efault[Vv][Ff][Ss][Ii]con	{yylval.string = yytext; return DEFAULTVFSICON;}
^\ *[Dd]efault[Oo]pened[Dd]ir[Ii]con	{yylval.string = yytext; return DEFAULTOPENEDDIRICON;}
^\ *[Dd]efault[Oo]pened[Dd]isk[Ii]con	{yylval.string = yytext; return DEFAULTOPENEDDISKICON;}
^\ *[Dd]efault[Oo]pened[Vv][Ff][Ss][Ii]con	{yylval.string = yytext; return DEFAULTOPENEDVFSICON;}

^\ *[Dd]isplay[Dd]ir[Ss]ize	{yylval.string = yytext; return DISPLAYDIRSIZE;}

^\ *[Mm]ount[Pp]rogram		{yylval.string = yytext; return MOUNTPROGRAM;}
^\ *[Uu]mount[Pp]rogram		{yylval.string = yytext; return UMOUNTPROGRAM;}
^\ *[Ee]ject[Pp]rogram		{yylval.string = yytext; return EJECTPROGRAM;}
^\ *[Mm]ount[Pp]oint		{yylval.string = yytext; return MOUNTPOINT;}
^\ *[Uu]se[Aa]utomount          {yylval.string = yytext; return USEAUTOMOUNT;}
^\ *[Mm]ount[Rr]etry            {yylval.string = yytext; return MOUNTRETRY;}

^\ *[Aa]dd[Ee]xtension		{yylval.string = yytext; return EXTENSION;}
^\ *[Aa]dd[Mm]ime[Ii]nformation	{yylval.string = yytext; return MIMEEXTENSION;}
^\ *[Dd]efault[Mm]ime[Ii]nformation	{yylval.string = yytext; return DEFAULTMIMEEXTENSION;}
^\ *[Aa]dd[Vv][Ff][Ss][Ee]xtension	{yylval.string = yytext; return VFSEXTENSION;}
^\ *[Aa]dd[Vv][Ff][Ss][Mm]ime		{yylval.string = yytext; return MIMEVFSEXTENSION;}

^\ *[Aa]dd[Mm]ime[Tt]o[Ss]kip	{yylval.string = yytext; return ADDMIMETOSKIP;}

^\ *[Oo]ption[Ee]ject           {yylval.string = yytext; return OPTIONEJECT;}
^\ *[Oo]ption[Ww]arn[Mm]ount    {yylval.string = yytext; return OPTIONWARNMOUNT;}
^\ *[Oo]ption[Dd]us             {yylval.string = yytext; return OPTIONDUS;}
^\ *[Cc]ompression[Ll]evel      {yylval.string = yytext; return COMPRESSIONLEVEL;}

^\ *VFS[Mm]ode			{yylval.string = yytext; return TESTVFS;}
^\ *[Rr]ead[Ii]nformation       {yylval.string = yytext; return READINFORMATION;}
^\ *[Ss]can[Mm]ime[Tt]ypes	{yylval.string = yytext; return SCANMIMETYPES;}
^\ *[Uu]se[Dd]efault[Mm]ime[Pp]lugin       {yylval.string = yytext; return USEDEFAULTMIMEPLUGIN;}
^\ *[Dd]b[Cc]lick[Ff]ile[Ff]or[Ii]nfo  {yylval.string = yytext; return DBCLICKFORINFO;}
^\ *[Dd]ate[Ff]ormat            {yylval.string = yytext; return DATEFORMAT;}

^\ *[Rr]ecent[Ff]ile            {yylval.string = yytext; return RECENTFILE;}
^\ *[Rr]ecent[Ff]iles[Mm]ax      {yylval.string = yytext; return RECENTFILESMAX;}

^\ *[Pp]revious[Ss]earch[Mm]ode      {yylval.string = yytext; return PREVIOUSSEARCHMODE;}

^\ *[Ss]ave[Oo]nly[Uu]sed[Cc]ategories      {yylval.string = yytext; return SAVEONLYUSEDCATEGORIES;}

^\ *[Mm]ain[Ww]indow[Pp]osition      {yylval.string = yytext; return MAINWINDOWPOSITION;}

[Tt][rR][Uu][eE]                { yylval.gbool = TRUE; return GBOOLEAN; }
[Ff][Aa][Ll][Ss][eE]            { yylval.gbool = FALSE; return GBOOLEAN; }
[Yy][Ee][Ss]                    { yylval.gbool = TRUE; return GBOOLEAN; }
[Nn][Oo]                        { yylval.gbool = FALSE; return GBOOLEAN; }
[Nn]ormal			{ yylval.val = TEST_VFS_YES; return INTEGER; }
[Ee]xtended			{ yylval.val = TEST_VFS_EXTENDED; return INTEGER; }
[Ii]gnored                      { yylval.val = TEST_VFS_NO; return INTEGER; }
[Ll]ocale                       { yylval.val = 0; return STRINGLOCALE; }

-?[0-9]+			{ yylval.val = atoi(yytext); return INTEGER; }
	/* not used yet
[^ \t\n]+@[^ \t\n]+\.[^ \t\n]{2,3} { yylval.string = yytext; return EMAIL; }
	*/
\"[^"]*\"			{ yylval.string = yytext; return QSTRING;}
'[^']*'				{ yylval.string = yytext; return QSTRING;}
[^'" \t\n]+			{ yylval.string = yytext; return STRING;}

^{separator}*\n			;
{separator}*\n			{ return EOL; }
<<EOF>>				{ return 0 ; }
%%
