/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  A big part of the source code in this file come from:
 *  x11amp - graphically mp3 player..
 *  Copyright (C) 1998-1999  Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#if defined(USE_PTHREADS)
#    include <pthread.h>
#endif

#include "addisk.h"
#include "selectdir.h"
#include "progressbar.h"
#include "thread_utils.h"

static GtkWidget *fs;
static GtkWidget *toggleb;
static GtkWidget *entry;
static GtkWidget *readvfs;

#if defined(USE_PTHREADS)
static pthread_t thread1;
#endif

int
start_add_disk (char *foldername, char *diskname, FOLDER * racine)
{
  while (foldername[strlen (foldername) - 1] == '/')
    foldername[strlen (foldername) - 1] = '\0';

  set_local_disk_name (diskname);
  set_local_folder_name (foldername);

  do_not_forget_to_mount (FALSE);
  set_thread_status_to_running ();
  progress_timeout (NULL);
  do_not_forget_to_umount (FALSE);
  init_vfs_scan_status ();
#if defined(USE_PTHREADS)
  if (pthread_create (&thread1, NULL, start_thread_scan, racine) < 0)
    {
      reinit_thread_status ();
      ERROR_DIALOG (_("Thread failed.\nCheck your number of threads."),
		    main_window);
    }
  else
    {
      set_added_disk (TRUE);
      my_timeout (racine);
    }
#else
  set_added_disk (TRUE);
  my_timeout (racine);
  start_thread_scan (racine);
#endif
  return (0);
}

static void
ok_clicked (GtkWidget * widget, gpointer data)
{
  FOLDER *racine = data;
  GString *disk_path;
  gchar *disk_label;
  gboolean getInformation;
  gint testvfs;
  GtkWidget *testvfs_widget;
  gchar *p;

  disk_path =
    g_string_new (gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
  g_free (my_config->working_path);
  my_config->working_path = g_strdup (disk_path->str);
  p = my_config->working_path;
  while (p[0])
    p++;
  while (p[0] != '/')
    p--;
  p[1] = 0;
  disk_label = gtk_editable_get_chars (GTK_EDITABLE (entry), 0, -1);
  getInformation = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (toggleb));
  testvfs_widget =
    gtk_menu_get_active (GTK_MENU
			 (gtk_option_menu_get_menu
			  (GTK_OPTION_MENU (readvfs))));
  testvfs =
    GPOINTER_TO_INT (gtk_object_get_user_data (GTK_OBJECT (testvfs_widget)));

  if (strcmp (disk_label, "") == 0)
    {
      ERROR_DIALOG (_("You have to write the disk label"), main_window);
      return;
    }
  else
    {
      /*      if (folder_exist_in(&racine,gtk_entry_get_text(GTK_ENTRY(entry)), my_config->search_dirtree) == 1) return; */
    }
  if (strcmp (disk_path->str, "") == 0)
    {
      ERROR_DIALOG (_("You have to set the disk location"), main_window);
      return;
    }

  gtk_widget_destroy (GTK_WIDGET (fs));
  my_config->getInformation = getInformation;
  my_config->testvfs = testvfs;
  start_add_disk (disk_path->str, disk_label, racine);
  racine->is_modified = TRUE;
  g_string_free (disk_path, TRUE);
  g_free (disk_label);
}

void
show_select_dir_win (FOLDER * racine)
{
  GtkWidget *frame, *vbox;
  GtkWidget *readvfs_menu, *readvfs_menuitem;

  fs = gtk_file_selection_new (_("Select Disk location"));
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fs),
				   my_config->working_path);
  gtk_widget_realize (fs);

  frame = gtk_frame_new (_("Disk Label"));
  gtk_box_pack_start (GTK_BOX (GTK_FILE_SELECTION (fs)->action_area), frame,
		      FALSE, TRUE, 0);
  gtk_widget_show (frame);

  entry = gtk_entry_new ();
  gtk_entry_set_max_length (GTK_ENTRY (entry), 50);
  gtk_entry_set_text (GTK_ENTRY (entry), "");
  gtk_editable_select_region (GTK_EDITABLE (entry), 0, -1);

  gtk_container_add (GTK_CONTAINER (frame), entry);
  gtk_widget_show (entry);

  frame = gtk_frame_new (_("Options"));
  gtk_box_pack_start (GTK_BOX (GTK_FILE_SELECTION (fs)->action_area), frame,
		      FALSE, TRUE, 0);
  gtk_widget_show (frame);
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox);
  gtk_widget_show (vbox);

  toggleb =
    gtk_check_button_new_with_label (_("Retrieve information about files"));
  gtk_box_pack_start (GTK_BOX (vbox), toggleb, FALSE, TRUE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggleb),
				my_config->getInformation);
  gtk_widget_show (toggleb);


  readvfs = gtk_option_menu_new ();
  gtk_widget_show (readvfs);
  gtk_box_pack_start (GTK_BOX (vbox), readvfs, FALSE, TRUE, 0);
  readvfs_menu = gtk_menu_new ();
  gtk_widget_show (readvfs_menu);
  readvfs_menuitem = gtk_menu_item_new_with_label (_("Do not scan VFS"));
  gtk_object_set_user_data (GTK_OBJECT (readvfs_menuitem),
			    GINT_TO_POINTER (TEST_VFS_NO));
  gtk_widget_show (readvfs_menuitem);
  gtk_menu_append (GTK_MENU (readvfs_menu), readvfs_menuitem);
  readvfs_menuitem = gtk_menu_item_new_with_label (_("Scan VFS"));
  gtk_object_set_user_data (GTK_OBJECT (readvfs_menuitem),
			    GINT_TO_POINTER (TEST_VFS_YES));
  gtk_widget_show (readvfs_menuitem);
  gtk_menu_append (GTK_MENU (readvfs_menu), readvfs_menuitem);
  readvfs_menuitem = gtk_menu_item_new_with_label (_("Full scan VFS"));
  gtk_object_set_user_data (GTK_OBJECT (readvfs_menuitem),
			    GINT_TO_POINTER (TEST_VFS_EXTENDED));
  gtk_widget_show (readvfs_menuitem);
  gtk_menu_append (GTK_MENU (readvfs_menu), readvfs_menuitem);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (readvfs), readvfs_menu);
  switch (my_config->testvfs)
    {
    case TEST_VFS_NO:
      gtk_option_menu_set_history (GTK_OPTION_MENU (readvfs), 0);
      break;
    case TEST_VFS_YES:
      gtk_option_menu_set_history (GTK_OPTION_MENU (readvfs), 1);
      break;
    case TEST_VFS_EXTENDED:
      gtk_option_menu_set_history (GTK_OPTION_MENU (readvfs), 2);
      break;
    }

  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fs)->ok_button),
		      "clicked", GTK_SIGNAL_FUNC (ok_clicked), racine);
  gtk_signal_connect_object (GTK_OBJECT
			     (GTK_FILE_SELECTION (fs)->cancel_button),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (fs));
  gtk_widget_show (fs);
}
