/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __PROGRESS_H__
#define __PROGRESS_H__

#include <config.h>
#ifdef OS_LINUX
#  include <sys/vfs.h>		
#endif
#ifdef OS_FREEBSD
#    include <sys/param.h>
#    include <sys/mount.h>
#endif
#include <gnome.h>


/* Return the size of the filesystem
   FIXME: Will take the size of the current filesystem.
        That means it won't work if you only try to catalog a part of a drive
*/
glong getStats (char *foldername);

/* Reset the internal variables of the progressBar */
void progress_reset ();

/* Indicate if a progress bar has just finished */
gboolean progress_needReset ();

/* Update the progress_bar */
gint progress_timeout (gpointer pstru);

/* Launch a timer to update the progressBar 
   Will stop by itself at 100% */
void progress_createTimeout ();

/* Set the total */
void progress_setTotal (gulong total);

/* Set the current value */
void progress_setCurrent (gulong current);
/* Get The current value */
gulong progress_getCurrent ();

/* Set a message in the appbar */
void progress_setStatus(gchar *msg);

/* Set the gnome appbar to use */
void progress_setGnomeAppBar(GtkWidget* appbar);

#endif
