/*  GTKtalog.
 *  Copyright (C) 1999-2000  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <stdio.h>
#include <stdlib.h>

#include "selectdir.h"
#include "edit.h"
#include "categories.h"
#include "interface.h"
#include "config_common.h"
#include "folder.h"
#include "io.h"

static GtkWidget *edit_window;
static GtkWidget *fold_entry;
static GtkWidget *cat_box;
static GtkWidget *cat_combo;
static GtkWidget *cat_ed;
static GtkWidget *desc_combo;
static GtkWidget *recursive_category;
static GtkWidget *recursive_description;
static GtkWidget *widget_is_description_empty;
static GtkWidget *widget_is_category_empty;

struct _gnode_and_string
{
  GNode *gn;
  gchar *s;
};

gboolean is_file_with_the_same_name (GNode * gn, gpointer data)
{
  FILE_DATA *fd;
  struct _gnode_and_string *gns = data;

  if (G_NODE_IS_ROOT (gn))
    return (FALSE);
  fd = get_file_data_from_gnode (gn);
  if (strcmp (gns->s, fd->name->str) == 0)
    {
      gns->gn = gn;
      return (TRUE);
    }
  return (FALSE);

}

gboolean
_change_category (GNode * gn, gpointer data)
{
  g_assert (!G_NODE_IS_ROOT (gn));
  if (is_link (gn->parent) == FALSE)
    {
      change_category (gn, GPOINTER_TO_UINT (data));
    }
  return (FALSE);
}

gboolean
_change_description (GNode * gn, gpointer data)
{
  g_assert (!G_NODE_IS_ROOT (gn));
  if (is_link (gn->parent) == FALSE)
    {
      change_description (gn, GPOINTER_TO_UINT (data));
    }
  return (FALSE);
}

gint
description_add (GPtrArray * description_array, gchar * text)
{
  gint i;
  i = string_to_index (description_array, text);
  if (i)
    return (i);
  g_ptr_array_add (description_array, g_string_new (text));
  return (description_array->len);
}

static void
ok_clicked (GtkWidget * w, gpointer data)
{
  FOLDER *racine = data;
  gchar *entry_text, *entry_text2, *entry_text3;
  GNode *gn;
  FILE_DATA *fd;
  GtkCTreeNode *gtknode;
  PIX *pix;
  GNode *tmpgn;
  gboolean gc_descriptions_flag;

  gn = racine->selected_folder;
  fd = get_file_data_from_gnode (gn);

  entry_text = gtk_entry_get_text (GTK_ENTRY (fold_entry));
  entry_text2 = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (cat_combo)->entry));
  entry_text3 =
    gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (desc_combo)->entry));

  if (strlen (entry_text) == 0)
    {
      ERROR_DIALOG (_("Name field is empty.\nType a file name or cancel."),
		    edit_window);
      return;
    }
  /* Is there a filename with the same name as entry_text ? */
  if (strcmp (fd->name->str, entry_text))
    {
      static struct _gnode_and_string gns;
      gns.gn = NULL;
      gns.s = entry_text;

      g_node_traverse (gn->parent, G_POST_ORDER, G_TRAVERSE_ALL, 2,
		       is_file_with_the_same_name, &gns);
      tmpgn = gns.gn;
      if ((tmpgn) && (tmpgn != gn->parent))
	{
	  ERROR_DIALOG
	    ("A file/dir with the same name already exists in this directory",
	     edit_window);
	  return;
	}
    }

  /* Change the category */
  if (gtk_toggle_button_get_active
      (GTK_TOGGLE_BUTTON (widget_is_category_empty)) == TRUE)

    {
      fd->categorie = string_to_index (racine->categories, entry_text2);
    }
  else
    fd->categorie = 0;
  if ((is_file (racine->selected_folder) == FALSE)
      && (is_link (racine->selected_folder) == FALSE))
    {
      if (gtk_toggle_button_get_active
	  (GTK_TOGGLE_BUTTON (recursive_category)) == TRUE)
	{
	  g_node_traverse (gn, G_PRE_ORDER, G_TRAVERSE_ALL, -1,
			   _change_category,
			   GUINT_TO_POINTER (0 + fd->categorie));
	}
    }

  /* Change the descriptions ? */
  gc_descriptions_flag = FALSE;
  if (gtk_toggle_button_get_active
      (GTK_TOGGLE_BUTTON (widget_is_description_empty)) == TRUE)
    {
      fd->description = description_add (racine->descriptions, entry_text3);
    }
  else
    {
      fd->description = 0;
      gc_descriptions_flag = TRUE;
    }
  if ((is_file (racine->selected_folder) == FALSE)
      && (is_link (racine->selected_folder) == FALSE))
    {
      if (gtk_toggle_button_get_active
	  (GTK_TOGGLE_BUTTON (recursive_description)) == TRUE)
	{
	  g_node_traverse (gn, G_PRE_ORDER, G_TRAVERSE_ALL, -1,
			   _change_description,
			   GUINT_TO_POINTER (0 + fd->description));
	}
    }
  if (gc_descriptions_flag == TRUE)
    description_garbage_collection ();


  /* Change the name ? */
  if (strcmp (fd->name->str, entry_text))
    {
      g_string_free (fd->name, TRUE);
      fd->name = g_string_new (entry_text);
      if ((is_dir (gn) == TRUE) || (is_disk (gn) == TRUE)
	  || (is_vfs_any (gn) == TRUE))
	{
	  gtknode = fd->ctree_node;
	  if (g_node_depth (gn) == 2)
	    pix = my_config->default_disk_pix;
	  else
	    pix = my_config->default_dir_pix;
	  gtk_ctree_set_node_info (GTK_CTREE (racine->ctree),
				   gtknode, fd->name->str, 4,
				   pix->pixmap, *(pix->mask), pix->pixmap,
				   *(pix->mask),
				   GTK_CTREE_ROW (gtknode)->is_leaf,
				   GTK_CTREE_ROW (gtknode)->expanded);
	}


    }
  gtk_widget_destroy (edit_window);
  list_folder (racine->selected_folder->parent);
  racine->selected_folder = NULL;
  my_config->update_edit_window = FALSE;
  racine->is_modified = TRUE;
}

void
delete_folder (GtkWidget * w, FOLDER * racine)
{
  GNode *parent;
  parent = racine->selected_folder->parent;
  gtk_clist_freeze (GTK_CLIST (racine->ctree));
  suppress_dir (racine->selected_folder);
  description_garbage_collection ();
  gtk_clist_thaw (GTK_CLIST (racine->ctree));
  list_folder (parent);
}

static void
cancel_clicked (GtkWidget * w, gpointer data)
{
  gtk_widget_destroy (edit_window);
  my_config->update_edit_window = FALSE;
  return;
}

static void
destroy_window (GtkWidget * w, GdkEventKey * event, gpointer data)
{
  cancel_clicked (w, data);
}

void
update_category_combo (FOLDER * racine)
{
  FILE_DATA *fd;
  GList *cat_list;
  gint i;

  cat_list = NULL;
  for (i = 0; i < racine->categories->len; i++)
    cat_list = g_list_append (cat_list, ((GString *)
					 g_ptr_array_index
					 (racine->categories, i))->str);
  if (cat_list)
    gtk_combo_set_popdown_strings (GTK_COMBO (cat_combo), cat_list);
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (cat_combo)->entry), FALSE);
  fd = get_file_data_from_gnode (racine->selected_folder);
  if (fd->categorie)
    {
      gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (cat_combo)->entry),
			  get_categorie (racine, fd->categorie));
    }
  gtk_widget_show (cat_combo);

}

void
_edit_categories (GtkWidget * w, FOLDER * racine)
{
  edit_categories (racine);
}

void
desc_sw_clicked (GtkWidget * w, gpointer data)
{
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w)) == TRUE)
    {
      gtk_widget_set_sensitive (GTK_WIDGET (data), TRUE);
    }
  else
    {
      gtk_widget_set_sensitive (GTK_WIDGET (data), FALSE);
    }
}

void
edit_folder (GtkWidget * w, FOLDER * racine)
{
  GtkWidget *vbox, *hbox, *the_box;
  GtkWidget *hboxdc;
  GtkWidget *ok, *cancel;
  GtkWidget *frame;
  FILE_DATA *fd;


  GList *cat_list;

  GList *desc_list;
  int i;


  if (racine->selected_folder != NULL)
    {

      fd = get_file_data_from_gnode (racine->selected_folder);
      /* Window */
      edit_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

      gtk_window_set_transient_for (GTK_WINDOW (edit_window),
				    GTK_WINDOW (main_window));

      gtk_window_set_position (GTK_WINDOW (edit_window), GTK_WIN_POS_MOUSE);
      if ((is_file (racine->selected_folder) == TRUE)
	  || (is_link (racine->selected_folder) == TRUE))
	gtk_widget_set_usize (GTK_WIDGET (edit_window), 300, 170);
      else
	gtk_widget_set_usize (GTK_WIDGET (edit_window), 300, 210);
      if (is_disk (racine->selected_folder) == TRUE)
	gtk_window_set_title (GTK_WINDOW (edit_window), "Edit disk");
      else if (is_vfs_any (racine->selected_folder) == TRUE)
	gtk_window_set_title (GTK_WINDOW (edit_window), "Edit vfs");
      else if (is_link (racine->selected_folder) == TRUE)
	gtk_window_set_title (GTK_WINDOW (edit_window), "Edit link");
      else if (is_dir (racine->selected_folder) == TRUE)
	gtk_window_set_title (GTK_WINDOW (edit_window), "Edit folder");
      else if (is_file (racine->selected_folder) == TRUE)
	gtk_window_set_title (GTK_WINDOW (edit_window), "Edit file");
      gtk_window_set_policy (GTK_WINDOW (edit_window), FALSE, FALSE, TRUE);
      gtk_container_border_width (GTK_CONTAINER (edit_window), 10);
      gtk_signal_connect (GTK_OBJECT (edit_window),
			  "delete_event", destroy_window, NULL);

      vbox = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (edit_window), vbox);
      gtk_widget_show (vbox);

      /* First frame (edit label) */
      frame = gtk_frame_new (NULL);
      gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
      if (is_disk (racine->selected_folder) == TRUE)
	gtk_frame_set_label (GTK_FRAME (frame), _("Edit disk label"));
      else if (is_vfs_any (racine->selected_folder) == TRUE)
	gtk_frame_set_label (GTK_FRAME (frame), _("Vfs label"));
      else if (is_link (racine->selected_folder) == TRUE)
	gtk_frame_set_label (GTK_FRAME (frame), _("Link label"));
      else if (is_dir (racine->selected_folder) == TRUE)
	gtk_frame_set_label (GTK_FRAME (frame), _("Directory label"));
      else if (is_file (racine->selected_folder) == TRUE)
	gtk_frame_set_label (GTK_FRAME (frame), _("File label"));
      gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
      gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
      gtk_widget_show (frame);

      fold_entry = gtk_entry_new_with_max_length (80);
      gtk_signal_connect (GTK_OBJECT (fold_entry), "activate",
			  GTK_SIGNAL_FUNC (ok_clicked), racine);
      gtk_entry_set_text (GTK_ENTRY (fold_entry), fd->name->str);
      gtk_entry_select_region (GTK_ENTRY (fold_entry),
			       0, GTK_ENTRY (fold_entry)->text_length);
      gtk_container_add (GTK_CONTAINER (frame), fold_entry);

      gtk_widget_show (fold_entry);

      /* Second entry (category combo box) */
      frame = gtk_frame_new (NULL);
      gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
      if (is_disk (racine->selected_folder) == TRUE)
	gtk_frame_set_label (GTK_FRAME (frame), _("Change disk category"));
      else if (is_vfs (racine->selected_folder) == TRUE)
	gtk_frame_set_label (GTK_FRAME (frame), _("Change vfs category"));
      else if (is_link (racine->selected_folder) == TRUE)
	gtk_frame_set_label (GTK_FRAME (frame), _("Change link category"));
      else if (is_dir (racine->selected_folder) == TRUE)
	gtk_frame_set_label (GTK_FRAME (frame),
			     _("Change directory category"));
      else if (is_file (racine->selected_folder) == TRUE)
	gtk_frame_set_label (GTK_FRAME (frame), _("Change file category"));
      gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
      gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
      gtk_widget_show (frame);

      cat_box = gtk_hbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), cat_box);
      gtk_widget_show (cat_box);

      widget_is_category_empty = gtk_check_button_new ();
      if (fd->categorie)
	{
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					(widget_is_category_empty), TRUE);
	}
      else
	{
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					(widget_is_category_empty), FALSE);
	}
      gtk_box_pack_start (GTK_BOX (cat_box), widget_is_category_empty,
			  FALSE, TRUE, 0);
      gtk_widget_show (widget_is_category_empty);

      cat_combo = gtk_combo_new ();
      gtk_combo_set_value_in_list (GTK_COMBO (cat_combo), FALSE, TRUE);
      gtk_combo_set_use_arrows_always (GTK_COMBO (cat_combo), TRUE);
      gtk_combo_disable_activate (GTK_COMBO (cat_combo));
      gtk_box_pack_start (GTK_BOX (cat_box), cat_combo, TRUE, TRUE, 0);
      cat_list = NULL;
      for (i = 0; i < racine->categories->len; i++)
	cat_list = g_list_append (cat_list, ((GString *)
					     g_ptr_array_index
					     (racine->categories, i))->str);
      if (cat_list)
	{
	  gtk_combo_set_popdown_strings (GTK_COMBO (cat_combo), cat_list);
	  g_list_free (cat_list);
	}
      gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (cat_combo)->entry),
			      FALSE);
      if (fd->categorie)
	{
	  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (cat_combo)->entry),
			      get_categorie (racine, fd->categorie));
	  gtk_widget_set_sensitive (GTK_WIDGET (cat_combo), TRUE);
	}
      else
	{
	  gtk_widget_set_sensitive (GTK_WIDGET (cat_combo), FALSE);
	}
      gtk_widget_show (cat_combo);


      cat_ed = gtk_button_new_with_label ("...");
      gtk_box_pack_start (GTK_BOX (cat_box), cat_ed, FALSE, FALSE, 0);
      gtk_signal_connect (GTK_OBJECT (cat_ed), "clicked",
			  GTK_SIGNAL_FUNC (_edit_categories), racine);
      gtk_widget_show (cat_ed);
      gtk_signal_connect (GTK_OBJECT (widget_is_category_empty), "clicked",
			  GTK_SIGNAL_FUNC (desc_sw_clicked), cat_combo);


      /* Third entry (description combo box) */

      frame = gtk_frame_new (NULL);
      gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
      gtk_frame_set_label (GTK_FRAME (frame), _("Edit description"));
      gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
      gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
      gtk_widget_show (frame);

      hboxdc = gtk_hbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), hboxdc);
      gtk_widget_show (hboxdc);

      widget_is_description_empty = gtk_check_button_new ();
      if (fd->description)
	{
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					(widget_is_description_empty), TRUE);
	}
      else
	{
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					(widget_is_description_empty), FALSE);
	}
      gtk_box_pack_start (GTK_BOX (hboxdc), widget_is_description_empty,
			  FALSE, TRUE, 0);
      gtk_widget_show (widget_is_description_empty);


      desc_combo = gtk_combo_new ();
      gtk_combo_set_value_in_list (GTK_COMBO (desc_combo), FALSE, TRUE);
      gtk_combo_set_use_arrows_always (GTK_COMBO (desc_combo), TRUE);
      gtk_combo_disable_activate (GTK_COMBO (desc_combo));
      gtk_container_add (GTK_CONTAINER (hboxdc), desc_combo);
      desc_list = NULL;
      for (i = 0; i < racine->descriptions->len; i++)
	desc_list = g_list_append (desc_list, ((GString *)
					       g_ptr_array_index
					       (racine->descriptions,
						i))->str);
      if (desc_list)
	gtk_combo_set_popdown_strings (GTK_COMBO (desc_combo), desc_list);
      if (fd->description)
	{
	  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (desc_combo)->entry),
			      get_description (racine, fd->description));
	}
      gtk_widget_show (desc_combo);


      if (fd->description)
	{
	  gtk_widget_set_sensitive (GTK_WIDGET (desc_combo), TRUE);
	}
      else
	{
	  gtk_widget_set_sensitive (GTK_WIDGET (desc_combo), FALSE);
	}
      gtk_signal_connect (GTK_OBJECT (widget_is_description_empty), "clicked",
			  GTK_SIGNAL_FUNC (desc_sw_clicked), desc_combo);

      if ((is_file (racine->selected_folder) == FALSE)
	  && (is_link (racine->selected_folder) == FALSE))
	{
	  frame = gtk_frame_new (NULL);
	  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
	  gtk_frame_set_label (GTK_FRAME (frame),
			       _("Propagate in subdirs and files"));
	  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
	  gtk_frame_set_shadow_type (GTK_FRAME (frame),
				     GTK_SHADOW_ETCHED_OUT);
	  gtk_widget_show (frame);

	  the_box = gtk_hbox_new (FALSE, 0);
	  gtk_container_add (GTK_CONTAINER (frame), the_box);
	  gtk_widget_show (the_box);

	  recursive_category =
	    gtk_check_button_new_with_label (_("Category"));
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					(recursive_category), FALSE);
	  gtk_box_pack_start (GTK_BOX (the_box), recursive_category,
			      FALSE, TRUE, 0);
	  gtk_widget_show (recursive_category);

	  recursive_description =
	    gtk_check_button_new_with_label ("Description");
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					(recursive_description), FALSE);
	  gtk_box_pack_start (GTK_BOX (the_box), recursive_description,
			      FALSE, TRUE, 0);
	  gtk_widget_show (recursive_description);
	}

      /* Buttons */
      hbox = gtk_hbutton_box_new ();
      gtk_button_box_set_layout (GTK_BUTTON_BOX (hbox), GTK_BUTTONBOX_END);
      gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbox), 5);

      ok = gnome_stock_button (GNOME_STOCK_BUTTON_OK);
      GTK_WIDGET_SET_FLAGS (ok, GTK_CAN_DEFAULT);
      gtk_window_set_default (GTK_WINDOW (edit_window), ok);
      gtk_box_pack_start (GTK_BOX (hbox), ok, TRUE, TRUE, 0);
      gtk_signal_connect (GTK_OBJECT (ok), "clicked",
			  GTK_SIGNAL_FUNC (ok_clicked), racine);
      gtk_widget_show (ok);

      cancel = gnome_stock_button (GNOME_STOCK_BUTTON_CANCEL);
      GTK_WIDGET_SET_FLAGS (cancel, GTK_CAN_DEFAULT);
      gtk_box_pack_start (GTK_BOX (hbox), cancel, TRUE, TRUE, 0);
      gtk_signal_connect (GTK_OBJECT (cancel), "clicked", cancel_clicked,
			  NULL);
      gtk_widget_show (cancel);

      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
      gtk_widget_show (hbox);

      gtk_widget_show (edit_window);
      my_config->update_edit_window = TRUE;

    }
}

void
update_disk (GtkWidget * w, FOLDER * racine)
{
  GNode *parent;
  gchar *folder_name, *disk_name;

  parent = racine->selected_folder;
  disk_name = g_strdup (folder_get_name (parent));
  folder_name = g_strdup (folder_get_informations (parent));

  suppress_dir (racine->selected_folder);
  gtk_clist_clear (GTK_CLIST (clist));
  start_add_disk (folder_name, disk_name, racine);
  g_free (folder_name);
  g_free (disk_name);
}
