/*  NCatalog , the GTKtalog ncurses GUI.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "data.h"
#include "search.h"
#include "loadcat.h"

#include "test.priv.h"
#include "browser.h"
#include <ctype.h>
#include <term.h>


WINDOW  *mainwin;
int hauteur;
int largeur;
char *help="\
     **********************************************
     * NCatalog v0.0.3 , the GTKtalog ncurses GUI *\n\
     *    Copyright (c) 1999 Mathieu VILLEGAS     *\n\
     *           gtktalog@caramail.com            *\n\
     **********************************************\n\n\
The diffrent hot keys are:\n\n\
      - F12 : to display the help\n\
      - F1,F2,F3,F4,F5,F6: to select the first to the 6th column and display its selected data at the bottom of the screen.\n\
      - LEFT ARROW, RIGHT ARROW: to resize the column selected by F1,F2,F3,F4 or F5. The last column can't be resized. To resize it, you have to resize columns before.\n\
      - F7: to open the search dialog.\n\
      - TAB: to switch from an edit box to an other.\n\
      - F10: to close a window.\n\
      - ENTER: to go in a folder.\n\
      - SPACE BAR: To display file or folder informations\n\n\
Now a little word about this soft:\n\
     NCatalog will not stay a readnly GUI. I think making diffrent GUI's for diffrent computers is a good thing, so I will try make NCatalog a real disk catalog, but it will not be easy.\n";


int main(int argc GCC_UNUSED, char *argv[]GCC_UNUSED)
{

  first_search = 1;
  size_mask =  1073741823;
  if(argc == 1)
    {
      printf("\
********************************************\n\
* NCatalog v0.0.3, the GTKtalog ncurses GUI.*\n\
********************************************\n\
This is a READONLY GUI\nUsage is: ncatalog catalog_filename\n\n");
      exit(-1);
    }
  load_cat_from_file(argv[1]);
  mainwin = initscr();
  wrefresh(mainwin);
  hauteur = lines;
  largeur = columns;
  open_cat_browser();
  exit(0);
}
