/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <zlib.h>

#include "savecat.h"
#include "config_common.h"
#include "exit.h"
#include "folder.h"

static gzFile gzcatalog;

void
write_gstring (GString * g, int fh)
{
  gint i = 0;
  if (g == NULL)
    {
      write (fh, &i, sizeof (gint));
    }
  else
    {
      if (g->len == 0)
	{
	  write (fh, &i, sizeof (gint));
	}
      else
	{
	  i = GINT_TO_LE (g->len);
	  write (fh, &i, sizeof (gint));
	  write (fh, (g->str), sizeof (gchar) * g->len);
	}
    }
}

void
gzwrite_gstring (GString * g, gzFile fh)
{
  gint i = 0;
  if (g == NULL)
    {
      gzwrite (fh, &i, sizeof (gint));
    }
  else
    {
      if (g->len == 0)
	{
	  gzwrite (fh, &i, sizeof (gint));
	}
      else
	{
	  i = GINT_TO_LE (g->len);
	  gzwrite (fh, &i, sizeof (gint));
	  gzwrite (fh, (g->str), sizeof (gchar) * g->len);
	}
    }
}

void
write_filedata (FILE_DATA * d, gzFile fh)
{
  guint32 le32;
  guint16 le16;
  guint le;

  g_assert (d != NULL);
  gzwrite_gstring (d->name, fh);
  le32 = GUINT32_TO_LE (d->taille);
  gzwrite (fh, &le32, sizeof (guint32));
  le = GUINT_TO_LE (d->type);
  gzwrite (fh, &le, sizeof (guint));
  le32 = GUINT32_TO_LE (d->date);
  gzwrite (fh, &le32, sizeof (guint32));
  le16 = GUINT16_TO_LE (d->categorie);
  gzwrite (fh, &le16, sizeof (guint16));
  le16 = GUINT16_TO_LE (d->description);
  gzwrite (fh, &le16, sizeof (guint16));
  gzwrite_gstring (d->information, fh);
}

void write_gnode (GNode * gn, gpointer data);
void
write_subdir (GNode * gn)
{
  gchar id;

  id = CAT_TREE_DOWN;
  gzwrite (gzcatalog, &id, sizeof (gchar));
  g_node_children_foreach (gn, G_TRAVERSE_ALL, write_gnode, NULL);
  id = CAT_TREE_UP;
  gzwrite (gzcatalog, &id, sizeof (gchar));
}

void
write_gnode (GNode * gn, gpointer data)
{

  gchar id = CAT_TREE_0;
  FILE_DATA *fd = get_file_data_from_gnode (gn);

  gzwrite (gzcatalog, &id, sizeof (gchar));
  write_filedata (fd, gzcatalog);
  if (is_file (gn) == FALSE)
    write_subdir (gn);
}

int
save_cat_to_file (char *filename, FOLDER * racine)
{
  gint i, id;
  gint nb_datas = 0;
  gint le;
  int catalog;
//  gzFile gzcatalog;
  GString *header;
  gchar mode[] = "wb9";

  if ((g_file_test (filename, G_FILE_TEST_ISFILE)) == TRUE)
    {
      if (yes_no_dialog
	  (_("File exists"), _("File already exists.\nErase it ?")) != 0)
	return (-1);
      else
	unlink (filename);
    }
  if (
      (catalog =
       open (filename, O_CREAT | O_WRONLY | O_TRUNC),
       (S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH)) == -1)
    {
      return (-1);
    }
  /* Header */
  header = g_string_new ("gtktalog 3gz");
  write_gstring (header, catalog);
  g_string_free (header, TRUE);

/* reopen with zlib */
  g_assert((my_config->compression_level>=0) && (my_config->compression_level<=9));
  sprintf(mode, "wb%d", my_config->compression_level);
  gzcatalog = gzdopen (catalog, mode);

  /* descriptions */
  nb_datas = racine->descriptions->len;
  le = GINT_TO_LE (nb_datas);
  gzwrite (gzcatalog, &le, sizeof (gint));
  for (i = 0; i < nb_datas; i++)
    {
      gzwrite_gstring (g_ptr_array_index (racine->descriptions, i),
		       gzcatalog);

    }

  /* categories */
  nb_datas = racine->categories->len;
  le = GINT_TO_LE (nb_datas);
  gzwrite (gzcatalog, &le, sizeof (gint));
  for (i = 0; i < nb_datas; i++)
    {
      gzwrite_gstring (g_ptr_array_index (racine->categories, i), gzcatalog);

    }


  /* Tree structure */
  write_subdir (racine->tree);
  id = CAT_TREE_END;
  gzwrite (gzcatalog, &id, sizeof (gchar));

  gzclose (gzcatalog);
  chmod (filename, (S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH));

  racine->is_modified = FALSE;
  if (racine->catalog_filename)
    g_string_free (racine->catalog_filename, TRUE);
  racine->catalog_filename = g_string_new (filename);
  racine->catalog_filename_is_valid = TRUE;

  return (0);
}
