/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __PROGRESS_H__
#define __PROGRESS_H__

#include <config.h>
#include <gnome.h>
#include <sys/vfs.h>		// For statfs


/* Return the size of the filesystem
   FIXME: Will take the size of the current filesystem.
        That means it won't work if you only try to catalog a part of a drive
*/
glong getStats (char *foldername);

/* Indicate if a progress bar has just finished */
void progress_reset ();
gboolean progress_needReset ();

/* Update the progress_bar.
   The progress bar must be passed with a gpointer (see struct) */
gint progress_timeout (gpointer pstru);

void progress_createTimeout ();

void progress_setProgressBar (GtkWidget *);
GtkWidget *progress_getProgressBar ();

/* Set the total */
void progress_setTotal (gulong total);

/* Set the current value */
void progress_setCurrent (gulong current);
gulong progress_getCurrent ();

#endif
