/*  GTKtalog.
 *  Copyright (C) 1999-2000  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <strings.h>
#include <fnmatch.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <signal.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>

#include "buttonbar.h"
#include "interface.h"
#include "edit.h"
#include "folder.h"
#include "compare.h"
#include "progressbar.h"


static GtkWidget *scrolled_window;
static GtkWidget *ctree_window;
static GtkWidget *clist_window;
static GtkWidget *hpaned;

GtkWidget *clist;
GtkWidget *path_entry;

struct extension_and_string
{
  EXTENSIONS *e;
  gchar *s;
};

void
ctree_window_add (GtkWidget * ctree)
{
  gtk_container_add (GTK_CONTAINER (ctree_window), ctree);
}

void
traverse_add_dir_to_clist (GNode * gn, gpointer data)
{
  const gchar *temp[6] = { " ", " ", " ", " ", " ", " " };
  gchar *nothing = " ";
  FILE_DATA *fd = NULL;
  gint i;
  PIX *pix;

  if ((is_dir (gn) == TRUE) || (is_disk (gn) == TRUE))
    {
      fd = get_file_data_from_gnode (gn);

      temp[1] = g_strdup ("0");
      temp[2] = g_strdup (get_time (fd->date));
      temp[3] = folder_get_category_from_file_data (fd);
      if (!temp[3])
	temp[3] = nothing;
      temp[4] = folder_get_description_from_file_data (fd);
      if (!temp[4])
	temp[4] = nothing;
      temp[5] = folder_get_informations (gn);
      if (!temp[5])
	temp[5] = nothing;

      i = gtk_clist_append ((GtkCList *) clist, (gchar **) temp);
      if (is_dir (gn) == TRUE)
	pix = my_config->default_dir_pix;
      else
	pix = my_config->default_disk_pix;
      gtk_clist_set_pixtext ((GtkCList *) clist, i, 0,
			     fd->name->str, 3, pix->pixmap, *(pix->mask));
      gtk_clist_set_row_data ((GtkCList *) clist, i, gn);
    }
}

void
traverse_add_file_to_clist (GNode * gn, gpointer data)
{
  const gchar *temp[6] = { " ", " ", " ", " ", " ", " " };
  gchar *nothing = " ";
  FILE_DATA *fd;
  FILE_DATA *fdl;
  char *extension;
  PIX *pix;
  gint i;
  GString *filename;

  if ((is_file (gn) == TRUE) || (is_link (gn) == TRUE))
    {
      fd = get_file_data_from_gnode (gn);
      filename = fd->name;

      if (is_link (gn) == TRUE)
	{
	  fdl = get_file_data_from_gnode (g_node_first_child (gn));
	  filename = fdl->name;
	}

      temp[1] = get_size (fd->taille);
      temp[2] = get_time (fd->date);
      temp[3] = folder_get_category_from_file_data (fd);
      if (!temp[3])
	temp[3] = nothing;
      temp[4] = folder_get_description_from_file_data (fd);
      if (!temp[4])
	temp[4] = nothing;
      temp[5] = folder_get_informations (gn);
      if (!temp[5])
	temp[5] = nothing;

      i = gtk_clist_append ((GtkCList *) clist, (gchar **) temp);

      /* pixmap depending on the extension */

      extension = fd->name->str;
      while (extension[0])
	extension++;
      while ((extension > fd->name->str) && (extension[0] != '.'))
	extension--;

      pix = ((PIX *) g_tree_lookup (my_config->icons, extension));
      if (!pix)
	{
	  pix = my_config->default_file_pix;
	}
      gtk_clist_set_pixtext ((GtkCList *) clist, i, 0,
			     filename->str, 3, pix->pixmap, *(pix->mask));


      gtk_clist_set_row_data ((GtkCList *) clist, i, gn);

    }
}

/*****************************************************************************************/


gint
find_viewer (gpointer key, gpointer value, gpointer data)
{
  struct extension_and_string *_find_ext = data;
  EXTENSIONS *e = value;
  GString *extstr;

  if (e->state == FALSE)
    return (FALSE);

  extstr = g_string_new (e->extension->str);
  extstr = g_string_prepend_c (extstr, '*');
  if (fnmatch (extstr->str, _find_ext->s, 0))
    return (FALSE);
  _find_ext->e = e;
  return (TRUE);
}

EXTENSIONS *
find_extension (gchar * file)
{
  static struct extension_and_string _find_ext;
  _find_ext.e = NULL;
  _find_ext.s = file;
  g_tree_traverse (my_config->extensions, find_viewer,
		   G_PRE_ORDER, &_find_ext);
  return (_find_ext.e);
}

void
fin_fils (int sig)
{
  wait (NULL);
  signal (SIGCHLD, SIG_DFL);
  signal (SIGCHLD, fin_fils);
}

static void
selection_made (GtkWidget * clist, gint row, gint column,
		GdkEventButton * event, gpointer data)
{
  GNode *gn;
  FILE_DATA *fd;
  FOLDER *racine;

  racine =
    get_catalog_from_gnode (gtk_clist_get_row_data (GTK_CLIST (clist), row));
  racine->selected_folder = NULL;

  gtk_widget_grab_focus (GTK_WIDGET (clist));

  fd = get_file_data_from_gnode (racine->tree);
  gtk_ctree_unselect_recursive (GTK_CTREE (racine->ctree), fd->ctree_node);
  gn = gtk_clist_get_row_data ((GtkCList *) clist, row);
  catalog_set_selected_folder (gn);
}


static void
unselection_made (GtkWidget * clist, gint row, gint column,
		  GdkEventButton * event, gpointer data)
{
  FOLDER *racine;

  racine =
    get_catalog_from_gnode (gtk_clist_get_row_data (GTK_CLIST (clist), row));
  racine->selected_folder = NULL;
}

GnomeUIInfo tree_pressed_menu_dir[] = {
  GNOMEUIINFO_ITEM_NONE (N_("Edit directory"), NULL, edit_folder),
  GNOMEUIINFO_ITEM_NONE (N_("Delete directory"), NULL, delete_folder),
  GNOMEUIINFO_END
};

GnomeUIInfo tree_pressed_menu_link[] = {
  GNOMEUIINFO_ITEM_NONE (N_("Edit link"), NULL, edit_folder),
  GNOMEUIINFO_END
};

GnomeUIInfo tree_pressed_menu_disk[] = {
  GNOMEUIINFO_ITEM_NONE (N_("Edit disk"), NULL, edit_folder),
  GNOMEUIINFO_ITEM_NONE (N_("Update disk"), NULL, update_disk),
  GNOMEUIINFO_ITEM_NONE (N_("Delete disk"), NULL, delete_folder),
  GNOMEUIINFO_END
};


GnomeUIInfo clist_pressed_menu_file[] = {
  GNOMEUIINFO_ITEM_NONE (N_("Edit file"), NULL, edit_folder),
  /*  GNOMEUIINFO_ITEM_NONE (N_("Edit informations"), NULL,
   * edit_file_informations), */
  GNOMEUIINFO_ITEM_NONE (N_("Delete file"), NULL, delete_folder),
  GNOMEUIINFO_END
};



/* affiche dans la fenetre de droite, les repertoires et fichiers avec les icons */
void
list_folder (GNode * parent)
{
  const gchar *temp[6] = { " ", " ", " ", " ", " ", " " };
  gchar *nothing = " ";
  FILE_DATA *fd;
  PIX *pix;
  int i;
  /*  selected_clist_folder = NULL; */

  gtk_clist_freeze ((GtkCList *) clist);
  gtk_clist_clear ((GtkCList *) clist);

  if (g_node_depth (parent) > 1)
    {
      fd = get_file_data_from_gnode (parent->parent);

      temp[0] = g_strdup ("..");
      temp[1] = g_strdup ("0");
      temp[2] = g_strdup (get_time (fd->date));
      temp[3] = folder_get_category_from_file_data (fd);
      if (!temp[3])
	temp[3] = nothing;
      temp[4] = folder_get_description_from_file_data (fd);
      if (!temp[4])
	temp[4] = nothing;
      if (fd->information)
	{
	  temp[5] = fd->information->str;
	}
      else
	{
	  temp[5] = nothing;
	}

      i = gtk_clist_append ((GtkCList *) clist, (gchar **) temp);
      if (g_node_depth (parent) == 2)
	pix = my_config->default_disk_pix;
      else
	pix = my_config->default_dir_pix;

      gtk_clist_set_pixtext ((GtkCList *) clist, i, 0,
			     temp[0], 3, pix->pixmap, *(pix->mask));
      gtk_clist_set_row_data ((GtkCList *) clist, i, parent);

    }

  g_node_children_foreach (parent, G_TRAVERSE_ALL, traverse_add_dir_to_clist,
			   NULL);

  if (g_node_depth (parent) > 1)
    g_node_children_foreach (parent, G_TRAVERSE_ALL,
			     traverse_add_file_to_clist, NULL);


  gtk_clist_thaw ((GtkCList *) clist);
  catalog_set_currently_displayed_gnode (parent);


  /*  total_size = total_size / 1024;
   * sprintf (info, _("%d folders  %d files  total size %lu ko"),
   * folder->nb_folders, folder->nb_files, total_size);
   * 
   * gtk_statusbar_pop ((GtkStatusbar *) status_bar2, status_context2);
   * gtk_statusbar_push ((GtkStatusbar *) status_bar2, status_context2, info);
   */
}



void
clist_pressed (GtkWidget * wid, GdkEventButton * event, gpointer data)
{
  EXTENSIONS *e;
  FILE_DATA *fd, *tmpfd;
  gboolean less;
  gchar *name;
  GdkBitmap *mask;
  GdkPixmap *pixmap;
  gint8 tmp;
  gint row, column;
  gint x, y;
  GNode *gn;
  GNode *gntmp;
  GString *tmpstr;
  GtkWidget *list_menu;
  FOLDER *racine;

  if (event->button == 3)
    {
      x = event->x;
      y = event->y;
      if (gtk_clist_get_selection_info
	  (GTK_CLIST (clist), x, y, &row, &column))
	{
	  gn = gtk_clist_get_row_data (GTK_CLIST (clist), row);
	  catalog_set_selected_folder (gn);
	  racine = get_catalog_from_gnode (gn);

	  if (is_dir (gn) == TRUE)
	    {
	      list_menu = gnome_popup_menu_new (tree_pressed_menu_dir);

	    }
	  else if (is_link (gn) == TRUE)
	    {
	      list_menu = gnome_popup_menu_new (tree_pressed_menu_link);
	    }
	  else if (is_file (gn) == TRUE)
	    {
	      list_menu = gnome_popup_menu_new (clist_pressed_menu_file);
	    }
	  else
	    {
	      list_menu = gnome_popup_menu_new (tree_pressed_menu_disk);
	    }
	  gnome_popup_menu_do_popup (list_menu, NULL, NULL, event, racine);
	}
    }
  else if ((event->button == 1) && (event->type == GDK_2BUTTON_PRESS))
    {

      x = event->x;
      y = event->y;
      if (gtk_clist_get_selection_info
	  (GTK_CLIST (clist), x, y, &row, &column))
	{
	  gtk_clist_get_pixtext ((GtkCList *) clist, row, 0, &name, &tmp,
				 &pixmap, &mask);

	  gn = gtk_clist_get_row_data ((GtkCList *) clist, row);
	  fd = get_file_data_from_gnode (gn);

	  if (is_link (gn) == TRUE)
	    {

	    }
	  else if (is_file (gn) == FALSE)
	    {
	      if ((row <= 0) && (strcmp (name, "..") == 0))
		{
		  gn = gn->parent;
		  fd = get_file_data_from_gnode (gn);

		}
	      if (g_node_depth (gn) > 2)
		{
		  tmpstr = g_string_new (fd->name->str);
		  g_string_append_c (tmpstr, '/');
		  gntmp = gn->parent;
		  while (g_node_depth (gntmp) > 2)
		    {
		      g_string_prepend_c (tmpstr, '/');
		      tmpfd = get_file_data_from_gnode (gntmp);
		      g_string_prepend (tmpstr, tmpfd->name->str);
		      gntmp = gntmp->parent;
		    }

		  g_string_prepend (tmpstr, "] /");
		  tmpfd = get_file_data_from_gnode (gntmp);
		  g_string_prepend (tmpstr, tmpfd->name->str);
		  g_string_prepend_c (tmpstr, '[');
		}
	      else if (g_node_depth (gn) == 2)
		{
		  tmpstr = g_string_new (fd->name->str);
		}
	      else
		{
		  FOLDER *racine = get_catalog_from_gnode (gn);
		  tmpstr = g_string_new (racine->catalog_filename->str);
		}
	      gtk_entry_set_text (GTK_ENTRY (path_entry), tmpstr->str);
	      g_string_free (tmpstr, TRUE);
	      if (is_link (gn) == FALSE)
		{
		  list_folder (gn);
		}


	    }
	  else
	    {
	      /* Find the program that will browse the file */

	      gn = gtk_clist_get_row_data (GTK_CLIST (clist), row);
	      fd = get_file_data_from_gnode (gn);

	      tmpstr = get_real_path_from_node (gn);
	      if (g_file_exists (tmpstr->str) == FALSE)
		{
		  ERROR_DIALOG
		    ("The file does not exist.\nMaybe it was removed or it is on a CD.\nIn this case, load the CD, mount it and try again",
		     main_window);
		}
	      else
		{
		  static struct extension_and_string _find_ext;
		  _find_ext.e = NULL;
		  _find_ext.s = fd->name->str;
		  g_tree_traverse (my_config->extensions, find_viewer,
				   G_PRE_ORDER, &_find_ext);
		  less = TRUE;
		  if ((e = _find_ext.e))
		    {
		      /* Launch the viewer */
		      char *args[3];
		      char *s1, *s2;
		      gint nb_args;
		      if (compare ("^[ \t]*$", e->viewer->str, TRUE, FALSE))
			{
			  s1 = g_strdup (tmpstr->str);
			  s2 = s1;
			  while (s2[0])
			    s2++;
			  while (s2[0] != '/')
			    s2--;
			  s2[0] = 0;
			  args[0] = e->viewer->str;
			  nb_args = 1;
			  if (compare
			      ("^[ \t]*$", e->viewerarg->str, TRUE, FALSE))
			    {
			      args[1] = e->viewerarg->str;
			      nb_args++;
			    }
			  args[nb_args++] = tmpstr->str;

			  gnome_execute_async (s1, nb_args, args);
			  g_free (s1);
			  less = FALSE;
			}
		    }
		  if (less == TRUE)
		    {
		      if (g_file_test (tmpstr->str, G_FILE_TEST_ISFILE) ==
			  TRUE)
			{
			  GtkWidget *dialog, *gl;

			  dialog =
			    gnome_dialog_new (fd->name->str,
					      GNOME_STOCK_BUTTON_CLOSE, NULL);
			  gnome_dialog_set_parent (GNOME_DIALOG (dialog),
						   GTK_WINDOW (main_window));
			  gtk_window_set_policy (GTK_WINDOW (dialog), FALSE,
						 TRUE, FALSE);
			  gtk_widget_set_usize (dialog, 500, 350);
			  gl = gnome_less_new ();
			  gtk_box_pack_start (GTK_BOX
					      (GNOME_DIALOG (dialog)->vbox),
					      gl, TRUE, TRUE, 0);
			  gnome_less_show_file (GNOME_LESS (gl), tmpstr->str);
			  gtk_widget_show (gl);
			  gnome_dialog_run_and_close (GNOME_DIALOG (dialog));

			}
		      else
			{
			  ERROR_DIALOG
			    ("The file is not a regular file.\nCan not display it",
			     main_window);
			}
		    }

		}
	      g_string_free (tmpstr, TRUE);
	    }
	}
    }
}




GtkWidget *
create_list ()
{

  gchar *titles[6] = { N_("Filename"), N_("Size"), N_("Date"), N_("Category"),
    N_("Description"), N_("Information")
  };

  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);


  clist = gtk_clist_new_with_titles (6, titles);

  gtk_clist_set_shadow_type (GTK_CLIST (clist), GTK_SHADOW_OUT);
  gtk_clist_set_column_width (GTK_CLIST (clist), 0, 135);
  gtk_clist_set_column_width (GTK_CLIST (clist), 1, 60);
  gtk_clist_set_column_width (GTK_CLIST (clist), 2, 56);
  gtk_clist_set_column_width (GTK_CLIST (clist), 3, 60);
  gtk_clist_set_column_width (GTK_CLIST (clist), 4, 60);
  gtk_container_add (GTK_CONTAINER (scrolled_window), clist);
  gtk_clist_set_column_auto_resize (GTK_CLIST (clist), 4, TRUE);
  gtk_signal_connect (GTK_OBJECT (clist), "button_press_event",
		      GTK_SIGNAL_FUNC (clist_pressed), NULL);
  gtk_signal_connect (GTK_OBJECT (clist), "select_row",
		      GTK_SIGNAL_FUNC (selection_made), NULL);
  gtk_signal_connect (GTK_OBJECT (clist), "unselect_row",
		      GTK_SIGNAL_FUNC (unselection_made), NULL);
  gtk_widget_show (clist);

  return scrolled_window;
}

void
tree_pressed (GtkWidget * wid, GdkEventButton * event, gpointer data)
{
  GtkWidget *list_menu;
  FOLDER *racine = data;
  GString *tmp;
  gint row, column;
  gint x, y;
  GNode *gn, *gntmp;
  FILE_DATA *fd, *tmpfd;


  if (event->button == 3)
    {
      x = event->x;
      y = event->y;
      if (gtk_clist_get_selection_info (GTK_CLIST (wid), x, y, &row, &column))
	{
	  gn = gtk_clist_get_row_data (GTK_CLIST (wid), row);
	  catalog_set_selected_folder (gn);
	  racine = get_catalog_from_gnode (gn);

	  if (is_dir (gn) == TRUE)
	    {
	      list_menu = gnome_popup_menu_new (tree_pressed_menu_dir);

	    }
	  else if (is_link (gn) == 1)
	    {
	      list_menu = gnome_popup_menu_new (tree_pressed_menu_link);
	    }
	  else
	    {
	      list_menu = gnome_popup_menu_new (tree_pressed_menu_disk);
	    }
	  gnome_popup_menu_do_popup (list_menu, NULL, NULL, event, racine);
	}
    }
  else if ((event->button == 1) && (event->type == GDK_2BUTTON_PRESS))
    {
      x = event->x;
      y = event->y;
      if (gtk_clist_get_selection_info (GTK_CLIST (wid), x, y, &row, &column))
	{
	  gn = gtk_clist_get_row_data (GTK_CLIST (wid), row);
	  catalog_set_selected_folder (gn);
	  racine = get_catalog_from_gnode (gn);
	  if (G_NODE_IS_ROOT (gn) != TRUE)
	    {
	      racine->selected_folder = gn;

	      fd = get_file_data_from_gnode (gn);

	      if (g_node_depth (gn) > 2)
		{
		  tmp = g_string_new (fd->name->str);
		  g_string_append_c (tmp, '/');
		  gntmp = gn->parent;
		  while (g_node_depth (gntmp) > 2)
		    {
		      g_string_prepend_c (tmp, '/');
		      tmpfd = get_file_data_from_gnode (gntmp);
		      g_string_prepend (tmp, tmpfd->name->str);
		      gntmp = gntmp->parent;
		    }

		  g_string_prepend (tmp, "] /");
		  tmpfd = get_file_data_from_gnode (gntmp);
		  g_string_prepend (tmp, tmpfd->name->str);
		  g_string_prepend_c (tmp, '[');
		}
	      else if (g_node_depth (gn) == 2)
		{
		  tmp = g_string_new (fd->name->str);
		}
	      else
		{
		  tmp = g_string_new (racine->catalog_filename->str);
		}
	      gtk_entry_set_text (GTK_ENTRY (path_entry), tmp->str);
	      g_string_free (tmp, TRUE);
	      if (is_link (gn) == FALSE)
		{
		  list_folder (gn);
		}
	    }
	}
    }
}


void
update_tree (FOLDER * racine)
{

/*  gtk_paned_add1 (GTK_PANED (my_config->hpaned), my_config->ctree_window);*/

  racine->selected_folder = NULL;
  gtk_widget_show_all (racine->ctree);
}

void
clean_description (FOLDER * racine)
{
  FILE_DATA *fd;
  gint i;

  for (i = 1; i < racine->datas->len; i++)
    {
      fd = g_ptr_array_index (racine->datas, i);
      fd->description = 0;
    }
  for (i = 0; i < racine->descriptions->len; i++)
    {
      g_string_free (g_ptr_array_index (racine->descriptions, i), TRUE);
      g_ptr_array_index (racine->descriptions, i) = NULL;
    }
  g_ptr_array_free (racine->descriptions, FALSE);
  racine->descriptions = g_ptr_array_new ();
  list_folder (racine->currently_displayed_gnode);
}

/* GNOME Menu */
GnomeUIInfo file_menu[] = {
  GNOMEUIINFO_MENU_NEW_ITEM (N_("New catalog"), N_("New catalog"),
			     cb_new_file,
			     NULL),
  GNOMEUIINFO_MENU_OPEN_ITEM (cb_open_cat, NULL),
  GNOMEUIINFO_MENU_SAVE_ITEM (cb_fast_save, NULL),
  GNOMEUIINFO_MENU_SAVE_AS_ITEM (cb_save_cat, NULL),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_EXIT_ITEM (cb_quit_prog, NULL),
  GNOMEUIINFO_END
};

GnomeUIInfo edit_menu[] = {
  GNOMEUIINFO_ITEM_NONE (N_("Edit categories"), NULL, cb_edit_categories),
  GNOMEUIINFO_ITEM_NONE (N_("Clean descriptions"), NULL,
			 cb_clean_description),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_PREFERENCES_ITEM (cb_run_setup, NULL),
  GNOMEUIINFO_END
};

GnomeUIInfo action_menu[] = {
  GNOMEUIINFO_ITEM_NONE (N_("Find file"), NULL, cb_create_search_dialog),
  GNOMEUIINFO_ITEM_NONE (N_("Create Report"), NULL, cb_open_report_dialog),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_NONE (N_("Fast Add"), NULL, cb_fast_add_disk),
  GNOMEUIINFO_ITEM_NONE (N_("Add disk"), NULL, cb_show_select_dir_win),
  GNOMEUIINFO_END
};

GnomeUIInfo help_menu[] = {
  GNOMEUIINFO_MENU_ABOUT_ITEM (cb_about_gtktalog, NULL),
  GNOMEUIINFO_END
};

GnomeUIInfo menubar[] = {
  GNOMEUIINFO_MENU_FILE_TREE (file_menu),
  GNOMEUIINFO_MENU_EDIT_TREE (edit_menu),
  GNOMEUIINFO_SUBTREE (N_("Action"), action_menu),
  GNOMEUIINFO_MENU_HELP_TREE (help_menu),
  GNOMEUIINFO_END
};

void
build_gui ()
{
  GtkWidget *main_vbox;
  GtkWidget *appbar1;

/* Main vertical box */
  main_vbox = gtk_vbox_new (FALSE, 1);
  gtk_container_border_width (GTK_CONTAINER (main_vbox), 1);
  gnome_app_set_contents (GNOME_APP (main_window), main_vbox);
  gtk_widget_show (main_vbox);

/* Menus and button bar */
  gnome_app_create_menus_with_data (GNOME_APP (main_window), menubar, NULL);
  enable_gnome_button_bar (main_window, NULL);

/* Status and progress bar */
  appbar1 = gnome_appbar_new (TRUE, TRUE, GNOME_PREFERENCES_USER);
  gtk_widget_ref (appbar1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "appbar1", appbar1,
			    (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (appbar1);
  gnome_app_set_statusbar (GNOME_APP (main_window), appbar1);
  progress_setProgressBar (GTK_WIDGET
			   (gnome_appbar_get_progress
			    (GNOME_APPBAR (appbar1))));


/* Path entry */
  path_entry = gtk_entry_new_with_max_length (300);
  gtk_entry_set_editable (GTK_ENTRY (path_entry), FALSE);
  gtk_entry_set_text (GTK_ENTRY (path_entry), "");
  gtk_entry_append_text (GTK_ENTRY (path_entry), "");
  gtk_entry_select_region (GTK_ENTRY (path_entry),
			   0, GTK_ENTRY (path_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (main_vbox), path_entry, FALSE, TRUE, 0);
  gtk_widget_show (path_entry);


/* Horizontal pan for the tree and file display */
  hpaned = gtk_hpaned_new ();
  gtk_container_add (GTK_CONTAINER (main_vbox), hpaned);
  gtk_paned_set_handle_size (GTK_PANED (hpaned), 10);
  gtk_paned_set_gutter_size (GTK_PANED (hpaned), 10);
  gtk_widget_show (hpaned);

/* Clist window to display the files */
  clist_window = create_list ();
  gtk_paned_add2 (GTK_PANED (hpaned), clist_window);
  gtk_widget_show (clist_window);

/* CTtree window to display the directory tree */
  ctree_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ctree_window),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize (ctree_window, 150, 150);

  gtk_widget_show (ctree_window);

  gtk_paned_add1 (GTK_PANED (hpaned), ctree_window);
}
