/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/mtio.h>
#include <sys/types.h>
#include <linux/cdrom.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>

int
eject (char *device)
{
  int fd;
  int status;

  fd = open (device, O_RDONLY | O_NONBLOCK);
  status = ioctl (fd, CDROMEJECT);
  close (fd);
  return status;
}


int
main (int argc, char **argv)
{
  FILE *fp;
  char line[1024];
  char s1[1024];
  char s2[1024];
  char s3[1024];
  char s4[1024];
  char dev[1024];
  int rc;
  int i;
  int j;
  uid_t uid;

/* On n'a pas besoin de gnome, mais c'est aussi facile de l'utiliser pour
 * les locales : le reste utilise gnome.
 * YM 19-06-00
 */
  bindtextdomain (PACKAGE, GNOMELOCALEDIR);
  textdomain (PACKAGE);
  gnome_init (PACKAGE, VERSION, argc, argv);

  //faut pas  de faire un buffer overflow, alors dans le doute, je limite!
  if (strlen (argv[1]) > 1023)
    exit (-1);

  fp = fopen ("/etc/fstab", "r");
  if (fp == NULL)
    {
      fprintf (stderr, _("%s: unable to open /etc/fstab: %s\n"), argv[0],
	       strerror (errno));
      exit (1);
    }

  while (fgets (line, sizeof (line), fp) != 0)
    {
      rc = sscanf (line, "%1023s %1023s %1023s %1023s", s1, s2, s3, s4);
      if ((rc >= 2) && (strcmp (s2, argv[1]) == 0)
	  && (strcmp (s3, "supermount") != 0))
	{
	  fclose (fp);
	  uid = geteuid ();
	  if (uid == 0)
	    {
	      eject (s1);
	      exit (0);
	    }
	  else
	    execlp ("eject", "eject", s1, NULL);
	  exit (-1);
	}
      else if ((rc >= 4) && (strcmp (s2, argv[1]) == 0)
	       && (strcmp (s3, "supermount") == 0) && (strlen (s4) > 4))
	{
	  i = 0;
	  while ((strlen (s4) > i + 4) && (s4[i] != 'd') && (s4[i + 1] != 'e')
		 && (s4[i + 2] != 'v') && (s4[i + 3] != '='))
	    {
	      i++;
	    }
	  if ((i == strlen (s4) - 4) || (strlen (s4) > 1024))
	    exit (-1);
	  else
	    {
	      i = i + 4;
	      j = 0;
	      while ((s4[i] != ',') && (s4[i] != ' ') && (s4[i] != '\n')
		     && (s4[i] != '\t'))
		{
		  dev[j] = s4[i];
		  i++;
		  j++;
		}
	      dev[j] = '\0';
	      fclose (fp);
	      uid = geteuid ();
	      if (uid == 0)
		{
		  eject (dev);
		  exit (0);
		}
	      else
		execlp ("eject", "eject", dev, NULL);
	      exit (-1);
	    }
	}
    }
  fclose (fp);
  exit (-1);
}
