/*  GTKtalog.
 *  Copyright (C) 2000  Yves Mettier
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


%{
#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include "config_common.h"

GList *local_config;

%}

%union {
	gint		val;
	char		*string;
	gboolean        gbool;  
	GString		*gstring;
	GArray		*garray;
	GList		*glist;
	KEY_VALUE	*kv;
}

/* not used yet
%type <glist>		INTEGERS
*/
%type <glist>		STRINGS
%type <gstring>		GSTRING
%type <kv>		one_line
%type <glist>		lines
%type <glist>		config_file

%type <kv>		line_ADDICON
%token 			ADDICON

%type <kv>		line_DEFAULTDIRICON
%token 			DEFAULTDIRICON

%type <kv>		line_DEFAULTDISKICON
%token 			DEFAULTDISKICON

%type <kv>		line_DEFAULTFILEICON
%token 			DEFAULTFILEICON

%type <kv>		line_MOUNTPROGRAM
%token 			MOUNTPROGRAM

%type <kv>		line_UMOUNTPROGRAM
%token 			UMOUNTPROGRAM

%type <kv>		line_EJECTPROGRAM
%token 			EJECTPROGRAM

%type <kv>		line_MOUNTPOINT
%token 			MOUNTPOINT

%type <kv>		line_EXTENSION
%token 			EXTENSION

%type <kv>		line_OPTIONDUS
%token 			OPTIONDUS

%type <kv>		line_OPTIONWARNMOUNT
%token 			OPTIONWARNMOUNT

%type <kv>		line_OPTIONEJECT
%token 			OPTIONEJECT

%token <string>		STRING
%token <string>		QSTRING
%token <gbool>	        GBOOLEAN

/* not used yet
%token <string>	EMAIL
%token 			TO
*/
%token <val>	INTEGER
%token 			EOL

%%
config_file: 	lines	{ local_config = $1; }
		;

lines:		one_line lines		{{
						if($1) {
							$$ = g_list_prepend($2, $1);
						} else {
							$$ = $2;
						}
					}}
		| one_line		{{ 
						if($1) {
							$$ = g_list_append(NULL, $1);
						} else {
							$$ = NULL;
						}
					}}
		;

one_line:	line_ADDICON EOL					{ $$ = $1; }
		| line_DEFAULTFILEICON EOL				{ $$ = $1; }
		| line_DEFAULTDIRICON EOL				{ $$ = $1; }
		| line_DEFAULTDISKICON EOL				{ $$ = $1; }
		| line_MOUNTPROGRAM EOL					{ $$ = $1; }
		| line_UMOUNTPROGRAM EOL				{ $$ = $1; }
		| line_EJECTPROGRAM EOL					{ $$ = $1; }
		| line_MOUNTPOINT EOL					{ $$ = $1; }
		| line_OPTIONEJECT EOL					{ $$ = $1; }
		| line_OPTIONWARNMOUNT EOL				{ $$ = $1; }
		| line_OPTIONDUS EOL					{ $$ = $1; }
		| line_EXTENSION EOL					{ $$ = $1; }
		| EOL							{ $$ = NULL;}
		;

line_EXTENSION:	EXTENSION GSTRING GSTRING GSTRING GSTRING GSTRING INTEGER
		{{
											KEY_VALUE *r, *r2;
											EXTENSIONS *e;

											r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
											r->key = g_string_new("Extension");
											r2 = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
											r->value = r2;
											r2->key = $2;
											e = (EXTENSIONS*)g_malloc(sizeof(EXTENSIONS));
											r2->value = e;
											e->extension = g_string_new(((GString*)$2)->str);
											e->prog = $3;
											e->arg = $4;
											e->viewer = $5;
											e->viewerarg = $6;
											e->state = $7;
											$$ = r;
										}}
		;

line_MOUNTPROGRAM:	MOUNTPROGRAM GSTRING		{{
											KEY_VALUE *r;

											r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
											r->key = g_string_new("MountProrgam");
											r->value = $2;
											$$ = r;
										}}
		;

line_UMOUNTPROGRAM:	UMOUNTPROGRAM GSTRING		{{
											KEY_VALUE *r;

											r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
											r->key = g_string_new("UmountProgram");
											r->value = $2;
											$$ = r;
										}}
		;

line_EJECTPROGRAM:	EJECTPROGRAM GSTRING		{{
											KEY_VALUE *r;

											r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
											r->key = g_string_new("EjectProgram");
											r->value = $2;
											$$ = r;
										}}
		;

line_MOUNTPOINT:	MOUNTPOINT GSTRING		{{
											KEY_VALUE *r;

											r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
											r->key = g_string_new("MountPoint");
											r->value = $2;
											$$ = r;
										}}
		;
line_OPTIONDUS:	        OPTIONDUS GBOOLEAN		{{
											KEY_VALUE *r;

											r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
											r->key = g_string_new("OptionDus");
											r->value = GINT_TO_POINTER($2);
											$$ = r;
										}}
		;
line_OPTIONWARNMOUNT:	OPTIONWARNMOUNT GBOOLEAN	{{
											KEY_VALUE *r;

											r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
											r->key = g_string_new("OptionWarnMount");
											r->value = GINT_TO_POINTER($2);
											$$ = r;
										}}
		;
line_OPTIONEJECT:	OPTIONEJECT GBOOLEAN		{{
											KEY_VALUE *r;

											r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
											r->key = g_string_new("OptionEject");
											r->value = GINT_TO_POINTER($2);
											$$ = r;
										}}
		;


/* line_ADDICON returns a KEY_VALUE containing a GString("AddIcon") and a glist with n elements.
 * The first element is the icon path, and the second element is the extension
 */
line_ADDICON:	ADDICON STRINGS		{{
											KEY_VALUE *r;

											r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
											r->key = g_string_new("AddIcon");
											r->value = $2;
											$$ = r;
										}}
		;

line_DEFAULTFILEICON:	DEFAULTFILEICON GSTRING		{{
											KEY_VALUE *r;

											r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
											r->key = g_string_new("DefaultFileIcon");
											r->value = $2;
											$$ = r;
										}}
		;

line_DEFAULTDIRICON:	DEFAULTDIRICON GSTRING		{{
											KEY_VALUE *r;

											r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
											r->key = g_string_new("DefaultDirIcon");
											r->value = $2;
											$$ = r;
										}}
		;

line_DEFAULTDISKICON:	DEFAULTDISKICON GSTRING		{{
											KEY_VALUE *r;

											r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
											r->key = g_string_new("DefaultDiskIcon");
											r->value = $2;
											$$ = r;
										}}
		;

STRINGS:	GSTRING				{ $$ = g_list_append(NULL, $1); }
		| GSTRING STRINGS		{ $$ = g_list_prepend($2, $1 ); }
		;

GSTRING:	STRING				{ $$ = g_string_new($1); }
		| QSTRING			{ 
							gchar *s;
							GString *g;
							s = $1;
							s++;
							g = g_string_new(s);
							$$ = g_string_truncate(g, g->len-1);
						}
		;

/* Not used yet. This is for integers.
INTEGERS: 	INTEGER				{ $$ = g_list_append(NULL, GINT_TO_POINTER($1)); }
			| INTEGER INTEGERS	{ $$ = g_list_prepend($2, GINT_TO_POINTER($1)); }
			| INTEGER TO INTEGER	{{
									gint i, b, e;
									GList *gl;
									
									if($3<$1) { b = $3; e = $1; }
									else { b = $1; e = $3; }
									gl = g_list_append(NULL, GINT_TO_POINTER(b));
									for(i=b+1; i<=e; i++) {
										gl = g_list_append(gl, GINT_TO_POINTER(i));
									}
									$$ = gl;
								}}
			| INTEGER TO INTEGER INTEGERS	{{
									gint i, b, e;
									GList *gl;
									
									if($3<$1) { b = $3; e = $1; }
									else { b = $1; e = $3; }
									gl = g_list_append($4, GINT_TO_POINTER(b));
									for(i=b+1; i<=e; i++) {
										gl = g_list_append(gl, GINT_TO_POINTER(i));
									}
									$$ = gl;
								}}
			;

*/
%%

int yyerror(char *s) {
	printf(_("Error parsing the config file: %s\n"),s);
	exit(0);
}

gboolean
check_supermount (CONFIG * my_config)
{
  FILE *fp;
  char line[1024];
  char s1[1024];
  char s2[1024];
  char s3[1024];
  int rc;

  fp = fopen ("/proc/mounts", "r");
  if (fp == NULL)
    {
      ERROR_DIALOG ("Unable to open /proc/mounts\n", main_window);
    }

  while (fgets (line, sizeof (line), fp) != 0)
    {
      rc = sscanf (line, "%1023s %1023s %1023s", s1, s2, s3);
      if ((rc >= 3) && (strcmp (s2, my_config->mount_point->str) == 0)
	  && (strcmp (s3, "supermount") == 0))
	{
	  fclose (fp);
	  return TRUE;
	}
    }
  fclose (fp);
  return FALSE;
}


void config_struct_free_1(GList *gl) {
	g_string_free(((KEY_VALUE*)(gl->data))->key, TRUE);
	local_config = g_list_remove_link(local_config, gl);
	g_list_free_1(gl);
}

#define GET_TOKEN ((KEY_VALUE*)(glist_ptr1->data))->value;
#define NEXT_TOKEN config_struct_free_1(glist_ptr1); glist_ptr1 = local_config;
#define IS_TOKEN(my_token) (strcmp((((KEY_VALUE*)(glist_ptr1->data))->key)->str,my_token) == 0)

CONFIG *init_config(GString *config_file, GtkWidget *w) {
/* Returns the config file "config_file->str" formated into the structure CONFIG */
	GList *glist_ptr1;
	CONFIG *my_config;
	FILE *rcfile;
	GList *gl1, *gl2;
	GString *gs;
	PIX *pix;
	GtkStyle *style;
	gchar *tmpstr;
	gchar error_load_pixmap[] = N_("Could not load pixmap %s.\nCheck your config file.");
	
	local_config = NULL;
	
	style = gtk_widget_get_style (GTK_WIDGET(w));
	
	rcfile = fopen(config_file->str,"r");
	if(rcfile) {
		/* Parse the config file */
		yyrestart(rcfile);
		yyparse();
		fclose(rcfile);
		
		/* Init some fields of my_config */
		my_config = (CONFIG*)g_malloc(sizeof(CONFIG));
		my_config->icons = g_tree_new((GCompareFunc)g_strcasecmp);
		my_config->mount = g_string_new("/bin/mount");
		my_config->umount = g_string_new("/bin/umount");
		my_config->eject_prog = g_string_new("/usr/bin/eject");
		my_config->mount_point = g_string_new("/mnt/cdrom");
		my_config->extensions = g_tree_new((GCompareFunc)g_strcasecmp);
		my_config->use_du_s = TRUE;
		my_config->warn_mount = FALSE;
		my_config->eject_disk = TRUE;
		my_config->getInformation = TRUE;
		
		/* Fills some fields of my_config with the parsed data */
		
		glist_ptr1 = local_config;
		while(glist_ptr1) {
			if(IS_TOKEN("AddIcon")) {
			/* Icon */
				gl1 = GET_TOKEN;
				
				if(g_file_test(((GString*)(gl1->data))->str, G_FILE_TEST_ISFILE)) {
					pix = (PIX*)g_malloc(sizeof(PIX));
					pix->path = (GString*)gl1->data;
					pix->mask = (GdkBitmap**)g_malloc(sizeof(GdkBitmap**));
					pix->pixmap = gdk_pixmap_create_from_xpm( GTK_WIDGET(w)->window,pix->mask, &style->bg[GTK_STATE_NORMAL],((GString*)(gl1->data))->str);
					
					gl2 = g_list_next(gl1);
					while(gl2) {
						g_tree_insert(my_config->icons, g_strdup(((GString*)(gl2->data))->str), pix);
						g_string_free(gl2->data, TRUE);
						gl2 = g_list_next(gl2);
					}
				} else {
					tmpstr = (gchar*)g_malloc(sizeof(gchar)*(strlen(error_load_pixmap))+((GString*)(gl1->data))->len);
					sprintf(tmpstr, error_load_pixmap, ((GString*)(gl1->data))->str);
					gnome_dialog_run_and_close(GNOME_DIALOG(gnome_warning_dialog_parented(tmpstr, GTK_WINDOW (w))));
					g_free(tmpstr);
					gl2 = gl1;
					while(gl2) {
						g_string_free(gl2->data, TRUE);
						gl2 = g_list_next(gl2);
					}
				}
				g_list_free(gl1);
				
				
				NEXT_TOKEN
			} else if(IS_TOKEN("DefaultFileIcon")) {
				gs = GET_TOKEN;

				if(g_file_test(gs->str, G_FILE_TEST_ISFILE)) {
					my_config->default_file_pix = (PIX*)g_malloc(sizeof(PIX));
					my_config->default_file_pix->mask = (GdkBitmap**)g_malloc(sizeof(GdkBitmap**));
					my_config->default_file_pix->path = (GString*)gs;
					my_config->default_file_pix->pixmap = gdk_pixmap_create_from_xpm( GTK_WIDGET(w)->window,my_config->default_file_pix->mask,&style->bg[GTK_STATE_NORMAL],gs->str);
					
				} else {
					tmpstr = (gchar*)g_malloc(sizeof(gchar)*(strlen(error_load_pixmap))+gs->len);
					sprintf(tmpstr, error_load_pixmap, gs->str);
					gnome_dialog_run_and_close(GNOME_DIALOG(gnome_error_dialog_parented(tmpstr, GTK_WINDOW (w))));
					g_free(tmpstr);
					exit(-1);
				}				
				NEXT_TOKEN
			} else if(IS_TOKEN("DefaultDirIcon")) {
				gs = GET_TOKEN;
				
				if(g_file_test(gs->str, G_FILE_TEST_ISFILE)) {
					my_config->default_dir_pix = (PIX*)g_malloc(sizeof(PIX));
					my_config->default_dir_pix->path = (GString*)gs;
					my_config->default_dir_pix->mask = (GdkBitmap**)g_malloc(sizeof(GdkBitmap**));
					my_config->default_dir_pix->pixmap = gdk_pixmap_create_from_xpm( GTK_WIDGET(w)->window,my_config->default_dir_pix->mask,&style->bg[GTK_STATE_NORMAL],gs->str);
					
				} else {
					tmpstr = (gchar*)g_malloc(sizeof(gchar)*(strlen(error_load_pixmap))+gs->len);
					sprintf(tmpstr, error_load_pixmap, gs->str);
					gnome_dialog_run_and_close(GNOME_DIALOG(gnome_error_dialog_parented(tmpstr, GTK_WINDOW (w))));
					g_free(tmpstr);
					exit(-1);
				}
				NEXT_TOKEN
			} else if(IS_TOKEN("DefaultDiskIcon")) {
				gs = GET_TOKEN;
				
				if(g_file_test(gs->str, G_FILE_TEST_ISFILE)) {
					my_config->default_disk_pix = (PIX*)g_malloc(sizeof(PIX));
					my_config->default_disk_pix->path = (GString*)gs;
					my_config->default_disk_pix->mask = (GdkBitmap**)g_malloc(sizeof(GdkBitmap**));
					my_config->default_disk_pix->pixmap = gdk_pixmap_create_from_xpm( GTK_WIDGET(w)->window,my_config->default_disk_pix->mask,&style->bg[GTK_STATE_NORMAL],gs->str);
					
				} else {
					tmpstr = (gchar*)g_malloc(sizeof(gchar)*(strlen(error_load_pixmap))+gs->len);
					sprintf(tmpstr, error_load_pixmap, gs->str);
					gnome_dialog_run_and_close(GNOME_DIALOG(gnome_error_dialog_parented(tmpstr, GTK_WINDOW (w))));
					g_free(tmpstr);
					exit(-1);
				}
				NEXT_TOKEN
			} else if(IS_TOKEN("MountProgram")) {
				gs = GET_TOKEN;
				g_string_free(my_config->mount, TRUE);
				my_config->mount = gs;
				NEXT_TOKEN
			} else if(IS_TOKEN("UmountProgram")) {
				gs = GET_TOKEN;
				g_string_free(my_config->umount, TRUE);
				my_config->umount = gs;
				NEXT_TOKEN
			} else if(IS_TOKEN("EjectProgram")) {
				gs = GET_TOKEN;
				g_string_free(my_config->eject_prog, TRUE);
				my_config->eject_prog = gs;
				NEXT_TOKEN
			} else if(IS_TOKEN("MountPoint")) {
				gs = GET_TOKEN;
				g_string_free(my_config->mount_point, TRUE);
				my_config->mount_point = gs;
				NEXT_TOKEN
			} else if(IS_TOKEN("OptionDus")) {
				gs = GET_TOKEN;
			        my_config->use_du_s = GPOINTER_TO_INT(gs);
				NEXT_TOKEN
			} else if(IS_TOKEN("OptionWarnMount")) {
				gs = GET_TOKEN;
			        my_config->warn_mount = GPOINTER_TO_INT(gs);
				NEXT_TOKEN
			} else if(IS_TOKEN("OptionEject")) {
				gs = GET_TOKEN;
			        my_config->eject_disk = GPOINTER_TO_INT(gs);
				NEXT_TOKEN
			} else if(IS_TOKEN("Extension")) {
				gs = GET_TOKEN;
				g_tree_insert(my_config->extensions, ((EXTENSIONS*)((KEY_VALUE*)gs)->value)->extension->str, ((KEY_VALUE*)gs)->value);
				NEXT_TOKEN
			} else {
				glist_ptr1 = g_list_next(glist_ptr1);
			}
		}
		my_config->use_supermount = check_supermount(my_config);
	} else {
		my_config = NULL;
	}
	return(my_config);	
}
