%option nounput
%{
#include <gnome.h>
#include "config_common.h"
#include "config_parse.h"
%}

separator	[\t ]+

%%
{separator}			;

	/* not used yet
{separator}\-{separator}	{return TO;}
	*/

^[#;].*$			;

^\ *[Aa]dd[Ii]con		{yylval.string = yytext; return ADDICON;}
^\ *[Dd]efault[Ff]ile[Ii]con	{yylval.string = yytext; return DEFAULTFILEICON;}
^\ *[Dd]efault[Dd]ir[Ii]con	{yylval.string = yytext; return DEFAULTDIRICON;}
^\ *[Dd]efault[Dd]isk[Ii]con	{yylval.string = yytext; return DEFAULTDISKICON;}

^\ *[Mm]ount[Pp]rogram		{yylval.string = yytext; return MOUNTPROGRAM;}
^\ *[Uu]mount[Pp]rogram		{yylval.string = yytext; return UMOUNTPROGRAM;}
^\ *[Ee]ject[Pp]rogram		{yylval.string = yytext; return EJECTPROGRAM;}
^\ *[Mm]ount[Pp]oint		{yylval.string = yytext; return MOUNTPOINT;}

^\ *[Aa]dd[Ee]xtension		{yylval.string = yytext; return EXTENSION;}

^\ *[Oo]ption[Ee]ject           {yylval.string = yytext; return OPTIONEJECT;}
^\ *[Oo]ption[Ww]arn[Mm]ount    {yylval.string = yytext; return OPTIONWARNMOUNT;}
^\ *[Oo]ption[Dd]us             {yylval.string = yytext; return OPTIONDUS;}

[Tt][rR][Uu][eE]                { yylval.gbool = TRUE; return GBOOLEAN; }
[Ff][Aa][Ll][Ss][eE]            { yylval.gbool = FALSE; return GBOOLEAN; }
[Yy][Ee][Ss]                    { yylval.gbool = TRUE; return GBOOLEAN; }
[Nn][Oo]                        { yylval.gbool = FALSE; return GBOOLEAN; }


[0-9]+				{ yylval.val = atoi(yytext); return INTEGER; }
	/* not used yet
[^ \t\n]+@[^ \t\n]+\.[^ \t\n]{2,3} { yylval.string = yytext; return EMAIL; }
	*/
\"[^"]*\"			{ yylval.string = yytext; return QSTRING;}
'[^']*'				{ yylval.string = yytext; return QSTRING;}
[^'" \t\n]+			{ yylval.string = yytext; return STRING;}

^{separator}*\n			;
{separator}*\n			{ return EOL; }
<<EOF>>				{ return 0 ; }
%%
