/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __SETUP_H__
#define __SETUP_H__

#include <config.h>
#include <gnome.h>

#include "config_common.h"

typedef struct
{
  GtkWidget *include_list_box;
  GtkWidget *mount_entry;
  GtkWidget *umount_entry;
  GtkWidget *mount_point_entry;
  GtkWidget *eject_entry;
  GdkPixmap *on_pix;
  GdkPixmap *off_pix;
  GtkStyle *style;
  GdkBitmap *state_mask;
  GtkWidget *window;
  gint selected_row;
}
SETUP_WIDGETS;

typedef struct
{
  GtkWidget *include_type_entry;
  GtkWidget *include_prog_entry;
  GtkWidget *include_arg_entry;
  GtkWidget *include_viewer_entry;
  GtkWidget *include_viewer_arg_entry;
  GtkWidget *add_type_window;
}
ADDTYPE_WIDGETS;

gboolean extensions_traverse(gpointer key, gpointer value, gpointer data);
gint pix_tree_printf(gpointer key, gpointer value, gpointer data);
gint extensions_tree_printf(gpointer key, gpointer value, gpointer data);
void setup_ok_clicked(GtkWidget *w, gpointer data);
void add_type_ok_clicked(GtkWidget *w, gpointer data);
void add_type(GtkWidget *w, gpointer data);
void include_selection_made(GtkWidget *clist, gint row, gint column, GdkEventButton *event, gpointer data);
void include_unselection_made(GtkWidget *clist, gint row, gint column, GdkEventButton *event, gpointer data);
void include_edit_button_clicked(GtkWidget *w, gpointer data);
void include_delete_button_clicked(GtkWidget *w, gpointer data);
void run_setup(GtkWidget *w, gpointer data);

#endif
