/*  GTKtalog.
 *  Copyright (C) 1999-2000  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>

#include "setup.h"
#include "interface.h"

#include "config_common.h"

#include "on.xpm"
#include "off.xpm"

gboolean
extensions_traverse (gpointer key, gpointer value, gpointer data)
{
  SETUP_WIDGETS *sw = data;
  EXTENSIONS *e = value;
  gint i;
  gchar *tmp[6] = { "", "", "", "", "", "" };

  tmp[1] = e->extension->str;
  tmp[2] = e->prog->str;
  tmp[3] = e->arg->str;
  tmp[4] = e->viewer->str;
  tmp[5] = e->viewerarg->str;
  i = gtk_clist_append ((GtkCList *) sw->include_list_box, (gchar **) tmp);
  gtk_clist_set_row_data ((GtkCList *) sw->include_list_box, i, e);
  if (e->state == FALSE)
    gtk_clist_set_pixmap ((GtkCList *) sw->include_list_box, i, 0,
			  sw->off_pix, sw->state_mask);
  else
    gtk_clist_set_pixmap ((GtkCList *) sw->include_list_box, i, 0,
			  sw->on_pix, sw->state_mask);
  return (FALSE);
}

gint
pix_tree_printf (gpointer key, gpointer value, gpointer data)
{
  GString *g;
  FILE *f = data;

  g = ((PIX *) value)->path;
  fprintf (f, "AddIcon %s %s\n", g->str, (gchar *) key);
  return (FALSE);
}

gint
extensions_tree_printf (gpointer key, gpointer value, gpointer data)
{
  FILE *f = data;
  EXTENSIONS *e = value;
  gint state = 1;
  if (e->state == FALSE)
    state = 0;

  fprintf (f, "AddExtension '%s' '%s' '%s' '%s' '%s' %d\n",
	   e->extension->str,
	   e->prog->str, e->arg->str, e->viewer->str, e->viewerarg->str,
	   state);
  return (FALSE);
}

void
setup_ok_clicked (GtkWidget * w, gpointer data)
{
  FILE *f;
  GString *conf_file;
  CONFIG *my_config = data;
  SETUP_WIDGETS *sw = g_hash_table_lookup (my_config->stuff, "_setup: SETUP WIDGETS");

  g_string_free (my_config->mount, TRUE);
  g_string_free (my_config->umount, TRUE);
  g_string_free (my_config->eject_prog, TRUE);
  g_string_free (my_config->mount_point, TRUE);

  my_config->mount =
    g_string_new (gtk_entry_get_text (GTK_ENTRY (sw->mount_entry)));
  my_config->umount =
    g_string_new (gtk_entry_get_text (GTK_ENTRY (sw->umount_entry)));
  my_config->eject_prog =
    g_string_new (gtk_entry_get_text (GTK_ENTRY (sw->eject_entry)));
  my_config->mount_point =
    g_string_new (gtk_entry_get_text (GTK_ENTRY (sw->mount_point_entry)));

  conf_file = g_string_new (g_get_home_dir ());
  if (conf_file->len < 1)
    {
      gnome_dialog_run_and_close (GNOME_DIALOG
				  (gnome_warning_dialog_parented
				   (_
				    ("Home directory not found. Setup will not be saved."),
				    GTK_WINDOW (my_config->window))));
    }
  else
    {
      conf_file = g_string_append (conf_file, USER_CONFIG_DIR);
      if (!g_file_test (conf_file->str, G_FILE_TEST_ISDIR))
	{
	  mkdir (conf_file->str, 493);
	}
      conf_file = g_string_append (conf_file, "/" USER_CONFIG_FILE);

      if (!(f = fopen (conf_file->str, "w+")))
	{
	  ERROR_DIALOG ("Can't save to config file", my_config->window);
	}
      else
	{
	  fprintf (f, _("# Sample config file for gtktalog\n\n"));
	  fprintf (f,
		   _
		   ("# AddIcon icon_path extension [extension [extension [...]]]\n\n"));
	  g_tree_traverse (my_config->icons, pix_tree_printf, G_PRE_ORDER, f);
	  fprintf (f,
		   _
		   ("\n# AddExtension extension plugin arguments viewer viewer_args state\n"));
	  g_tree_traverse (my_config->extensions, extensions_tree_printf,
			   G_PRE_ORDER, f);
	  fprintf (f, _("\n# DefaultFileIcon icon_path\n"));
	  fprintf (f, "DefaultFileIcon %s\n",
		   my_config->default_file_pix->path->str);
	  fprintf (f, _("# DefaultDiskIcon icon_path\n"));
	  fprintf (f, "DefaultDiskIcon %s\n",
		   my_config->default_disk_pix->path->str);
	  fprintf (f, _("# DefaultDirIcon icon_path\n"));
	  fprintf (f, "DefaultDirIcon %s\n",
		   my_config->default_dir_pix->path->str);
	  fprintf (f, _("\n# MountProgram path\n"));
	  fprintf (f, "MountProgram %s\n", my_config->mount->str);
	  fprintf (f, _("# UmountProgram path\n"));
	  fprintf (f, "UmountProgram %s\n", my_config->umount->str);
	  fprintf (f, _("# EjectProgram path\n"));
	  fprintf (f, "EjectProgram %s\n", my_config->eject_prog->str);
	  fprintf (f, _("# MountPoint path\n"));
	  fprintf (f, "MountPoint %s\n", my_config->mount_point->str);
	  fclose (f);
	}

    }


  gtk_widget_destroy (sw->window);
  g_free (sw);
  g_hash_table_remove (my_config->stuff, "_setup: SETUP WIDGETS");
}

void
add_type_ok_clicked (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  SETUP_WIDGETS *sw = g_hash_table_lookup (my_config->stuff, "_setup: SETUP WIDGETS");
  EXTENSIONS *e = g_hash_table_lookup (my_config->stuff, "_setup: EXTENSIONS");
  EXTENSIONS *e2;
  ADDTYPE_WIDGETS *aw =
    g_hash_table_lookup (my_config->stuff, "_setup: ADDTYPE WIDGETS");


  char *temp_type;
  char *temp_prog;
  char *temp_arg;
  char *temp_viewer;
  char *temp_viewerarg;

  temp_type =
    gtk_editable_get_chars (GTK_EDITABLE (aw->include_type_entry), 0, -1);
  e2 = g_tree_lookup (my_config->extensions, temp_type);

  if (e2 && (e2 != e))
    {
      gnome_dialog_run_and_close (GNOME_DIALOG
				  (gnome_warning_dialog_parented
				   (_
				    ("This extension already exists. Nothing will be done."),
				    GTK_WINDOW (aw->add_type_window))));
      g_free (temp_type);
    }
  else
    {
      if (sw->selected_row >= 0)
	{
	  g_string_free (e->extension, TRUE);
	  g_string_free (e->prog, TRUE);
	  g_string_free (e->arg, TRUE);
	  g_string_free (e->viewer, TRUE);
	  g_string_free (e->viewerarg, TRUE);
	  g_tree_remove (my_config->extensions, e);
	  gtk_clist_remove (GTK_CLIST (sw->include_list_box),
			    sw->selected_row);

	}
      else
	{

	  e = (EXTENSIONS *) g_malloc (sizeof (EXTENSIONS));
	}
      temp_type =
	gtk_editable_get_chars (GTK_EDITABLE (aw->include_type_entry), 0, -1);
      temp_prog =
	gtk_editable_get_chars (GTK_EDITABLE (aw->include_prog_entry), 0, -1);
      temp_arg =
	gtk_editable_get_chars (GTK_EDITABLE (aw->include_arg_entry), 0, -1);
      temp_viewer =
	gtk_editable_get_chars (GTK_EDITABLE (aw->include_viewer_entry), 0,
				-1);
      temp_viewerarg =
	gtk_editable_get_chars (GTK_EDITABLE (aw->include_viewer_arg_entry),
				0, -1);
      e->extension = g_string_new (temp_type);
      g_free (temp_type);
      e->prog = g_string_new (temp_prog);
      g_free (temp_prog);
      e->arg = g_string_new (temp_arg);
      g_free (temp_arg);
      e->viewer = g_string_new (temp_viewer);
      g_free (temp_viewer);
      e->viewerarg = g_string_new (temp_viewerarg);
      g_free (temp_viewerarg);
      g_tree_insert (my_config->extensions, e->extension->str, e);

      extensions_traverse (e->extension->str, e, sw);

    }
  gtk_widget_destroy (aw->add_type_window);
  g_free (aw);
  g_hash_table_remove (my_config->stuff, "_setup: ADDTYPE WIDGETS");
}


void
add_type (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  GtkWidget *vbox, *hbox, *vbox2;
  GtkWidget *ok, *cancel;
  GtkWidget *frame;
  GtkWidget *label;
  ADDTYPE_WIDGETS *aw;
  EXTENSIONS *e = g_hash_table_lookup (my_config->stuff, "_setup: EXTENSIONS");

  aw = (ADDTYPE_WIDGETS *) g_malloc (sizeof (ADDTYPE_WIDGETS));
  g_hash_table_insert (my_config->stuff, "_setup: ADDTYPE WIDGETS", aw);


  aw->add_type_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_position (GTK_WINDOW (aw->add_type_window),
			   GTK_WIN_POS_MOUSE);
  gtk_widget_set_usize (GTK_WIDGET (aw->add_type_window), 300, 295);
  gtk_window_set_title (GTK_WINDOW (aw->add_type_window), _("File type"));
  gtk_window_set_policy (GTK_WINDOW (aw->add_type_window), FALSE, FALSE,
			 TRUE);
  gtk_container_border_width (GTK_CONTAINER (aw->add_type_window), 10);
  gtk_signal_connect (GTK_OBJECT (aw->add_type_window), "delete_event",
		      GTK_SIGNAL_FUNC (gtk_widget_destroy),
		      GTK_OBJECT (aw->add_type_window));

  gtk_grab_add (aw->add_type_window);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (aw->add_type_window), vbox);
  gtk_widget_show (vbox);
  /***************/
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("File Type"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  aw->include_type_entry = gtk_entry_new_with_max_length (80);

  if (e)
    gtk_entry_set_text (GTK_ENTRY (aw->include_type_entry),
			e->extension->str);
  gtk_entry_select_region (GTK_ENTRY (aw->include_type_entry), 0,
			   GTK_ENTRY (aw->include_type_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (vbox2), aw->include_type_entry, FALSE, FALSE,
		      0);
  gtk_widget_show (aw->include_type_entry);

  label = gtk_label_new (_("For example '.rpm'"));
  gtk_box_pack_start (GTK_BOX (vbox2), label, TRUE, FALSE, 0);
  gtk_widget_show (label);

  /***********/
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame),
		       _("Plugin to get information about files"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  aw->include_prog_entry = gtk_entry_new_with_max_length (80);

  if (e)
    gtk_entry_set_text (GTK_ENTRY (aw->include_prog_entry), e->prog->str);
  gtk_entry_select_region (GTK_ENTRY (aw->include_prog_entry), 0,
			   GTK_ENTRY (aw->include_prog_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (vbox2), aw->include_prog_entry, FALSE, FALSE,
		      0);
  gtk_widget_show (aw->include_prog_entry);

  label = gtk_label_new (_("Leave blank to include all the file"));
  gtk_box_pack_start (GTK_BOX (vbox2), label, TRUE, FALSE, 0);
  gtk_widget_show (label);

  /***********/
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("Plugin Option"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  aw->include_arg_entry = gtk_entry_new_with_max_length (80);

  if (e)
    gtk_entry_set_text (GTK_ENTRY (aw->include_arg_entry), e->arg->str);
  gtk_entry_select_region (GTK_ENTRY (aw->include_arg_entry), 0,
			   GTK_ENTRY (aw->include_arg_entry)->text_length);
  gtk_container_add (GTK_CONTAINER (frame), aw->include_arg_entry);
  gtk_widget_show (aw->include_arg_entry);

  /***********/

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("Viewer"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  aw->include_viewer_entry = gtk_entry_new_with_max_length (80);

  if (e)
    gtk_entry_set_text (GTK_ENTRY (aw->include_viewer_entry), e->viewer->str);
  gtk_entry_select_region (GTK_ENTRY (aw->include_viewer_entry), 0,
			   GTK_ENTRY (aw->include_viewer_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (vbox2), aw->include_viewer_entry, FALSE, FALSE,
		      0);
  gtk_widget_show (aw->include_viewer_entry);

  label = gtk_label_new (_("Leave blank to use GTKtalog viewer"));
  gtk_box_pack_start (GTK_BOX (vbox2), label, TRUE, FALSE, 0);
  gtk_widget_show (label);


  /***********/

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("Viewer Option"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  aw->include_viewer_arg_entry = gtk_entry_new_with_max_length (80);

  if (e)
    gtk_entry_set_text (GTK_ENTRY (aw->include_viewer_arg_entry),
			e->viewerarg->str);
  gtk_entry_select_region (GTK_ENTRY (aw->include_viewer_arg_entry), 0,
			   GTK_ENTRY (aw->
				      include_viewer_arg_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (vbox2), aw->include_viewer_arg_entry, FALSE,
		      FALSE, 0);
  gtk_widget_show (aw->include_viewer_arg_entry);


/********************************/


  hbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbox), 5);

  ok = gtk_button_new_with_label (_("Ok"));
  GTK_WIDGET_SET_FLAGS (ok, GTK_CAN_DEFAULT);
  gtk_window_set_default (GTK_WINDOW (aw->add_type_window), ok);
  gtk_box_pack_start (GTK_BOX (hbox), ok, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ok), "clicked",
		      GTK_SIGNAL_FUNC (add_type_ok_clicked), my_config);
  gtk_widget_show (ok);

  cancel = gtk_button_new_with_label (_("Cancel"));
  GTK_WIDGET_SET_FLAGS (cancel, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox), cancel, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancel), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (aw->add_type_window));
  gtk_widget_show (cancel);

  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  gtk_widget_show (aw->add_type_window);

}



void
include_selection_made (GtkWidget * clist, gint row, gint column,
			GdkEventButton * event, gpointer data)
{
  CONFIG *my_config = data;
  SETUP_WIDGETS *sw = g_hash_table_lookup (my_config->stuff, "_setup: SETUP WIDGETS");
  EXTENSIONS *clrow_data;

  sw->selected_row = row;
  clrow_data = gtk_clist_get_row_data (GTK_CLIST (sw->include_list_box), row);
  g_hash_table_insert (my_config->stuff, "_setup: EXTENSIONS", clrow_data);

  if (event != NULL && event->button == 1 && event->type == GDK_2BUTTON_PRESS)
    {
      if (clrow_data->state == FALSE)
	{
	  clrow_data->state = TRUE;
	  gtk_clist_set_pixmap ((GtkCList *) sw->include_list_box, row, 0,
				sw->on_pix, sw->state_mask);
	}
      else
	{
	  clrow_data->state = FALSE;
	  gtk_clist_set_pixmap ((GtkCList *) sw->include_list_box, row, 0,
				sw->off_pix, sw->state_mask);
	}
    }
}

void
include_unselection_made (GtkWidget * clist, gint row, gint column,
			  GdkEventButton * event, gpointer data)
{
  CONFIG *my_config = data;
  SETUP_WIDGETS *sw = g_hash_table_lookup (my_config->stuff, "_setup: SETUP WIDGETS");
  g_hash_table_remove (my_config->stuff, "_setup: EXTENSIONS");
  sw->selected_row = -1;
}

void
include_edit_button_clicked (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  SETUP_WIDGETS *sw = g_hash_table_lookup (my_config->stuff, "_setup: SETUP WIDGETS");
  if (g_hash_table_lookup (my_config->stuff, "_setup: EXTENSIONS")
      && (sw->selected_row >= 0))
    add_type (w, my_config);
}


void
include_delete_button_clicked (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  SETUP_WIDGETS *sw = g_hash_table_lookup (my_config->stuff, "_setup: SETUP WIDGETS");

  if (sw->selected_row >= 0)
    {
      g_tree_remove (my_config->extensions,
		     g_hash_table_lookup (my_config->stuff, "_setup: EXTENSIONS"));
      g_free (g_hash_table_lookup (my_config->stuff, "_setup: EXTENSIONS"));
      g_hash_table_remove (my_config->stuff, "_setup: EXTENSIONS");
      gtk_clist_remove (GTK_CLIST (sw->include_list_box), sw->selected_row);
      sw->selected_row = -1;
    }
}
static void
cancel_clicked (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  SETUP_WIDGETS *sw = g_hash_table_lookup (my_config->stuff, "_setup: SETUP WIDGETS");
  gtk_widget_destroy (sw->window);
  g_free (sw);
  g_hash_table_remove (my_config->stuff, "_setup: SETUP WIDGETS");
  return;
}

static void destroy_window(GtkWidget * w, GdkEventKey *event, gpointer data)
{
  cancel_clicked(w, data);
}

void
run_setup (GtkWidget * w, gpointer data)
{
  GtkWidget *ok;
  GtkWidget *cancel;
  GtkWidget *notebook;
  GtkWidget *frame;
  GtkWidget *label;
  GtkWidget *hbox;
  GtkWidget *main_vbox;
  GtkWidget *bbox;
  GtkWidget *setup_vbox;
  GtkWidget *add_button;
  GtkWidget *delete_button;
  GtkWidget *edit_button;
  GtkWidget *vbox2;
  GtkWidget *scrolled_window;
  SETUP_WIDGETS *setup_widgets;
  gchar *titles[6] = { N_("State"),
    N_("File type"),
    N_("Plugin"),
    N_("Options"),
    N_("Viewer"),
    N_("Viewer Options")
  };

  CONFIG *my_config = data;

  setup_widgets = (SETUP_WIDGETS *) g_malloc (sizeof (SETUP_WIDGETS));
  g_hash_table_insert (my_config->stuff, "_setup: SETUP WIDGETS", setup_widgets);
  setup_widgets->selected_row = -1;


  setup_widgets->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy (GTK_WINDOW (setup_widgets->window), FALSE, FALSE,
			 TRUE);
  gtk_window_set_title (GTK_WINDOW (setup_widgets->window), _("Setup"));
  gtk_widget_set_usize (GTK_WIDGET (setup_widgets->window), 370, 335);
  gtk_signal_connect (GTK_OBJECT (setup_widgets->window),
		      "delete_event", destroy_window, my_config);


  gtk_widget_realize (setup_widgets->window);

  /* pixmap stuff */
  setup_widgets->style = gtk_widget_get_style (setup_widgets->window);
  setup_widgets->on_pix =
    gdk_pixmap_create_from_xpm_d (setup_widgets->window->window,
				  &(setup_widgets->state_mask),
				  &(setup_widgets->
				    style)->bg[GTK_STATE_NORMAL],
				  (gchar **) on_xpm);
  gtk_widget_unrealize (setup_widgets->window);

  gtk_widget_realize (setup_widgets->window);
  setup_widgets->style = gtk_widget_get_style (setup_widgets->window);
  setup_widgets->off_pix =
    gdk_pixmap_create_from_xpm_d (setup_widgets->window->window,
				  &(setup_widgets->state_mask),
				  &(setup_widgets->
				    style)->bg[GTK_STATE_NORMAL],
				  (gchar **) off_xpm);
  gtk_widget_unrealize (setup_widgets->window);

  gtk_container_set_border_width (GTK_CONTAINER (setup_widgets->window), 2);
  gtk_grab_add (setup_widgets->window);


  /* The notebook */
  setup_vbox = gtk_vbox_new (FALSE, 4);
  gtk_container_add (GTK_CONTAINER (setup_widgets->window), setup_vbox);
  gtk_widget_show (setup_vbox);

  notebook = gtk_notebook_new ();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
  gtk_box_pack_start (GTK_BOX (setup_vbox), notebook, TRUE, TRUE, 0);
  /*gtk_container_add (GTK_CONTAINER (setup_window), notebook); */
  /*gtk_table_attach_defaults(GTK_TABLE(table), notebook, 0,6,0,1); */
  gtk_widget_show (notebook);


  /* first frame */
  frame = gtk_frame_new (_("Cases are not sensitive for files type"));
  gtk_container_set_border_width (GTK_CONTAINER (frame), 3);

  gtk_widget_show (frame);

  label = gtk_label_new (_("Files to include"));
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);

  main_vbox = gtk_vbox_new (FALSE, 4);
  gtk_container_add (GTK_CONTAINER (frame), main_vbox);
  gtk_widget_show (main_vbox);


  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  gtk_box_pack_start (GTK_BOX (main_vbox), scrolled_window, TRUE, TRUE, 0);
  gtk_widget_show (scrolled_window);

  /* setup box to associate programs to file extensions */
  setup_widgets->include_list_box = gtk_clist_new_with_titles (6, titles);
  gtk_signal_connect (GTK_OBJECT (setup_widgets->include_list_box),
		      "select_row", GTK_SIGNAL_FUNC (include_selection_made),
		      my_config);
  gtk_signal_connect (GTK_OBJECT (setup_widgets->include_list_box),
		      "unselect_row",
		      GTK_SIGNAL_FUNC (include_unselection_made), my_config);

  gtk_clist_set_shadow_type (GTK_CLIST (setup_widgets->include_list_box),
			     GTK_SHADOW_OUT);
  gtk_clist_set_column_width (GTK_CLIST (setup_widgets->include_list_box), 0,
			      25);
  gtk_clist_set_column_width (GTK_CLIST (setup_widgets->include_list_box), 1,
			      60);
  gtk_clist_set_column_width (GTK_CLIST (setup_widgets->include_list_box), 2,
			      60);
  gtk_clist_set_column_width (GTK_CLIST (setup_widgets->include_list_box), 3,
			      60);
  gtk_clist_set_column_width (GTK_CLIST (setup_widgets->include_list_box), 4,
			      60);
  // gtk_signal_connect(GTK_OBJECT(clist), "button_press_event", GTK_SIGNAL_FUNC(clist_pressed), NULL);
  gtk_clist_set_column_justification (GTK_CLIST
				      (setup_widgets->include_list_box), 0,
				      GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_auto_resize (GTK_CLIST
				    (setup_widgets->include_list_box), 5,
				    TRUE);

  /* fill the clist */
  g_tree_traverse (my_config->extensions, extensions_traverse, G_PRE_ORDER,
		   setup_widgets);

  /* show the clist */
  gtk_container_add (GTK_CONTAINER (scrolled_window),
		     setup_widgets->include_list_box);
  gtk_widget_show (setup_widgets->include_list_box);

  hbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbox), 5);

  add_button = gtk_button_new_with_label (_("Add"));
  GTK_WIDGET_SET_FLAGS (add_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox), add_button, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (add_button), "clicked",
		      GTK_SIGNAL_FUNC (add_type), my_config);
  gtk_widget_show (add_button);

  edit_button = gtk_button_new_with_label (_("Edit"));
  GTK_WIDGET_SET_FLAGS (edit_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox), edit_button, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (edit_button), "clicked",
		      GTK_SIGNAL_FUNC (include_edit_button_clicked),
		      my_config);
  gtk_widget_show (edit_button);

  delete_button = gtk_button_new_with_label (_("Delete"));
  GTK_WIDGET_SET_FLAGS (delete_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox), delete_button, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (delete_button), "clicked",
		      GTK_SIGNAL_FUNC (include_delete_button_clicked),
		      my_config);
  gtk_widget_show (delete_button);

  gtk_box_pack_start (GTK_BOX (main_vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show (hbox);


/*******************************************************************************************/
  /* frame for fastaddisk */
  frame = gtk_frame_new (_("Complete informations"));
  gtk_container_set_border_width (GTK_CONTAINER (frame), 3);

  gtk_widget_show (frame);


  label = gtk_label_new (_("Disk setup"));
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);

  main_vbox = gtk_vbox_new (FALSE, 4);
  gtk_container_add (GTK_CONTAINER (frame), main_vbox);
  gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 3);
  gtk_widget_show (main_vbox);

	/**************/
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("Mount program"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  setup_widgets->mount_entry = gtk_entry_new_with_max_length (200);
  gtk_entry_set_text (GTK_ENTRY (setup_widgets->mount_entry),
		      my_config->mount->str);
  gtk_box_pack_start (GTK_BOX (vbox2), setup_widgets->mount_entry, FALSE,
		      FALSE, 0);
  gtk_widget_show (setup_widgets->mount_entry);

	/*************/

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("Umount program"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  setup_widgets->umount_entry = gtk_entry_new_with_max_length (200);
  gtk_entry_set_text (GTK_ENTRY (setup_widgets->umount_entry),
		      my_config->umount->str);
  gtk_box_pack_start (GTK_BOX (vbox2), setup_widgets->umount_entry, FALSE,
		      FALSE, 0);
  gtk_widget_show (setup_widgets->umount_entry);

	/**************/

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("Mount point"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  setup_widgets->mount_point_entry = gtk_entry_new_with_max_length (200);
  gtk_entry_set_text (GTK_ENTRY (setup_widgets->mount_point_entry),
		      my_config->mount_point->str);
  gtk_box_pack_start (GTK_BOX (vbox2), setup_widgets->mount_point_entry,
		      FALSE, FALSE, 0);
  gtk_widget_show (setup_widgets->mount_point_entry);

  label =
    gtk_label_new (_
		   ("This has to be the mount point registered in /etc/fstab"));
  gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

/***************/

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label (GTK_FRAME (frame), _("Eject Program"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  setup_widgets->eject_entry = gtk_entry_new_with_max_length (200);
  gtk_entry_set_text (GTK_ENTRY (setup_widgets->eject_entry),
		      my_config->eject_prog->str);
  gtk_box_pack_start (GTK_BOX (vbox2), setup_widgets->eject_entry, FALSE,
		      FALSE, 0);
  gtk_widget_show (setup_widgets->eject_entry);


/*******************************************************************************************/
  /* Bottom buttons */
  bbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (bbox), 5);
  gtk_box_pack_start (GTK_BOX (setup_vbox), bbox, FALSE, FALSE, 0);
  gtk_widget_show (bbox);

  ok = gtk_button_new_with_label (_("Save"));
  gtk_object_set_user_data (GTK_OBJECT (ok), setup_widgets->window);
  GTK_WIDGET_SET_FLAGS (ok, GTK_CAN_DEFAULT);
  gtk_window_set_default (GTK_WINDOW (setup_widgets->window), ok);
  gtk_box_pack_start (GTK_BOX (bbox), ok, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ok), "clicked",
		      GTK_SIGNAL_FUNC (setup_ok_clicked), my_config);
  gtk_widget_show (ok);

  cancel = gtk_button_new_with_label (_("Cancel"));
  GTK_WIDGET_SET_FLAGS (cancel, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (bbox), cancel, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (cancel), "clicked", cancel_clicked,
		      my_config);
  gtk_widget_show (cancel);

  gtk_widget_show (setup_widgets->window);
}
