/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  A big part of the source code in this file come from:
 *  x11amp - graphically mp3 player..
 *  Copyright (C) 1998-1999  Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>

#include "addisk.h"
#include "selectdir.h"

static void
ok_clicked (GtkWidget * widget, gpointer data)
{
  GString *disk_path;
  gchar *disk_label;
  CONFIG *my_config = data;
  gboolean getInformation;
  GtkWidget *fs;

  fs = g_hash_table_lookup (my_config->stuff, "_selectdir: file selection");
  disk_path =
    g_string_new (gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
  disk_label =
    gtk_editable_get_chars (GTK_EDITABLE
			    (g_hash_table_lookup
			     (my_config->stuff, "_selectdir: entry")), 0, -1);
  getInformation =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON
				  (g_hash_table_lookup
				   (my_config->stuff,
				    "_selectdir: toggle button")));

  if (strcmp (disk_label, "") == 0)
    {
      ERROR_DIALOG ("You have to write the disk label", my_config->window);
      return;
    }
  else
    {
      /*      if (folder_exist_in(&racine,gtk_entry_get_text(GTK_ENTRY(entry)), my_config->search_dirtree) == 1) return; */
    }
  if (strcmp (disk_path->str, "") == 0)
    {
      ERROR_DIALOG ("You have to set the disk location", my_config->window);
      return;
    }

  gtk_widget_destroy (GTK_WIDGET (fs));
  g_hash_table_remove (my_config->stuff, "_selectdir: file selection");
  g_hash_table_remove (my_config->stuff, "_selectdir: entry");
  g_hash_table_remove (my_config->stuff, "_selectdir: toggle button");
  my_config->getInformation = getInformation;
  start_add_disk (disk_path->str, disk_label, my_config);
  my_config->is_modified = TRUE;
  g_string_free (disk_path, TRUE);
  g_free (disk_label);
}

void
show_select_dir_win (GtkWidget * widget, CONFIG * my_config)
{
  GtkWidget *entry;
  GtkWidget *fs;
  GtkWidget *frame, *vbox;
  GtkWidget *toggleb;

  fs = gtk_file_selection_new ("Select Disk location");
  gtk_widget_realize (fs);

  frame = gtk_frame_new ("Disk Label");
  gtk_box_pack_start (GTK_BOX (GTK_FILE_SELECTION (fs)->action_area), frame,
		      FALSE, TRUE, 0);
  gtk_widget_show (frame);

  entry = gtk_entry_new ();
  gtk_entry_set_max_length (GTK_ENTRY (entry), 50);
  gtk_entry_set_text (GTK_ENTRY (entry), "");
  gtk_editable_select_region (GTK_EDITABLE (entry), 0, -1);

  gtk_container_add (GTK_CONTAINER (frame), entry);
  gtk_widget_show (entry);

  frame = gtk_frame_new ("Options");
  gtk_box_pack_start (GTK_BOX (GTK_FILE_SELECTION (fs)->action_area), frame,
		      FALSE, TRUE, 0);
  gtk_widget_show (frame);
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox);
  gtk_widget_show (vbox);

  toggleb =
    gtk_check_button_new_with_label (_("Retreive information about files"));
  gtk_box_pack_start (GTK_BOX (vbox), toggleb, FALSE, TRUE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggleb),
				my_config->getInformation);
  gtk_widget_show (toggleb);
  g_hash_table_insert (my_config->stuff, "_selectdir: toggle button", toggleb);


  g_hash_table_insert (my_config->stuff, "_selectdir: entry", entry);
  g_hash_table_insert (my_config->stuff, "_selectdir: file selection", fs);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fs)->ok_button),
		      "clicked", GTK_SIGNAL_FUNC (ok_clicked), my_config);
  gtk_signal_connect_object (GTK_OBJECT
			     (GTK_FILE_SELECTION (fs)->cancel_button),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (fs));
  gtk_widget_show (fs);
}
