/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <stdio.h>
#include <stdlib.h>

#include "folder.h"
#include "report.h"
#include "categories.h"
#include "config_common.h"

static gchar ALL_DISKS[] = N_("All disks");
static gchar ALL_CATEGORIES[] = N_("All");

void
_which_disk (GNode * gn, gpointer data)
{
  CONFIG *my_config = data;
  REPORT_WIDGETS *rw =
    g_hash_table_lookup (my_config->stuff, "_report: REPORT_WIDGETS");
  if (strcmp
      (gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (rw->disk_combo)->entry)),
       folder_get_name (my_config->racine, gn)))
    {

      g_hash_table_insert (my_config->stuff, "_report: _which disk", gn);
    }
}



void
_report_cats (GNode * gn, gpointer data)
{
  CONFIG *my_config = data;
  REPORT_WIDGETS *rw =
    g_hash_table_lookup (my_config->stuff, "_report: REPORT_WIDGETS");
  FILE *file = g_hash_table_lookup (my_config->stuff, "_report: report fh");
  gint cat =
    GPOINTER_TO_INT (g_hash_table_lookup
		     (my_config->stuff, "_report: report category"));
  FILE_DATA *fd = g_ptr_array_index (my_config->racine->datas,
				     GPOINTER_TO_UINT (gn->data));
  GString *gs;
  int i;

  if (((rw->gb_check_folders) && (is_dir (my_config->racine, gn) == TRUE))
      || ((rw->gb_check_files == TRUE)
	  && ((is_file (my_config->racine, gn) == TRUE)
	      || (is_link (my_config->racine, gn) == TRUE))))
    {

      if (((fd->categorie == cat) || (cat == -1))
	  && ((rw->gb_check_only_desc == FALSE)
	      || ((rw->gb_check_only_desc == TRUE)
		  && (fd->description != 0))))
	{
	  fprintf (file, "         %s", fd->name->str);
	  if ((rw->gb_check_description == TRUE) && (fd->description != 0))
	    fprintf (file, " : %s",
		     get_description (my_config, fd->description));
	  if ((rw->gb_check_folders) && (is_dir (my_config->racine, gn)))
	    {
	      if (rw->gb_check_location == TRUE)
		{
		  gs = get_path_from_node (gn, my_config->racine);
		  fprintf (file, " (%s)", gs->str);
		  g_string_free (gs, TRUE);
		}
	    }
	  fprintf (file, "\n");
	}
    }
  if ((rw->gb_check_folders) && (is_dir (my_config->racine, gn)))
    {
      fprintf (file, "      ");
      for (i = 0; i < fd->name->len; i++)
	fprintf (file, "~");
      fprintf (file, "\n");
      g_node_children_foreach (gn, G_TRAVERSE_ALL, _report_cats, my_config);
    }



}

void
_report_cats_disks (GNode * gn, gpointer data)
{
  CONFIG *my_config = data;
  REPORT_WIDGETS *rw =
    g_hash_table_lookup (my_config->stuff, "_report: REPORT_WIDGETS");
  FILE *file = g_hash_table_lookup (my_config->stuff, "_report: report fh");
  gint cat =
    GPOINTER_TO_INT (g_hash_table_lookup
		     (my_config->stuff, "_report: report category"));
  FILE_DATA *fd = g_ptr_array_index (my_config->racine->datas,
				     GPOINTER_TO_UINT (gn->data));
  gint i;

  if ((rw->gb_check_disks == TRUE) && (fd->categorie == cat)
      && ((rw->gb_check_only_desc == FALSE)
	  || ((rw->gb_check_only_desc == TRUE) && (fd->description != 0))))
    {
      fprintf (file, "\n   %s\n   ", fd->name->str);
      for (i = 0; i < fd->name->len; i++)
	fprintf (file, "-");
      fprintf (file, "\n");
    }
  g_node_children_foreach (gn, G_TRAVERSE_ALL, _report_cats, my_config);
}

gboolean generate_cat_report (CONFIG * my_config, FILE * file)
{
  REPORT_WIDGETS *rw =
    g_hash_table_lookup (my_config->stuff, "_report: REPORT_WIDGETS");
  gint i;
  gint j;
  gchar *the_cat;
  const gchar *tmpcat;
  GNode *disk_to_report = NULL;

  the_cat =
    g_strdup (gtk_entry_get_text
	      (GTK_ENTRY (GTK_COMBO (rw->cat_combobox)->entry)));
  rw->cat_to_report = -2;
  if (strlen (the_cat) == 0)
    rw->cat_to_report = 0;
  else if (strcmp (the_cat, ALL_CATEGORIES) == 0)
    rw->cat_to_report = -1;
  else
    {
      for (i = 1; i <= my_config->categories->len; i++)
	{
	  if (strcmp (the_cat, get_categorie (my_config, i)) == 0)
	    rw->cat_to_report = i;
	}
    }
  if (rw->cat_to_report == -2)
    {
      ERROR_DIALOG ("Wrong category", rw->report_dialog_window);
      return (FALSE);
    }

  if (strcmp (gtk_entry_get_text
	      (GTK_ENTRY (GTK_COMBO (rw->disk_combo)->entry)),
	      ALL_DISKS) == 0) disk_to_report = my_config->racine->tree;
  else
    {
      g_hash_table_insert (my_config->stuff, "_report: _which disk", NULL);
      g_node_children_foreach (my_config->racine->tree, G_TRAVERSE_ALL,
			       _which_disk, my_config);
      disk_to_report =
	g_hash_table_lookup (my_config->stuff, "_report: _which disk");
      g_hash_table_remove (my_config->stuff, "_report: _which disk");

    }
  if (disk_to_report == NULL)
    {
      ERROR_DIALOG ("Wrong disk name", rw->report_dialog_window);
      return (FALSE);
    }


  fprintf (file,
	   _
	   ("Categories present in archive\n=============================\n"));
  for (i = 0; i < my_config->categories->len; i++)
    fprintf (file, "    %s\n", get_categorie (my_config, i + 1));
  fprintf (file, "\n");
  if (rw->cat_to_report == -1)
    {
      for (i = 1; i < my_config->categories->len + 1; i++)
	{
	  tmpcat = get_categorie (my_config, i);
	  fprintf (file, _("Category: %s\n=========="), tmpcat);
	  for (j = 0; j < strlen (tmpcat); j++)
	    fprintf (file, "=");
	  fprintf (file, "\n");

	  g_hash_table_insert (my_config->stuff, "_report: report fh", file);
	  g_hash_table_insert (my_config->stuff, "_report: report category",
			       GINT_TO_POINTER (i));
	  g_node_children_foreach (disk_to_report, G_TRAVERSE_ALL,
				   _report_cats, my_config);
	  g_hash_table_remove (my_config->stuff, "_report: report category");
	  g_hash_table_remove (my_config->stuff, "_report: report fh");

	}
      if (rw->gb_check_only_cat == FALSE)
	{
	  fprintf (file, _("Category: None\n==============\n"));
	  g_hash_table_insert (my_config->stuff, "_report: report fh", file);
	  g_hash_table_insert (my_config->stuff, "_report: report category",
			       GINT_TO_POINTER (0));
	  g_node_children_foreach (disk_to_report, G_TRAVERSE_ALL,
				   _report_cats, my_config);
	  g_hash_table_remove (my_config->stuff, "_report: report category");
	  g_hash_table_remove (my_config->stuff, "_report: report fh");
	}
    }
  else
    {
      if (rw->cat_to_report != 0)
	{
	  tmpcat = get_categorie (my_config, rw->cat_to_report);
	  fprintf (file, _("Category: %s\n=========="), tmpcat);
	  for (j = 0; j < strlen (tmpcat); j++)
	    fprintf (file, "=");
	}
      else
	fprintf (file, _("Category: None\n=============="));
      fprintf (file, "\n");
      g_hash_table_insert (my_config->stuff, "_report: report fh", file);
      g_hash_table_insert (my_config->stuff, "_report: report category",
			   GINT_TO_POINTER (rw->cat_to_report));
      g_node_children_foreach (disk_to_report, G_TRAVERSE_ALL, _report_cats,
			       my_config);
      g_hash_table_remove (my_config->stuff, "_report: report category");
      g_hash_table_remove (my_config->stuff, "_report: report fh");

    }

  return TRUE;
}


void
_report_files (GNode * gn, gpointer data)
{
  CONFIG *my_config = data;
  REPORT_WIDGETS *rw =
    g_hash_table_lookup (my_config->stuff, "_report: REPORT_WIDGETS");
  FILE *file = g_hash_table_lookup (my_config->stuff, "_report: report fh");
  FILE_DATA *fd = g_ptr_array_index (my_config->racine->datas,
				     GPOINTER_TO_UINT (gn->data));
  int i;
  GString *gs;

  if (g_node_depth (gn) == 2)
    {
      if ((rw->gb_check_disks == TRUE)
	  && ((rw->cat_to_report == -1)
	      || (fd->categorie == rw->cat_to_report))
	  && ((rw->gb_check_only_desc == FALSE)
	      || ((rw->gb_check_only_desc == TRUE)
		  && (fd->description != 0))))
	{
	  fprintf (file, "\n%s\n", fd->name->str);
	  for (i = 0; i < fd->name->len; i++)
	    fprintf (file, "-");
	  fprintf (file, "\n");
	}
      g_node_children_foreach (gn, G_TRAVERSE_ALL, _report_files, my_config);
    }
  else
    {
      if (((rw->gb_check_folders) && (is_dir (my_config->racine, gn) == TRUE))
	  || ((rw->gb_check_files)
	      && ((is_file (my_config->racine, gn) == TRUE)
		  || (is_link (my_config->racine, gn) == TRUE))))
	{
	  if (
	      ((fd->categorie == rw->cat_to_report)
	       || (rw->cat_to_report == -1))
	      && ((rw->gb_check_only_desc == FALSE)
		  || ((rw->gb_check_only_desc == TRUE)
		      && (fd->description != 0)))
	      && ((((rw->gb_check_only_cat == TRUE) && (fd->categorie != 0))
		   || (rw->gb_check_only_cat == FALSE))))
	    {
	      for (i = 0; i < g_node_depth (gn) - 1; i++)
		fprintf (file, "  ");
	      fprintf (file, "%s", fd->name->str);
	      if ((rw->gb_check_category == TRUE) && (fd->categorie != 0))
		fprintf (file, " : %s ",
			 get_categorie (my_config, fd->categorie));
	      if ((rw->gb_check_description == TRUE)
		  && (fd->description != 0))
		fprintf (file, " : %s",
			 get_description (my_config, fd->description));
	      if ((rw->gb_check_folders) && (is_dir (my_config->racine, gn)))
		{
		  if (rw->gb_check_location == TRUE)
		    {
		      gs = get_path_from_node (gn, my_config->racine);
		      fprintf (file, " (%s)", gs->str);
		      g_string_free (gs, TRUE);
		    }
		}
	      fprintf (file, "\n");
	    }
	}
      if ((rw->gb_check_folders) && (is_dir (my_config->racine, gn)))
	{
	  for (i = 0; i < g_node_depth (gn) - 1; i++)
	    fprintf (file, "  ");
	  for (i = 0; i < fd->name->len; i++)
	    fprintf (file, "~");
	  fprintf (file, "\n");
	  g_node_children_foreach (gn, G_TRAVERSE_ALL, _report_files,
				   my_config);
	}
    }
}

gboolean generate_file_report (CONFIG * my_config, FILE * file)
{
  REPORT_WIDGETS *rw =
    g_hash_table_lookup (my_config->stuff, "_report: REPORT_WIDGETS");
  int i;
  char *the_cat;
  GNode *disk_to_report = NULL;

  the_cat =
    g_strdup (gtk_entry_get_text
	      (GTK_ENTRY (GTK_COMBO (rw->cat_combobox)->entry)));
  rw->cat_to_report = -2;
  if (strlen (the_cat) == 0)
    rw->cat_to_report = 0;
  else if (strcmp (the_cat, ALL_CATEGORIES) == 0)
    rw->cat_to_report = -1;
  else
    {
      for (i = 1; i <= my_config->categories->len; i++)
	{
	  if (strcmp (the_cat, get_categorie (my_config, i)) == 0)
	    rw->cat_to_report = i;
	}
    }
  if (rw->cat_to_report == -2)
    {
      ERROR_DIALOG ("Wrong category", rw->report_dialog_window);
      return (FALSE);
    }

  if (strcmp (gtk_entry_get_text
	      (GTK_ENTRY (GTK_COMBO (rw->disk_combo)->entry)),
	      ALL_DISKS) == 0) disk_to_report = my_config->racine->tree;
  else
    {
      g_hash_table_insert (my_config->stuff, "_report: _which disk", NULL);
      g_node_children_foreach (my_config->racine->tree, G_TRAVERSE_ALL,
			       _which_disk, my_config);
      disk_to_report =
	g_hash_table_lookup (my_config->stuff, "_report: _which disk");
      g_hash_table_remove (my_config->stuff, "_report: _which disk");

    }
  if (disk_to_report == NULL)
    {
      ERROR_DIALOG ("Wrong disk name", rw->report_dialog_window);
      return (FALSE);
    }

  g_hash_table_insert (my_config->stuff, "_report: report fh", file);
  g_node_children_foreach (disk_to_report, G_TRAVERSE_ALL, _report_files,
			   my_config);
  g_hash_table_remove (my_config->stuff, "_report: report fh");

  return (TRUE);
}

void
begin_report (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  REPORT_WIDGETS *rw =
    g_hash_table_lookup (my_config->stuff, "_report: REPORT_WIDGETS");

  char *path;
  FILE *file;
  gboolean result;

  path = gtk_entry_get_text (GTK_ENTRY (rw->output_entry));
  if ((file = fopen (path, "w+")) == NULL)
    {
      ERROR_DIALOG
	("Can't create file. Permission denied, disk full or wrong path.",
	 rw->report_dialog_window);
      return;
    }
  fprintf (file, _("This report was generated by GTKtalog.\n"));
  fprintf (file,
	   "http://gtktalog.sourceforge.net\n\n");

  fprintf (file, _("The report type is: "));
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (rw->button_sortbycat))
      == TRUE)
    {
      fprintf (file, _("Sort by category."));
    }
  else
    {
      fprintf (file, _("Sort by Disk->folder->file."));
    }
  fprintf (file, "\n===================\n");
  fprintf (file, _("  It contain:\n"));
  if (
      (rw->gb_check_disks =
       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (rw->check_disks))) ==
      TRUE) fprintf (file, _("           - disk name.\n"));
  if (
      (rw->gb_check_folders =
       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (rw->check_folders)))
      == TRUE) fprintf (file, _("           - folder name.\n"));
  if (
      (rw->gb_check_files =
       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (rw->check_files))) ==
      TRUE) fprintf (file, _("           - file name.\n"));
  if (
      (rw->gb_check_location =
       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (rw->check_location)))
      == TRUE) fprintf (file, _("           - directory location.\n"));
  if (
      (rw->gb_check_description =
       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON
				     (rw->check_description))) == TRUE)
    fprintf (file, _("           - description.\n"));
  if (
      (rw->gb_check_category =
       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (rw->check_category)))
      == TRUE) fprintf (file, _("           - category.\n"));
  fprintf (file, "\n");
  if (
      (rw->gb_check_only_cat =
       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (rw->check_only_cat)))
      == TRUE) fprintf (file, _("           - Just items with category.\n"));
  if (
      (rw->gb_check_only_desc =
       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (rw->check_only_desc)))
      == TRUE)
    fprintf (file, _("           - Just items with description.\n"));
  fprintf (file, "\n");



  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (rw->button_sortbycat))
      == TRUE)
    {
      result = generate_cat_report (my_config, file);
    }
  else
    {
      result = generate_file_report (my_config, file);
    }

  fclose (file);
  if (result == TRUE)
    WARNING_DIALOG ("Report successful.", rw->report_dialog_window);

  return;
}

void
set_report_file (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  REPORT_WIDGETS *rw =
    g_hash_table_lookup (my_config->stuff, "_report: REPORT_WIDGETS");
  gtk_entry_set_text (GTK_ENTRY (rw->output_entry),
		      gtk_file_selection_get_filename (GTK_FILE_SELECTION
						       (rw->report_selector)));
  gtk_widget_destroy (rw->report_selector);
}

void
select_report_file (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  REPORT_WIDGETS *rw =
    g_hash_table_lookup (my_config->stuff, "_report: REPORT_WIDGETS");

  rw->report_selector = gtk_file_selection_new (_("File report"));
  gtk_signal_connect (GTK_OBJECT (rw->report_selector), "destroy",
		      (GtkSignalFunc) gtk_widget_destroy,
		      &rw->report_selector);
  gtk_signal_connect (GTK_OBJECT
		      (GTK_FILE_SELECTION (rw->report_selector)->ok_button),
		      "clicked", (GtkSignalFunc) set_report_file, my_config);
  gtk_signal_connect_object (GTK_OBJECT
			     (GTK_FILE_SELECTION
			      (rw->report_selector)->cancel_button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (rw->report_selector));
  gtk_widget_show (rw->report_selector);
}

static void
cancel_clicked (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  REPORT_WIDGETS *rw =
    g_hash_table_lookup (my_config->stuff, "_report: REPORT_WIDGETS");
  gtk_widget_destroy (rw->report_dialog_window);
  g_free (rw);
  g_hash_table_remove (my_config->stuff, "_report: REPORT_WIDGETS");
  return;
}

static void destroy_window(GtkWidget * w, GdkEventKey *event, gpointer data)
{
  cancel_clicked(w, data);
}

void
open_report_dialog (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *frame;
  GtkWidget *table;
  GtkWidget *my_button;
  REPORT_WIDGETS *rw;

  GList *disk_list;
  GList *cat_list;

  rw = (REPORT_WIDGETS *) g_malloc (sizeof (REPORT_WIDGETS));
  g_hash_table_insert (my_config->stuff, "_report: REPORT_WIDGETS", rw);
  rw->report_dialog_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize (GTK_WIDGET (rw->report_dialog_window), 290, 305);
  gtk_container_border_width (GTK_CONTAINER (rw->report_dialog_window), 10);
  gtk_window_set_policy (GTK_WINDOW (rw->report_dialog_window), FALSE, FALSE,
			 TRUE);
  gtk_window_set_title (GTK_WINDOW (rw->report_dialog_window),
			_("Report generator"));
  gtk_signal_connect (GTK_OBJECT (rw->report_dialog_window), "delete_event",
		      destroy_window, my_config);
  gtk_widget_show (rw->report_dialog_window);


  vbox = gtk_vbox_new (FALSE, 4);
  gtk_container_add (GTK_CONTAINER (rw->report_dialog_window), vbox);
  gtk_widget_show (vbox);

  /**************/
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  label = gtk_label_new (_("Disk:"));
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  rw->disk_combo = gtk_combo_new ();
  gtk_combo_set_value_in_list (GTK_COMBO (rw->disk_combo), FALSE, TRUE);
  gtk_combo_set_use_arrows_always (GTK_COMBO (rw->disk_combo), TRUE);
  gtk_combo_disable_activate (GTK_COMBO (rw->disk_combo));

  disk_list = make_disk_list (my_config);
  disk_list = g_list_prepend (disk_list, ALL_DISKS);
  g_hash_table_insert (my_config->stuff, "_report: disk list", disk_list);
  gtk_combo_set_popdown_strings (GTK_COMBO (rw->disk_combo), disk_list);
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (rw->disk_combo)->entry),
			  FALSE);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (rw->disk_combo)->entry),
		      _("All disks"));
  /* gtk_signal_connect(GTK_OBJECT(GTK_COMBO(rw->disk_combo)->entry), "activate",
   * start_search,
   * GTK_OBJECT (search_dialog_window)); */
  gtk_box_pack_start (GTK_BOX (hbox), rw->disk_combo, FALSE, FALSE, 0);
  gtk_widget_show (rw->disk_combo);

  /********/


  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  label = gtk_label_new (_("Category:  "));
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  rw->cat_combobox = gtk_combo_new ();
  gtk_combo_set_value_in_list (GTK_COMBO (rw->cat_combobox), FALSE, TRUE);
  gtk_combo_set_use_arrows_always (GTK_COMBO (rw->cat_combobox), TRUE);
  gtk_combo_disable_activate (GTK_COMBO (rw->cat_combobox));

  cat_list = cat_list = make_categories_list (my_config);
  cat_list = g_list_append (cat_list, ALL_CATEGORIES);

  gtk_combo_set_popdown_strings (GTK_COMBO (rw->cat_combobox), cat_list);
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (rw->cat_combobox)->entry),
			  FALSE);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (rw->cat_combobox)->entry),
		      ALL_CATEGORIES);
  /* gtk_signal_connect(GTK_OBJECT(GTK_COMBO(rw->cat_combobox)->entry), "activate",
   * start_search,
   * GTK_OBJECT (rw->search_dialog_window)); */
  gtk_box_pack_start (GTK_BOX (hbox), rw->cat_combobox, FALSE, FALSE, 0);
  gtk_widget_show (rw->cat_combobox);

  /*********/

  frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame), _("Include to report"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
  gtk_widget_show (frame);

  table = gtk_table_new (3, 2, FALSE);
  gtk_container_add (GTK_CONTAINER (frame), table);
  gtk_widget_show (table);

  rw->check_disks = gtk_check_button_new_with_label (_("Disks"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rw->check_disks), TRUE);
  gtk_table_attach_defaults (GTK_TABLE (table), rw->check_disks, 0, 1, 0, 1);
  gtk_widget_show (rw->check_disks);

  rw->check_folders = gtk_check_button_new_with_label (_("Folders"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rw->check_folders), TRUE);
  gtk_table_attach_defaults (GTK_TABLE (table), rw->check_folders, 0, 1, 1,
			     2);
  gtk_widget_show (rw->check_folders);

  rw->check_files = gtk_check_button_new_with_label (_("Files"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rw->check_files), TRUE);
  gtk_table_attach_defaults (GTK_TABLE (table), rw->check_files, 0, 1, 2, 3);
  gtk_widget_show (rw->check_files);

  rw->check_category = gtk_check_button_new_with_label (_("Category"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rw->check_category), TRUE);
  gtk_table_attach_defaults (GTK_TABLE (table), rw->check_category, 0, 1, 3,
			     4);
  gtk_widget_show (rw->check_category);

  rw->check_location = gtk_check_button_new_with_label (_("Location"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rw->check_location),
				FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), rw->check_location, 1, 2, 0,
			     1);
  gtk_widget_show (rw->check_location);

  rw->check_description = gtk_check_button_new_with_label (_("Descriptions"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rw->check_description),
				FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), rw->check_description, 1, 2,
			     1, 2);
  gtk_widget_show (rw->check_description);

  rw->check_only_desc =
    gtk_check_button_new_with_label (_("Only items with description"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rw->check_only_desc),
				FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), rw->check_only_desc, 1, 2, 2,
			     3);
  gtk_widget_show (rw->check_only_desc);

  rw->check_only_cat =
    gtk_check_button_new_with_label (_("Only items with category"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rw->check_only_cat),
				FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), rw->check_only_cat, 1, 2, 3,
			     4);
  gtk_widget_show (rw->check_only_cat);

  /************/
  frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (frame), _("Sort by"));
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
  gtk_widget_show (frame);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_container_add (GTK_CONTAINER (frame), hbox);
  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
  gtk_widget_show (hbox);

  rw->button_sortbycat =
    gtk_radio_button_new_with_label (NULL, _("Category"));
  gtk_box_pack_start (GTK_BOX (hbox), rw->button_sortbycat, TRUE, TRUE, 0);
  gtk_widget_show (rw->button_sortbycat);

  rw->group_sort =
    gtk_radio_button_group (GTK_RADIO_BUTTON (rw->button_sortbycat));
  rw->button_sortbyfile =
    gtk_radio_button_new_with_label (rw->group_sort, _("Disk->folder->File"));
  gtk_box_pack_start (GTK_BOX (hbox), rw->button_sortbyfile, TRUE, TRUE, 0);
  gtk_widget_show (rw->button_sortbyfile);

  /************/
  frame = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
  gtk_widget_show (frame);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_container_add (GTK_CONTAINER (frame), hbox);
  gtk_container_border_width (GTK_CONTAINER (hbox), 3);
  gtk_widget_show (hbox);

  label = gtk_label_new (_("Output File:"));
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  rw->output_entry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (hbox), rw->output_entry, FALSE, FALSE, 0);
  gtk_widget_show (rw->output_entry);

  rw->output_button = gtk_button_new_with_label ("...");
  gtk_signal_connect (GTK_OBJECT (rw->output_button), "clicked",
		      GTK_SIGNAL_FUNC (select_report_file), my_config);
  gtk_box_pack_start (GTK_BOX (hbox), rw->output_button, FALSE, FALSE, 0);
  gtk_widget_show (rw->output_button);

  /*******************/
  /* Et c'est le tour de la petite boite a boutons! */
  hbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbox), 0);
  gtk_button_box_set_child_size (GTK_BUTTON_BOX (hbox), 0, 0);

  gtk_container_border_width (GTK_CONTAINER (hbox), 1);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  my_button = gtk_button_new_with_label (_("Create report"));
  GTK_WIDGET_SET_FLAGS (my_button, GTK_CAN_DEFAULT);
  gtk_window_set_default (GTK_WINDOW (rw->report_dialog_window), my_button);
  gtk_box_pack_start (GTK_BOX (hbox), my_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (my_button), "clicked",
		      GTK_SIGNAL_FUNC (begin_report), my_config);
  gtk_widget_show (my_button);

  my_button = gtk_button_new_with_label (_("Exit"));
  GTK_WIDGET_SET_FLAGS (my_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox), my_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (my_button), "clicked", cancel_clicked,
		      my_config);
  gtk_widget_show (my_button);

}
