/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>

#include "config_common.h"
#include "about.h"
#include "addisk.h"
#include "buttonbar.h"
#include "categories.h"
#include "edit.h"
#include "exit.h"
#include "fastaddisk.h"
#include "folder.h"
#include "interface.h"
#include "interface.h"
#include "io.h"
#include "loadcat.h"
#include "report.h"
#include "savecat.h"
#include "search.h"
#include "selectdir.h"
#include "setup.h"

#define P_FILE		100
#define P_GEOMETRY	101
#define P_WINTITLE	102
#define P_VERSION	103
static char *popt_filename = NULL;
static char *popt_geometry = NULL;
static char *popt_wintitle = NULL;
struct poptOption command_line[] = {
  {"catalog", 'c', POPT_ARG_STRING || POPT_ARGFLAG_ONEDASH, &popt_filename, P_FILE,
   N_("Catalog file to load."), "filename"},
  {"geometry", 'g', POPT_ARG_STRING || POPT_ARGFLAG_ONEDASH, &popt_geometry, P_GEOMETRY,
   N_("Geometry. See man X for more info.")},
  {"title", 't', POPT_ARG_STRING || POPT_ARGFLAG_ONEDASH, &popt_wintitle, P_WINTITLE,
   N_("Title of the window"), "text"},
  {"version", 'v', POPT_ARGFLAG_ONEDASH, NULL, P_VERSION,
   N_("Prints the version of " PACKAGE)},
  POPT_AUTOHELP {NULL, 0, 0, NULL, 0}
};



/* GNOME Menu */
GnomeUIInfo file_menu[] = {
  GNOMEUIINFO_MENU_NEW_ITEM (N_("New catalog"), N_("New catalog"), new_file,
			     NULL),
  GNOMEUIINFO_MENU_OPEN_ITEM (open_cat, NULL),
  GNOMEUIINFO_MENU_SAVE_ITEM (fast_save, NULL),
  GNOMEUIINFO_MENU_SAVE_AS_ITEM (save_cat, NULL),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_EXIT_ITEM (quit_prog, NULL),
  GNOMEUIINFO_END
};

GnomeUIInfo edit_menu[] = {
  GNOMEUIINFO_ITEM_NONE (N_("Edit categories"), NULL, edit_categories),
  GNOMEUIINFO_ITEM_NONE (N_("Clean descriptions"), NULL, clean_description),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_PREFERENCES_ITEM (run_setup, NULL),
  GNOMEUIINFO_END
};

GnomeUIInfo action_menu[] = {
  GNOMEUIINFO_ITEM_NONE (N_("Find file"), NULL, create_search_dialog),
  GNOMEUIINFO_ITEM_NONE (N_("Create Report"), NULL, open_report_dialog),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_NONE (N_("Fast Add"), NULL, fast_add_disk),
  GNOMEUIINFO_ITEM_NONE (N_("Add disk"), NULL, show_select_dir_win),
  GNOMEUIINFO_END
};

GnomeUIInfo help_menu[] = {
  GNOMEUIINFO_MENU_ABOUT_ITEM (about_gtktalog, NULL),
  GNOMEUIINFO_END
};

GnomeUIInfo menubar[] = {
  GNOMEUIINFO_MENU_FILE_TREE (file_menu),
  GNOMEUIINFO_MENU_EDIT_TREE (edit_menu),
  GNOMEUIINFO_SUBTREE (N_("Action"), action_menu),
  GNOMEUIINFO_MENU_HELP_TREE (help_menu),
  GNOMEUIINFO_END
};

GnomeUIInfo toolbar[] = {
  GNOMEUIINFO_MENU_FILE_TREE (file_menu),
  GNOMEUIINFO_MENU_EDIT_TREE (edit_menu),
  GNOMEUIINFO_SUBTREE (N_("Action"), action_menu),
  GNOMEUIINFO_MENU_HELP_TREE (help_menu),
  GNOMEUIINFO_END
};

int
main (int argc, char *argv[])
{
  GtkWidget *main_vbox;
  GtkWidget *window;
  GString *conf_file;
  CONFIG *my_config;
  poptContext optCon;
  GString *_title = NULL;
  GString *_filename = NULL;
  GString *_geometry = NULL;
  gint wx, wy, ww, wh;
  gchar c;


  bindtextdomain (PACKAGE, GNOMELOCALEDIR);
  textdomain (PACKAGE);
  gnome_init_with_popt_table (PACKAGE, VERSION, argc, argv, command_line, 0,
			      &optCon);
  optCon = poptGetContext (NULL, argc, argv, command_line, 0);

  /* Processing of arguments */

  while ((c = poptGetNextOpt (optCon)) >= 0)
    {
      switch (c)
	{
	case P_VERSION:
	  printf (_("Gtktalog\nVersion : %s\nLicence : GPL\n"
		    "More infos on http://gtktalog.sourceforge.net\n"),
		  VERSION);
	  exit (0);
	  break;
	case P_FILE:
	  _filename = g_string_new (popt_filename);
	  break;
	case P_GEOMETRY:
	  _geometry = g_string_new (popt_geometry);
	  break;
	case P_WINTITLE:
	  _title = g_string_new (popt_wintitle);
	  break;
	}
    }

  if (c < -1)
    {
      /* an error occurred during option processing */
      fprintf (stderr, "%s: %s\n",
	       poptBadOption (optCon, POPT_BADOPTION_NOALIAS),
	       poptStrerror (c));
      return (-1);
    }

  /*initialisation des differentes variables */

  window = gnome_app_new (PACKAGE, "gtktalog");

  if (_title)
    {
      gtk_window_set_title (GTK_WINDOW (window), _title->str);
      g_string_free (_title, TRUE);
    }
  else
    {
      gtk_window_set_title (GTK_WINDOW (window), "GTKtalog V " VERSION);
    }
  if (_geometry)
    {
      if (gnome_parse_geometry (_geometry->str, &wx, &wy, &ww, &wh) != TRUE)
	{
	  wx = 0;
	  wy = 0;
	  ww = 660;
	  wh = 350;
	}
      g_string_free (_geometry, TRUE);
    }
  else
    {
      wx = 0;
      wy = 0;
      ww = 660;
      wh = 350;
    }
  if (wx < 0)
    wx = 0;
  if (wy < 0)
    wy = 0;
  if (ww < 0)
    ww = 660;
  if (wh < 0)
    wh = 350;
  gtk_widget_set_uposition (GTK_WIDGET (window), wx, wy);
  gtk_widget_set_usize (GTK_WIDGET (window), ww, wh);

  gtk_widget_realize (window);

  main_vbox = gtk_vbox_new (FALSE, 1);
  gtk_container_border_width (GTK_CONTAINER (main_vbox), 1);
  gnome_app_set_contents (GNOME_APP (window), main_vbox);
  gtk_widget_show (main_vbox);

  conf_file = g_string_new (g_get_home_dir ());
  conf_file =
    g_string_append (conf_file, USER_CONFIG_DIR "/" USER_CONFIG_FILE);
  if (!g_file_test (conf_file->str, G_FILE_TEST_ISFILE))
    {
      g_string_free (conf_file, TRUE);
      conf_file = g_string_new (PREFIX "/share/gtktalog/gtktalog.cf");
      if (!g_file_test (conf_file->str, G_FILE_TEST_ISFILE))
	{
	  ERROR_DIALOG ("Could not find config file", window);
	  exit (-1);
	}
    }

  my_config = init_config (conf_file, GTK_WIDGET (window));
  my_config->stuff = g_hash_table_new (g_str_hash, g_str_equal);
  my_config->is_modified = FALSE;
  my_config->catalog_filename = g_string_new (_("No_name"));;
  my_config->catalog_filename_is_valid = FALSE;
  my_config->window = window;
  my_config->racine = NULL;
  my_config->categories = g_ptr_array_new ();
  my_config->descriptions = g_ptr_array_new ();
  my_config->update_edit_window = FALSE;
  my_config->calendar_widgets = NULL;
  my_config->getInformation = TRUE;
  my_config->selected_folder = NULL;
  init_file (my_config);

  gnome_app_create_menus_with_data (GNOME_APP (window), menubar, my_config);
  enable_gnome_button_bar (window, my_config);


  my_config->path_entry = gtk_entry_new_with_max_length (300);
  gtk_entry_set_editable (GTK_ENTRY (my_config->path_entry), FALSE);
  gtk_entry_set_text (GTK_ENTRY (my_config->path_entry), "");
  gtk_entry_append_text (GTK_ENTRY (my_config->path_entry), "");
  gtk_entry_select_region (GTK_ENTRY (my_config->path_entry),
			   0, GTK_ENTRY (my_config->path_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (main_vbox), my_config->path_entry, FALSE, TRUE,
		      0);
  gtk_widget_show (my_config->path_entry);



  my_config->hpaned = gtk_hpaned_new ();
  gtk_container_add (GTK_CONTAINER (main_vbox), my_config->hpaned);
  gtk_paned_set_handle_size (GTK_PANED (my_config->hpaned), 10);
  gtk_paned_set_gutter_size (GTK_PANED (my_config->hpaned), 10);
  gtk_widget_show (my_config->hpaned);


  my_config->clist_window = create_list (my_config);
  gtk_paned_add2 (GTK_PANED (my_config->hpaned), my_config->clist_window);
  gtk_widget_show (my_config->clist_window);

  my_config->ctree_window = create_tree (my_config);
  gtk_paned_add1 (GTK_PANED (my_config->hpaned), my_config->ctree_window);
  gtk_widget_show (my_config->ctree_window);

  /*

   * hbox = gtk_hbox_new (FALSE, 1);
   * gtk_container_border_width (GTK_CONTAINER (hbox), 1);
   * // gtk_container_add(GTK_CONTAINER(main_vbox), hbox);
   * gtk_box_pack_start (GTK_BOX (main_vbox), hbox, FALSE, FALSE, 0);
   * gtk_widget_show (hbox);
   * 
   * 
   * status_bar1 = gtk_statusbar_new ();
   * gtk_box_pack_start (GTK_BOX (hbox), status_bar1, TRUE, TRUE, 0);
   * gtk_widget_show (status_bar1);
   * status_context1 =
   * gtk_statusbar_get_context_id (GTK_STATUSBAR (status_bar1), "GTKtalog1");
   * 
   * status_bar2 = gtk_statusbar_new ();
   * gtk_box_pack_start (GTK_BOX (hbox), status_bar2, TRUE, TRUE, 0);
   * gtk_widget_show (status_bar2);
   * status_context2 =
   * gtk_statusbar_get_context_id (GTK_STATUSBAR (status_bar2), "GTKtalog2");
   */


  gtk_signal_connect (GTK_OBJECT (window), "delete_event", quit_prog,
		      my_config);
  gtk_widget_show (window);


  //under construction

  //test_setup_at_start();
  //  selected_file = -1;
  my_config->current_pid = getpid ();
  update_tree (my_config);
  /*  waitbox_is_open = 0; */

  if (_filename)
    {
      load_cat_from_file (_filename->str, my_config);
      update_tree (my_config);

      gtk_window_set_title (GTK_WINDOW (my_config->window),
			    my_config->catalog_filename->str);
      g_string_free (_filename, TRUE);
    }

  gtk_main ();

  return (0);
}
