/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __EDIT_H__
#define __EDIT_H__

#include "config_common.h"

typedef struct
{
  GtkWidget *edit_window;
  GtkWidget *fold_entry;
  GtkWidget *cat_box;
  GtkWidget *cat_combo;
  GtkWidget *cat_ed;
  GtkWidget *desc_combo;
  GtkWidget *recursive_category;
  GtkWidget *recursive_description;
  gpointer tmpdata;

}
EDIT_WIDGETS;

gboolean is_file_with_the_same_name(GNode *gn, gpointer data);
gboolean _change_category(GNode *gn, gpointer data);
gboolean _change_description(GNode *gn, gpointer data);
gint description_add(GPtrArray *description_array, gchar *text);
void delete_folder(GtkWidget *w, CONFIG *my_config);
void update_category_combo(CONFIG *my_config);
void edit_folder(GtkWidget *w, gpointer data);
void update_disk(GtkWidget *w, gpointer data);


#endif
