/*  GTKtalog.
 *  Copyright (C) 1999-2000  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <stdio.h>
#include <stdlib.h>

#include "addisk.h"
#include "edit.h"
#include "categories.h"
#include "interface.h"
#include "config_common.h"
#include "folder.h"
#include "io.h"

gchar EMPTY[] = N_("(empty)");

gboolean
is_file_with_the_same_name (GNode * gn, gpointer data)
{
  FILE_DATA *fd;
  CONFIG *my_config = data;

  fd =
    g_ptr_array_index (my_config->racine->datas, GPOINTER_TO_UINT (gn->data));
  if (strcmp
      (g_hash_table_lookup (my_config->stuff, "_edit: entry text"),
       fd->name->str) == 0)
    {
      g_hash_table_insert (my_config->stuff, "_edit: existing text", gn);
      return (TRUE);
    }
  return (FALSE);

}

gboolean
_change_category (GNode * gn, gpointer data)
{
  CONFIG *my_config = data;
  change_category (my_config->racine, gn,
		   GPOINTER_TO_UINT (GPOINTER_TO_UINT
				     (g_hash_table_lookup
				      (my_config->stuff,
				       "_edit:category id"))));
  return (FALSE);
}

gboolean
_change_description (GNode * gn, gpointer data)
{
  CONFIG *my_config = data;
  change_description (my_config->racine, gn,
		      GPOINTER_TO_UINT (g_hash_table_lookup
					(my_config->stuff,
					 "_edit:description id")));
  return (FALSE);
}

gint
description_add (GPtrArray * description_array, gchar * text)
{
  gint i;
  i = string_to_index (description_array, text);
  if (i)
    return (i);
  g_ptr_array_add (description_array, g_string_new (text));
  return (description_array->len);
}

static void
ok_clicked (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  gchar *entry_text, *entry_text2, *entry_text3;
  GNode *gn;
  FILE_DATA *fd;
  EDIT_WIDGETS *ew;
  GtkCTreeNode *gtknode;
  PIX *pix;
  GNode *tmpgn;

  gn = my_config->selected_folder;
  fd =
    g_ptr_array_index (my_config->racine->datas, GPOINTER_TO_UINT (gn->data));
  ew = g_hash_table_lookup (my_config->stuff, "_edit: EDIT WIDGETS");



  entry_text = gtk_entry_get_text (GTK_ENTRY (ew->fold_entry));
  entry_text2 =
    gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (ew->cat_combo)->entry));
  entry_text3 =
    gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (ew->desc_combo)->entry));

  if (strlen (entry_text) == 0)
    {
      ERROR_DIALOG ("Name field is empty.\nType a file name or cancel.",
		    ew->edit_window);
      return;
    }

  /* Is there a filename with the same name as entry_text ? */
  if (strcmp (fd->name->str, entry_text))
    {
      g_hash_table_insert (my_config->stuff, "_edit: entry text", entry_text);
      g_hash_table_insert (my_config->stuff, "_edit: existing text", NULL);
      g_node_traverse (gn->parent, G_POST_ORDER, G_TRAVERSE_ALL, 2,
		       is_file_with_the_same_name, my_config);
      tmpgn = g_hash_table_lookup (my_config->stuff, "_edit: existing text");
      g_hash_table_remove (my_config->stuff, "_edit: entry text");
      g_hash_table_remove (my_config->stuff, "_edit: existing text");
      if ((tmpgn) && (tmpgn != gn->parent))
	{
	  ERROR_DIALOG
	    ("A file/dir with the same name already exists in this directory",
	     ew->edit_window);
	  return;
	}
    }

  /* Change the category */
  if (strcmp (entry_text2, EMPTY))
    {
      fd->categorie = string_to_index (my_config->categories, entry_text2);
    }
  else
    fd->categorie = 0;
  if ((is_file (my_config->racine, my_config->selected_folder) == FALSE)
      && (is_link (my_config->racine, my_config->selected_folder) == FALSE))
    {
      if (gtk_toggle_button_get_active
	  (GTK_TOGGLE_BUTTON (ew->recursive_category)) == TRUE)
	{
	  g_hash_table_insert (my_config->stuff, "_edit:category id",
			       GUINT_TO_POINTER (0 + fd->categorie));
	  g_node_traverse (gn, G_PRE_ORDER, G_TRAVERSE_ALL, -1,
			   _change_category, my_config);
	  g_hash_table_remove (my_config->stuff, "_edit:category id");
	}
    }

  /* Change the descriptions ? */
  if (strcmp (entry_text3, EMPTY))
    {
      fd->description =
	description_add (my_config->descriptions, entry_text3);
    }
  else
    fd->description = 0;
  if ((is_file (my_config->racine, my_config->selected_folder) == FALSE)
      && (is_link (my_config->racine, my_config->selected_folder) == FALSE))
    {
      if (gtk_toggle_button_get_active
	  (GTK_TOGGLE_BUTTON (ew->recursive_description)) == TRUE)
	{
	  g_hash_table_insert (my_config->stuff, "_edit:description id",
			       GUINT_TO_POINTER (0 + fd->description));
	  g_node_traverse (gn, G_PRE_ORDER, G_TRAVERSE_ALL, -1,
			   _change_description, my_config);
	  g_hash_table_remove (my_config->stuff, "_edit:description id");
	}
    }

  /* Change the name ? */
  if (strcmp (fd->name->str, entry_text))
    {
      g_string_free (fd->name, TRUE);
      fd->name = g_string_new (entry_text);
      if (is_dir (my_config->racine, gn) == TRUE)
	{
	  gtknode = fd->ctree_node;
	  if (g_node_depth (gn) == 2)
	    pix = my_config->default_disk_pix;
	  else
	    pix = my_config->default_dir_pix;
	  gtk_ctree_set_node_info (GTK_CTREE (my_config->ctree),
				   gtknode, fd->name->str, 4,
				   pix->pixmap, *(pix->mask), pix->pixmap,
				   *(pix->mask),
				   GTK_CTREE_ROW (gtknode)->is_leaf,
				   GTK_CTREE_ROW (gtknode)->expanded);
	}


    }
  gtk_widget_destroy (ew->edit_window);
  g_free (ew);
  g_hash_table_remove (my_config->stuff, "_edit: EDIT WIDGETS");
  gtk_clist_clear (GTK_CLIST (my_config->clist));
  list_folder (my_config->selected_folder->parent, my_config);
  my_config->selected_folder = NULL;
  my_config->update_edit_window = FALSE;
  my_config->is_modified = TRUE;
}

void
delete_folder (GtkWidget * w, CONFIG * my_config)
{
  GNode *parent;
  parent = my_config->selected_folder->parent;
  suppress_dir (my_config->selected_folder, my_config);
  gtk_clist_clear (GTK_CLIST (my_config->clist));
  list_folder (parent, my_config);
}

static void
cancel_clicked (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  EDIT_WIDGETS *ew = g_hash_table_lookup (my_config->stuff, "_edit: EDIT WIDGETS");
  gtk_widget_destroy (ew->edit_window);
  g_free (ew);
  g_hash_table_remove (my_config->stuff, "_edit: EDIT WIDGETS");
  my_config->update_edit_window = FALSE;
  return;
}

static void destroy_window(GtkWidget * w, GdkEventKey *event, gpointer data)
{
  cancel_clicked(w, data);
}

void
update_category_combo (CONFIG * my_config)
{
  FILE_DATA *fd;
  EDIT_WIDGETS *ew = g_hash_table_lookup (my_config->stuff, "_edit: EDIT WIDGETS");
  GList *cat_list;
  gint i;

/*	gtk_widget_destroy (ew->cat_combo);
	ew->cat_combo = gtk_combo_new ();
	gtk_combo_set_value_in_list (GTK_COMBO (ew->cat_combo), FALSE, TRUE);
	gtk_combo_set_use_arrows_always (GTK_COMBO (ew->cat_combo), TRUE);
	gtk_combo_disable_activate (GTK_COMBO (ew->cat_combo));
	gtk_box_pack_start (GTK_BOX (ew->cat_box), ew->cat_combo, TRUE, TRUE, 0);
*/
  cat_list = NULL;
  cat_list = g_list_append (cat_list, EMPTY);
  for (i = 0; i < my_config->categories->len; i++)
    cat_list = g_list_append (cat_list, ((GString *)
					 g_ptr_array_index
					 (my_config->categories, i))->str);
  if (cat_list)
    gtk_combo_set_popdown_strings (GTK_COMBO (ew->cat_combo), cat_list);
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (ew->cat_combo)->entry),
			  FALSE);
  fd =
    g_ptr_array_index (my_config->racine->datas,
		       GPOINTER_TO_UINT (my_config->selected_folder->data));
  if (fd->categorie)
    {
      gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (ew->cat_combo)->entry),
			  get_categorie (my_config, fd->categorie));
    }
  gtk_widget_show (ew->cat_combo);

}

void
edit_folder (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  GtkWidget *vbox, *hbox, *the_box;
  GtkWidget *ok, *cancel;
  GtkWidget *frame;
  EDIT_WIDGETS *ew;
  FILE_DATA *fd;


  GList *cat_list;

  GList *desc_list;
  int i;

  ew = (EDIT_WIDGETS *) g_malloc (sizeof (EDIT_WIDGETS));
  g_hash_table_insert (my_config->stuff, "_edit: EDIT WIDGETS", ew);

  if (my_config->selected_folder != NULL)
    {

      fd =
	g_ptr_array_index (my_config->racine->datas,
			   GPOINTER_TO_UINT (my_config->
					     selected_folder->data));
      /* Window */
      ew->edit_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
      gtk_window_set_position (GTK_WINDOW (ew->edit_window),
			       GTK_WIN_POS_MOUSE);
      if ((is_file (my_config->racine, my_config->selected_folder) == TRUE)
	  || (is_link (my_config->racine, my_config->selected_folder) ==
	      TRUE)) gtk_widget_set_usize (GTK_WIDGET (ew->edit_window), 300,
					   170);
      else
	gtk_widget_set_usize (GTK_WIDGET (ew->edit_window), 300, 210);
      if (is_disk (my_config->racine, my_config->selected_folder) == 1)
	gtk_window_set_title (GTK_WINDOW (ew->edit_window), "Edit disk");
      else if (is_link (my_config->racine, my_config->selected_folder) ==
	       TRUE) gtk_window_set_title (GTK_WINDOW (ew->edit_window),
					   "Edit link");
      else if (is_dir (my_config->racine, my_config->selected_folder) == TRUE)
	gtk_window_set_title (GTK_WINDOW (ew->edit_window), "Edit folder");
      else if (is_file (my_config->racine, my_config->selected_folder) ==
	       TRUE) gtk_window_set_title (GTK_WINDOW (ew->edit_window),
					   "Edit file");
      gtk_window_set_policy (GTK_WINDOW (ew->edit_window), FALSE, FALSE,
			     TRUE);
      gtk_container_border_width (GTK_CONTAINER (ew->edit_window), 10);
      gtk_signal_connect (GTK_OBJECT (ew->edit_window),
			  "delete_event", destroy_window, my_config);
      gtk_grab_add (ew->edit_window);

      vbox = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (ew->edit_window), vbox);
      gtk_widget_show (vbox);

      /* First frame (edit label) */
      frame = gtk_frame_new (NULL);
      gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
      if (is_disk (my_config->racine, my_config->selected_folder) == TRUE)
	gtk_frame_set_label (GTK_FRAME (frame), _("Edit disk label"));
      else if (is_link (my_config->racine, my_config->selected_folder) ==
	       TRUE) gtk_frame_set_label (GTK_FRAME (frame), _("Link label"));
      else if (is_dir (my_config->racine, my_config->selected_folder) == TRUE)
	gtk_frame_set_label (GTK_FRAME (frame), _("Directory label"));
      else if (is_file (my_config->racine, my_config->selected_folder) ==
	       TRUE) gtk_frame_set_label (GTK_FRAME (frame), _("File label"));
      gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
      gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
      gtk_widget_show (frame);

      ew->fold_entry = gtk_entry_new_with_max_length (80);
      gtk_signal_connect (GTK_OBJECT (ew->fold_entry), "activate",
			  GTK_SIGNAL_FUNC (ok_clicked), my_config);
      gtk_entry_set_text (GTK_ENTRY (ew->fold_entry), fd->name->str);
      gtk_entry_select_region (GTK_ENTRY (ew->fold_entry),
			       0, GTK_ENTRY (ew->fold_entry)->text_length);
      gtk_container_add (GTK_CONTAINER (frame), ew->fold_entry);

      gtk_widget_show (ew->fold_entry);

      /* Second entry (category combo box) */
      frame = gtk_frame_new (NULL);
      gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
      if (is_disk (my_config->racine, my_config->selected_folder) == TRUE)
	gtk_frame_set_label (GTK_FRAME (frame), _("Change disk category"));
      else if (is_link (my_config->racine, my_config->selected_folder) ==
	       TRUE) gtk_frame_set_label (GTK_FRAME (frame),
					  _("Change link category"));
      else if (is_dir (my_config->racine, my_config->selected_folder) == TRUE)
	gtk_frame_set_label (GTK_FRAME (frame),
			     _("Change directory category"));
      else if (is_file (my_config->racine, my_config->selected_folder) ==
	       TRUE) gtk_frame_set_label (GTK_FRAME (frame),
					  _("Change file category"));
      gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
      gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
      gtk_widget_show (frame);

      ew->cat_box = gtk_hbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), ew->cat_box);
      gtk_widget_show (ew->cat_box);



      ew->cat_combo = gtk_combo_new ();
      gtk_combo_set_value_in_list (GTK_COMBO (ew->cat_combo), FALSE, TRUE);
      gtk_combo_set_use_arrows_always (GTK_COMBO (ew->cat_combo), TRUE);
      gtk_combo_disable_activate (GTK_COMBO (ew->cat_combo));
      gtk_box_pack_start (GTK_BOX (ew->cat_box), ew->cat_combo, TRUE, TRUE,
			  0);
      cat_list = NULL;
      cat_list = g_list_append (cat_list, EMPTY);
      for (i = 0; i < my_config->categories->len; i++)
	cat_list = g_list_append (cat_list, ((GString *)
					     g_ptr_array_index
					     (my_config->categories,
					      i))->str);
      if (cat_list)
	{
	  gtk_combo_set_popdown_strings (GTK_COMBO (ew->cat_combo), cat_list);
	  g_list_free (cat_list);
	}
      gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (ew->cat_combo)->entry),
			      FALSE);
      if (fd->categorie)
	{
	  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (ew->cat_combo)->entry),
			      get_categorie (my_config, fd->categorie));
	}
      gtk_widget_show (ew->cat_combo);


      ew->cat_ed = gtk_button_new_with_label ("...");
      gtk_box_pack_start (GTK_BOX (ew->cat_box), ew->cat_ed, FALSE, FALSE, 0);
      gtk_signal_connect (GTK_OBJECT (ew->cat_ed), "clicked",
			  GTK_SIGNAL_FUNC (edit_categories), my_config);
      gtk_widget_show (ew->cat_ed);


      /* Third entry (description combo box) */

      frame = gtk_frame_new (NULL);
      gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
      gtk_frame_set_label (GTK_FRAME (frame), _("Edit description"));
      gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
      gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
      gtk_widget_show (frame);

      ew->desc_combo = gtk_combo_new ();
      gtk_combo_set_value_in_list (GTK_COMBO (ew->desc_combo), FALSE, TRUE);
      gtk_combo_set_use_arrows_always (GTK_COMBO (ew->desc_combo), TRUE);
      gtk_combo_disable_activate (GTK_COMBO (ew->desc_combo));
      gtk_container_add (GTK_CONTAINER (frame), ew->desc_combo);
      desc_list = NULL;
      desc_list = g_list_append (desc_list, EMPTY);
      for (i = 0; i < my_config->descriptions->len; i++)
	desc_list = g_list_append (desc_list, ((GString *)
					       g_ptr_array_index
					       (my_config->descriptions,
						i))->str);
      if (desc_list)
	gtk_combo_set_popdown_strings (GTK_COMBO (ew->desc_combo), desc_list);
      if (fd->description)
	{
	  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (ew->desc_combo)->entry),
			      get_description (my_config, fd->description));
	}
      gtk_widget_show (ew->desc_combo);


      if ((is_file (my_config->racine, my_config->selected_folder) == FALSE)
	  && (is_link (my_config->racine, my_config->selected_folder) ==
	      FALSE))
	{
	  frame = gtk_frame_new (NULL);
	  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
	  gtk_frame_set_label (GTK_FRAME (frame),
			       _("Propagate in subdirs and files"));
	  gtk_frame_set_label_align (GTK_FRAME (frame), 0.0, 0.0);
	  gtk_frame_set_shadow_type (GTK_FRAME (frame),
				     GTK_SHADOW_ETCHED_OUT);
	  gtk_widget_show (frame);

	  the_box = gtk_hbox_new (FALSE, 0);
	  gtk_container_add (GTK_CONTAINER (frame), the_box);
	  gtk_widget_show (the_box);

	  ew->recursive_category =
	    gtk_check_button_new_with_label (_("Category"));
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					(ew->recursive_category), FALSE);
	  gtk_box_pack_start (GTK_BOX (the_box), ew->recursive_category,
			      FALSE, TRUE, 0);
	  gtk_widget_show (ew->recursive_category);

	  ew->recursive_description =
	    gtk_check_button_new_with_label ("Description");
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					(ew->recursive_description), FALSE);
	  gtk_box_pack_start (GTK_BOX (the_box), ew->recursive_description,
			      FALSE, TRUE, 0);
	  gtk_widget_show (ew->recursive_description);
	}

      /* Buttons */
      hbox = gtk_hbutton_box_new ();
      gtk_button_box_set_layout (GTK_BUTTON_BOX (hbox), GTK_BUTTONBOX_END);
      gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbox), 5);

      ok = gnome_stock_button (GNOME_STOCK_BUTTON_OK);
      GTK_WIDGET_SET_FLAGS (ok, GTK_CAN_DEFAULT);
      gtk_window_set_default (GTK_WINDOW (ew->edit_window), ok);
      gtk_box_pack_start (GTK_BOX (hbox), ok, TRUE, TRUE, 0);
      gtk_signal_connect (GTK_OBJECT (ok), "clicked",
			  GTK_SIGNAL_FUNC (ok_clicked), my_config);
      gtk_widget_show (ok);

      cancel = gnome_stock_button (GNOME_STOCK_BUTTON_CANCEL);
      GTK_WIDGET_SET_FLAGS (cancel, GTK_CAN_DEFAULT);
      gtk_box_pack_start (GTK_BOX (hbox), cancel, TRUE, TRUE, 0);
      gtk_signal_connect (GTK_OBJECT (cancel), "clicked", cancel_clicked,
			  my_config);
      gtk_widget_show (cancel);

      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
      gtk_widget_show (hbox);

      gtk_widget_show (ew->edit_window);
      my_config->update_edit_window = TRUE;

    }
}

void
update_disk (GtkWidget * w, gpointer data)
{
  CONFIG *my_config = data;
  GNode *parent;
  gchar *folder_name, *disk_name;

  parent = my_config->selected_folder;
  disk_name = g_strdup (folder_get_name (my_config->racine, parent));
  folder_name =
    g_strdup (folder_get_informations (my_config->racine, parent));

  suppress_dir (my_config->selected_folder, my_config);
  gtk_clist_clear (GTK_CLIST (my_config->clist));
  start_add_disk (folder_name, disk_name, my_config);
  g_free (folder_name);
  g_free (disk_name);
}
