/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _UTILS_H_
#define _UTILS_H_

#include"compl.h"

#ifdef __cplusplus
extern "C" {
#endif

#define XX_AGNUM  0
#define XX_UFLOW  1
#define XX_OFLOW  2
#define XX_NAN    3

int xx_isspace   (char c);
int xx_maybeinop (char c);
int xx_maybeinid (char c);
int xx_isacceptable (char c);
int xx_str2id (const char *s, char **endp);
int xx_str2op (const char *s, char **endp);
int xx_str2r  (const char *s, char **endp, r_eal * r);
int xx_str2c  (const char *s, char **endp, c_omplex * z);
ui_nteger xx_c2ui (c_omplex z, int* isanui);

#ifdef __cplusplus
}
#endif
#endif /* _UTILS_H_ */
