/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _TOKSTACK_H_
#define _TOKSTACK_H_

#include"mathtok.h"

#ifdef __cplusplus
extern "C" {
#endif

struct __xx_toknode
{
  xx_mathtoken *ptoken;
  struct __xx_toknode *next;
};

typedef struct __xx_toknode xx_toknode;

typedef struct
{
  xx_toknode *first;
  ui_nteger length;
} xx_tokstack;

/* 
   Whenever one of the functions below ( except xx_ts_isempty() ) 
   returns an int, 0 means failure, !0 successfull execution 
*/

/* 
   xx_ts_init() initializes the stack pointed to by 'ts'. 
   It should be called on a stack before performing any other operation.
*/
void xx_ts_init (xx_tokstack * ts);

/* xx_ts_push() pushes a xx_mathtoken on the stack pointed to by 'ts'.    */
int xx_ts_push (xx_tokstack * ts, b_yte type, long priority, c_omplex value,
		const char *name, str_s_ize lname);

/* 
   xx_ts_pop() removes from the top of the stack pointed to by 'ts' the first
   xx_mathtoken.                                                           
*/
void xx_ts_pop (xx_tokstack * ts);

/* xx_ts_destroy() destroys the stack pointed to by 'ts'.                  */
void xx_ts_destroy (xx_tokstack * ts);

/* 
   xx_ts_top() puts in *PTOK the xx_mathtoken at the top of the stack 'ts'.
   xx_ts_top() returns 0 if and only if 'ts' is empty!                     
*/
int xx_ts_top (xx_tokstack ts, xx_mathtoken * ptok);

/* 
   xx_ts_run() lets you run the stack pointed to by 'ts'. The first time
   xx_ts_run() is called on a stack, a pointer to this one should be  passed 
   as first argument; after, the first argument should be NULL if you want    
   to actually run the stack: if you pass, as first argument, a pointer    
   to an existent stack, xx_ts_run() will start to run (or re-run) this stack.
   xx_ts_run() returns a pointer to a xx_mathtoken till it reaches the end 
   of the stack pointed to by 'ts'. When this happens, it returns NULL.      
*/
const xx_mathtoken *xx_ts_run (const xx_tokstack * ts);

/* 
   xx_ts_isempty() returns !0 if 'ts' is an empty stack,  
   otherwise it returns 0. 
*/
int xx_ts_isempty (xx_tokstack ts);

/* 
   xx_ts_len() returns the length of 'ts', i.e. the number of non-NULL nodes
   which form the stack.                                                    
*/
ui_nteger xx_ts_len (xx_tokstack ts);

#ifdef __cplusplus
}
#endif

#endif /* _TOKSTACK_H_ */
