/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include<stdio.h>
#include<stdlib.h>
#include<xxcalc/compl.h>
#include<xxcalc/evaluate.h>

int
main (void)
{
  const char *nlist[] = {
    "EA", "EB", "EC", "ED", "EF", "X", "Y", "Z", NULL
  };
  c_omplex vlist[] = {
    {-1, -1},
    {-2, -2},
    {-3, -3},
    {-4, -4},
    {-5, -5},
    {1, 1},
    {2, 2},
    {3, 3}
  };
  const char* yanl[] = {
    "ZA", "Z", "SA", "S", "DDA", "DD", NULL
  };
  c_omplex yavl[] = {
    { 0, 7},
    { 0, 6},
    { 0, 5},
    { 0, 4},
    { 0, 3},
    { 0, 2}
  };
  const char* nulllist[] = {
    NULL
  };
  c_omplex zerolist[] = {
    {0, 0}
  };
  const char* name;
  c_omplex z;
  i_nteger i, pos, from, to;

  if( !xx_mklists(3) )
    {
      fprintf (stderr, "Cannot allocate the requested number of varlists, exiting\n");
      return -1;
    }
  else
    printf ("Allocated %u varlists\n", xx_gettnl() );
  if( !( name = xx_at (3, 0, NULL) ) )
    fprintf( stderr, "Cannot read the variable of the varlist 3 in position 0\n");
  else
    printf ("The variable of 3 in position 0 has name %s\n", name);
  if ( (pos = xx_getpointer (3, "EA")) < 0)
    fprintf (stderr, "Cannot look for the variable \"EA\" inside the varlist 3\n");
  else
    printf ("The position of \"EA\" inside the varlist 3 is %ld\n", pos);
  /* *** */
  if( !( name = xx_at (0, 0, NULL) ) )
    fprintf( stderr, "Cannot read the variable of the varlist 0 in position 0\n");
  else
    printf ("The variable of 0 in position 0 has name %s\n", name);
  if ( (pos = xx_getpointer (0, "EA")) < 0)
    fprintf (stderr, "Cannot find the variable \"EA\" inside the varlist 0\n");
  else
    printf ("The position of \"EA\" inside the varlist 0 is %ld\n", pos);
  /* *** */
  if( !( name = xx_at (0, 0, &z) ) )
    {
      fprintf (stderr, "Cannot read the variable of the varlist 0 in position 0\n");
      fprintf (stderr, "So I have given to it the default value (");
      c_fwrt (stderr, 1, 2, z);
      fprintf (stderr, ")\n");
    }
  else
    {
      printf ("The variable of 0 in position 0 has name %s\n", name);
      printf ("And its value is \t");
      c_wrt(1, 12, z);
      putchar ('\n');
    }
  /* *** */
  if( !xx_rebuild (3, nulllist, zerolist) )
    fprintf (stderr, "Cannot build the varlist 3\n");
  else
    printf ("Varlist 3 is an empty list; in fact it has length %lu\n", xx_getll (0));
  if( !xx_addvars (3, nulllist, zerolist) )
    fprintf (stderr, "\'xx_addvars (3, nulllist, zerolist)\': Error occurred\n");
  else
    printf ("After \'xx_addvars (3, nulllist, zerolist)\' varlist 3 has length equal to %lu\n", xx_getll (0));
  /* *** */
  if( !xx_rebuild (0, nulllist, zerolist) )
    fprintf (stderr, "Cannot build the varlist 0\n");
  else
    printf ("Varlist 0 is an empty list; in fact it has length %lu\n", xx_getll (0));
  if( !xx_rebuild (0, nlist, vlist) )
    fprintf (stderr, "Cannot build the varlist 0\n");
  else
    printf ("Builded the varlist 0\n");
  printf ("Now the length of the varlist 0 is %lu\n", xx_getll (0));
  printf ("These are its elements:\n");
  for(i=0 ; i<xx_getll (0); i++)
    {
      name = xx_at (0, i, &z);
      pos = xx_getpointer (0, name);
      printf ("[%ld] %s\t = \t", pos, name);
      c_wrt (1, 12, z);
      putchar ('\n');
    }
  printf ("And this is the list of the names of its elements\n");
  for(i=0 ; i<xx_getll (0); i++)
    {
      name = xx_at (0, i, NULL);
      printf ("%s ", name);
    }
  putchar ('\n');
  if( !xx_addvars (0, nulllist, zerolist) )
    fprintf (stderr, "\'xx_addvars (0, nulllist, zerolist)\': Error occurred\n");
  else
    printf ("After \'xx_addvars (0, nulllist, zerolist)\' varlist 0 has length equal to %lu\n", xx_getll (0));
  /* *** */
  if( !xx_rebuild (0, yanl, yavl) )
    fprintf (stderr, "Cannot rebuild the varlist 0\n");
  else
    printf ("Rebuilded the varlist 0\n");
  printf ("Now the length of the varlist 0 is %lu\n", xx_getll (0));
  printf ("These are its elements:\n");
  for(i=0 ; i<xx_getll (0); i++)
    {
      name = xx_at (0, i, &z);
      pos = xx_getpointer (0, name);
      printf ("[%ld] %s\t = \t", pos, name);
      c_wrt (1, 12, z);
      putchar ('\n');
    }
  printf ("And this is the list of the names of its elements\n");
  for(i=0 ; i<xx_getll (0); i++)
    {
      name = xx_at (0, i, NULL);
      printf ("%s ", name);
    }
  putchar ('\n');
  /* *** */
  if( !xx_rebuild (1, nlist, vlist) )
    fprintf (stderr, "Cannot build the varlist 1\n");
  else
    printf ("Builded the varlist 1\n");
  printf ("Now the length of the varlist 1 is %lu\n", xx_getll (1));
  printf ("These are its elements:\n");
  for(i=0 ; i<xx_getll (1); i++)
    {
      name = xx_at (1, i, &z);
      pos = xx_getpointer (1, name);
      printf ("[%ld] %s\t = \t", pos, name);
      c_wrt (1, 12, z);
      putchar ('\n');
    }
  printf ("And this is the list of the names of its elements\n");
  for(i=0 ; i<xx_getll (1); i++)
    {
      name = xx_at (1, i, NULL);
      printf ("%s ", name);
    }
  putchar ('\n');
  /* *** */
  printf ("We are going to test the xx_assign function...\n");
  if( !xx_assign (3, 0, c_reset (2*i, 2*i+1)) )
    fprintf (stderr, "Error in xx_assign (list 3, index 0)\n");
  if( !xx_assign (2, 0, c_reset (2*i, 2*i+1)) )
    fprintf (stderr, "Error in xx_assign (list 2, index 0)\n");
  printf ("Varlist 0: \n");
  for(i=0 ; i<= xx_getll (0); i++)
    {
      if( !xx_assign (0, i, c_reset (2*i, 2*i+1)) )
	fprintf (stderr, "Error in xx_assign (list 0, index %ld)\n", i);
      else
	{
	  name = xx_at (0, i, &z);
	  printf ("The new value of %s is \t", name);
	  c_wrt (1, 12, z);
	  putchar ('\n');
	}
    }
  printf ("Varlist 1: \n");
  for(i=0 ; i<= xx_getll (1); i++)
    {
      if( !xx_assign (1, i, c_reset (-2*i, -2*i-1)) )
	fprintf (stderr, "Error in xx_assign (list 1, index %ld)\n", i);
      else
	{
	  name = xx_at (1, i, &z);
	  printf ("The new value of %s is \t", name);
	  c_wrt (1, 12, z);
	  putchar ('\n');
	}
    }
  /* *** */
  printf ("Now is the moment to test xx_getpos()...\n");
  if( (pos = xx_getpos (3, "EA", 0, 0)) < 0 )
    fprintf (stderr, "Cannot find \"EA\" into the segment [0, 0] of the varlist 3\n");
  else
    printf ("xx_getpos() [0, 0]: Found \"EA\" in position %ld of the varlist 3\n", pos);
  if( (pos = xx_getpos (2, "EA", 0, 0)) < 0 )
    fprintf (stderr, "Cannot find \"EA\" into the segment [0, 0] of the varlist 2\n");
  else
    printf ("xx_getpos() [0, 0]: Found \"EA\" in position %ld of the varlist 2\n", pos);
  if( (pos = xx_getpos (0, "", 0, xx_getll (0)-1)) < 0 )
    fprintf (stderr, "xx_getpos(): Cannot find \"\" into the varlist 0\n");
  else
    printf ("xx_getpos(): Found \"\" in position %ld of the varlist 0\n", pos);
  if( (pos = xx_getpos (0, NULL, 0, xx_getll (0)-1)) < 0 )
    fprintf (stderr, "xx_getpos(): Cannot find \"\" into the varlist 0\n");
  else
    printf ("xx_getpos(): Found \"\" in position %ld of the varlist 0\n", pos);
  for (from = -1; from <= (i_nteger)xx_getll (0); from++)
    {
      for (to = -1; to <= (i_nteger)xx_getll (0); to++)
	{
	  if( (pos = xx_getpos (0, "SA", from, to)) < 0 )
	    fprintf (stderr, "Cannot find \"SA\" into the segment [%ld, %ld] of the varlist 0\n", from, to);
	  else
	    printf ("xx_getpos() [%ld, %ld]: Found \"SA\" in position %ld of the varlist 0\n", from, to, pos);
	}
    }
  printf ("Press <Return> to continue\n");
  getchar ();
  /* *** */
  printf ("List of the elements of the varlist 0:\n");
  for(i=0 ; i<xx_getll (0); i++)
    {
      name = xx_at (0, i, NULL);
      printf ("%s ", name);
    }
  putchar ('\n');
  printf ("List of the elements of the varlist 1:\n");
  for(i=0 ; i<xx_getll (1); i++)
    {
      name = xx_at (1, i, NULL);
      printf ("%s ", name);
    }
  putchar ('\n');
  printf ("Now is the moment to test xx_getrange()...\n");
  xx_getrange (3, "", &from, &to);
  if( from < 0 )
    fprintf (stderr, "xx_getrange(): Cannot find any variable inside the varlist 3\n");
  else
    printf ("After xx_getrange(3, \"\", &from, &to) we have from = %ld, to = %ld\n", from, to);
  xx_getrange (0, NULL, &from, &to);
  if( from < 0 )
    fprintf (stderr, "xx_getrange(): Cannot find any variable inside the varlist 0 which starts with the prefix NULL\n");
  else
    printf ("After xx_getrange(0, NULL, &from, &to) we have from = %ld, to = %ld\n", from, to);
  xx_getrange (0, "", &from, &to);
  if( from < 0 )
    fprintf (stderr, "xx_getrange(): Cannot find any variable inside the varlist 0\n");
  else
    printf ("After xx_getrange(0, \"\", &from, &to) we have from = %ld, to = %ld\n", from, to);
  printf ("Remember that the length of the varlist 0 is %lu\n", xx_getll (0));
  xx_getrange (1, "E", &from, &to);
  if( from < 0 )
    fprintf (stderr, "xx_getrange(): Cannot find any variable inside the varlist 1 which starts with the prefix \"E\"\n");
  else
    printf ("After xx_getrange(1, \"E\", &from, &to) we have from = %ld, to = %ld\n", from, to);
  xx_getrange (1, "EA", &from, &to);
  if( from < 0 )
    fprintf (stderr, "xx_getrange(): Cannot find any variable inside the varlist 1 which starts with the prefix \"EA\"\n");
  else
    printf ("After xx_getrange(1, \"EA\", &from, &to) we have from = %ld, to = %ld\n", from, to);
  xx_getrange (1, "EAX", &from, &to);
  if( from < 0 )
    fprintf (stderr, "xx_getrange(): Cannot find any variable inside the varlist 1 which starts with the prefix \"EAX\"\n");
  else
    printf ("After xx_getrange(1, \"EAX\", &from, &to) we have from = %ld, to = %ld\n", from, to);
  xx_getrange (1, "X", &from, &to);
  if( from < 0 )
    fprintf (stderr, "xx_getrange(): Cannot find any variable inside the varlist 1 which starts with the prefix \"X\"\n");
  else
    printf ("After xx_getrange(1, \"X\", &from, &to) we have from = %ld, to = %ld\n", from, to);
  xx_getrange (1, "DD", &from, &to);
  if( from < 0 )
    fprintf (stderr, "xx_getrange(): Cannot find any variable inside the varlist 1 which starts with the prefix \"DD\"\n");
  else
    printf ("After xx_getrange(1, \"DD\", &from, &to) we have from = %ld, to = %ld\n", from, to);
  xx_getrange (0, "DD", &from, &to);
  if( from < 0 )
    fprintf (stderr, "xx_getrange(): Cannot find any variable inside the varlist 0 which starts with the prefix \"DD\"\n");
  else
    printf ("After xx_getrange(0, \"DD\", &from, &to) we have from = %ld, to = %ld\n", from, to);
  /* *** */
  printf ("Now is the moment to test xx_copyvars()...\n");
  if( !xx_copyvars (3, 0, 0, 0) )
    fprintf (stderr, "xx_copyvars (3, 0, 0, 0): Error: Varlist 3 does not exists !\n");
  else
    printf ("xx_copyvars (3, 0, 0, 0): Success\n");
  if( !xx_copyvars (0, 3, 0, 0) )
    fprintf (stderr, "xx_copyvars (0, 3, 0, 0): Error: Varlist 3 does not exists !\n");
  else
    printf ("xx_copyvars (0, 3, 0, 0): Success\n");
  if( !xx_copyvars (0, 0, 0, 0) )
    fprintf (stderr, "xx_copyvars (0, 0, 0, 0): Error: Source == Destination !\n");
  else
    printf ("xx_copyvars (3, 0, 0, 0): Success\n");
  if( !xx_copyvars (0, 1, 0, xx_getll (1)) )
    fprintf (stderr, "xx_copyvars (0, 1, 0, xx_getll (1)): Error: Last argument must be < length of 1 !\n");
  else
    printf ("xx_copyvars (0, 1, 0, xx_getll (1)): Success\n");
  printf ("List of the elements of the varlist 0:\n");
  for(i=0 ; i<xx_getll (0); i++)
    {
      name = xx_at (0, i, &z);
      pos = xx_getpointer (0, name);
      printf ("[%ld] %s\t = \t", pos, name);
      c_wrt (1, 12, z);
      putchar ('\n');
    }
  printf ("List of the elements of the varlist 1:\n");
  for(i=0 ; i<xx_getll (1); i++)
    {
      name = xx_at (1, i, &z);
      pos = xx_getpointer (1, name);
      printf ("[%ld] %s\t = \t", pos, name);
      c_wrt (1, 12, z);
      putchar ('\n');
    }
  for (from = 2, to = 0; to < xx_getll (0); to++)
    {
      if( !xx_copyvars (1, 0, from, to) )
	fprintf (stderr, "xx_copyvars (1, 0, %ld, %ld): Error occurred\n", from ,to);
      else
	{
	  printf ("After xx_copyvars (1, 0, %ld, %ld)\n", from, to);
	  printf ("this is the list of the current elements of the varlist 1:\n");
	  for(i=0 ; i<xx_getll (1); i++)
	    {
	      name = xx_at (1, i, &z);
	      pos = xx_getpointer (1, name);
	      printf ("[%ld] %s\t = \t", pos, name);
	      c_wrt (1, 12, z);
	      putchar ('\n');
	    }
	  printf ("Press <Return> to continue\n");
	  getchar ();
	}
    }
  /* *** */
  if( (pos = xx_getpointer (0, NULL)) < 0 )
    fprintf (stderr, "xx_getpointer(): Cannot find NULL inside the varlist 0\n");
  else
    printf ("xx_getpointer(): Found NULL at the position %ld of the varlist 0\n", pos);
  if( (pos = xx_getpointer (0, "")) < 0 )
    fprintf (stderr, "xx_getpointer(): Cannot find \"\" inside the varlist 0\n");
  else
    printf ("xx_getpointer(): Found \"\" at the position %ld of the varlist 0\n", pos);
  /* *** */
  xx_rmlists();
  printf ("\nRemoved all varlists previously allocated,\n");
  printf ("Program terminated, bye!\n");
  return 0;
}
