/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include<stdio.h>
#include<stdlib.h>
#include<xxcalc/compl.h>
#include<xxcalc/evaluate.h>
/* Do not put the 3 lines below in your programs ! They are useful only for */
/* enhanced debugging (if you have the Dmalloc library).                    */
#ifdef DMALLOC 
#include <dmalloc.h>
#endif

#define FAILURE 0

int
main (void)
{
  FILE *rf, *wf;
  const char *nlist[] = {
    "EA", "EB", "EC", "ED", "EF", "X", "Y", "Z", NULL
  };
  c_omplex vlist[] = {
    {-1, -1},
    {-2, -2},
    {-3, -3},
    {-9.999999e6, -9.999999e6},
    {-5.0e7, -5.0e7},
    {-1.0e7, -9.9999999999e6},
    {2, 2},
    {3, 3}
  };
  int i;
  char **namelist;
  c_omplex *valuelist;

  if (!(rf = fopen ("./varlist.txt", "r")))
    {
      fprintf (stderr, "Cannot open ./varlist.txt\n");
      return -1;
    }
  else if (!(wf = fopen ("./varlist.doc", "w")))
    {
      fprintf (stderr, "Cannot open ./varlist.doc\n");
      return -1;
    }
  else
    {
      printf ("At the start we have %u stack(s) allocated\n", xx_gettns ());
      if (xx_mkstacks (XX_MAX_NUM_STACKS + 1) == FAILURE)
	fprintf (stderr, "mkstacks(): Cannot create more than %u stacks\n",
		 XX_MAX_NUM_STACKS);
      else			/* Never executed */
	printf ("Created %u stack(s)\n", XX_MAX_NUM_STACKS + 1);
      if (xx_mkstacks (XX_MAX_NUM_STACKS) == FAILURE)
	fprintf (stderr, "mkstacks(): Cannot create %u stacks\n",
		 XX_MAX_NUM_STACKS);
      else
	printf ("Created %u stack(s)\n", xx_gettns ());
      if (!xx_addnewstack ())
	fprintf (stderr, "Cannot add a new empty stack\n");
      else			/* Never executed */
	printf ("Added a new empty stack: now there are %u stacks\n",
		xx_gettns ());
      printf ("I am going to remove all previously allocated stacks...");
      xx_rmstacks ();
      printf ("done\n");
      if (xx_mkstacks (0) == FAILURE)
	fprintf (stderr, "mkstacks(): Cannot create %u stack(s)\n",
		 XX_DEF_NUM_STACKS);
      else
	printf ("Created %u stack(s)\n", xx_gettns ());
      if (xx_mkstacks (1) == FAILURE)
	fprintf (stderr, "mkstacks(): Cannot create %u new stack(s)\n", 1);
      else			/* Never executed */
	printf ("Created %u new stack(s)\n", 1);
      if (!xx_addnewstack ())
	fprintf (stderr, "Cannot add a new empty stack\n");
      else
	printf ("Added a new empty stack: now there is/are %u stack(s)\n",
		xx_gettns ());
      printf ("I am going to remove all previously allocated stacks...");
      xx_rmstacks ();
      printf ("done\n");
      printf ("Now we have %u stack(s)\n", xx_gettns ());
      if (!xx_addnewstack ())
	fprintf (stderr, "Cannot create a new empty stack\n");
      else
	printf ("Added a new empty stack: now there is/are %u stack(s)\n",
		xx_gettns ());
      if (xx_mkstacks (1) == FAILURE)
	fprintf (stderr, "mkstacks(): Cannot create %u new stack(s)\n", 1);
      else
	printf ("Created %u new stack(s)\n", 1);
      /*                                 */
      /* I have finished with the stacks */
      /*                                 */
      printf ("\nAt the start we have %u varlist(s) allocated\n", xx_gettnl ());
      if (xx_mklists (XX_MAX_NUM_LISTS + 1) == FAILURE)
	fprintf (stderr, "mklists(): Cannot create more than %u lists\n",
		 XX_MAX_NUM_LISTS);
      else			/* Never executed */
	printf ("Created %u list(s)\n", XX_MAX_NUM_LISTS + 1);
      if (xx_mklists (XX_MAX_NUM_LISTS) == FAILURE)
	fprintf (stderr, "mklists(): Cannot create %u list(s)\n",
		 XX_MAX_NUM_LISTS);
      else
	printf ("Created %u list(s)\n", xx_gettnl ());
      if (!xx_addnewlist ())
	fprintf (stderr, "Cannot add a new empty list\n");
      else			/* Never executed */
	printf ("Added a new empty list: now there is/are %u list(s)\n",
		xx_gettnl ());
      printf ("I am going to remove all previously allocated lists...");
      xx_rmlists ();
      printf ("done\n");
      if (xx_mklists (0) == FAILURE)
	fprintf (stderr, "mklists(): Cannot create %u list(s)\n",
		 XX_DEF_NUM_LISTS);
      else
	printf ("Created %u list(s)\n", xx_gettnl ());
      if (xx_mklists (1) == FAILURE)
	fprintf (stderr, "mklists(): Cannot create %u new list(s)\n", 1);
      else			/* Never executed */
	printf ("Created %u new list(s)\n", 1);
      if (!xx_addnewlist ())
	fprintf (stderr, "Cannot add a new empty list\n");
      else
	printf ("Added a new empty list: now there is/are %u list(s)\n",
		xx_gettnl ());
      printf ("I am going to remove all previously allocated lists...");
      xx_rmlists ();
      printf ("done\n");
      printf ("Now we have %u list(s)\n", xx_gettnl ());
      for (i = 0; i < 3; i++)
	{
	  if (!xx_addnewlist ())
	    fprintf (stderr, "Cannot create a new empty list\n");
	  else
	    printf ("Added a new empty list: now there is/are %u list(s)\n",
		    xx_gettnl ());
	}
      if (xx_mklists (3) == FAILURE)
	fprintf (stderr, "mklists(): Cannot create %u new list(s)\n", 3);
      else
	printf ("Created %u new list(s)\n", xx_gettnl ());
      /* Now I want to test xx_seekprefix() and xx_seeksuffix(). */
      namelist = xx_seekprefix (0, "A", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seekprefix(0,\"A\")\n");
      else
	{
	  fprintf (wf,
		   "List of the variables of the list 0 starting with the prefix \"A\":\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      printf ("%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      namelist = xx_seekprefix (0, "", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seekprefix(0,\"\")\n");
      else
	{
	  fprintf (wf, "List of the variables of the list 0 :\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      printf ("%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      namelist = xx_seeksuffix (0, "A", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seeksuffix(0,\"A\")\n");
      else
	{
	  fprintf (wf,
		   "List of the variables of the list 0 ending with the suffix \"A\":\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      printf ("%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      namelist = xx_seeksuffix (0, "", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seeksuffix(0,\"\")\n");
      else
	{
	  fprintf (wf, "List of the variables of the list 0 :\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      printf ("%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      /* Now I want to test fbuild(), fload(), load() and fwrt(). */
      if (xx_fbuild (rf, 0) == FAILURE)
	fprintf (stderr, "Cannot load variables in the list 0\n");
      else
	printf ("Loaded variables in the list 0\n");
      if (!xx_addvars (0, nlist, vlist))
	fprintf (stderr, "Cannot add variables to the list 0\n");
      else
	printf ("Added variables to the list 0\n");
      fprintf (wf, "The varlist 0 after its first loading:\n");
      xx_fwrt (wf, 20, 0);
      printf ("Wrote varlist 0 on ./varlist.doc\n");
      namelist = xx_seekprefix (0, "E", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seekprefix(0,\"E\")\n");
      else
	{
	  fprintf (wf,
		   "List of the variables of the list 0 starting with the prefix \"E\":\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      fprintf (wf, "%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      namelist = xx_seekprefix (0, "", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seekprefix(0,\"\")\n");
      else
	{
	  fprintf (wf, "List of the variables of the list 0 :\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      fprintf (wf, "%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      namelist = xx_seeksuffix (0, "E", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seeksuffix(0,\"E\")\n");
      else
	{
	  fprintf (wf,
		   "List of the variables of the list 0 ending with the suffix \"E\":\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      fprintf (wf, "%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      namelist = xx_seeksuffix (0, "", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seeksuffix(0,\"\")\n");
      else
	{
	  fprintf (wf, "List of the variables of the list 0 :\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      fprintf (wf, "%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      printf ("We are going to delete the varlist 0...");
      xx_rmlistno (0);
      printf ("done\n");
      rewind (rf);
      if (xx_fload (rf, 0) == FAILURE)
	fprintf (stderr, "Cannot reload the varlist 0\n");
      else
	printf ("Varlist 0 reloaded\n");
      fprintf (wf, "The varlist 0 after its second loading:\n");
      xx_fwrt (wf, 20, 0);
      printf ("Wrote newly varlist 0 on ./varlist.doc\n");
      namelist = xx_seekprefix (0, "E", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seekprefix(0,\"E\")\n");
      else
	{
	  fprintf (wf,
		   "List of the variables of the list 0 starting with the prefix \"E\":\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      fprintf (wf, "%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      namelist = xx_seekprefix (0, "", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seekprefix(0,\"\")\n");
      else
	{
	  fprintf (wf, "List of the variables of the list 0 :\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      fprintf (wf, "%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      namelist = xx_seeksuffix (0, "E", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seeksuffix(0,\"E\")\n");
      else
	{
	  fprintf (wf,
		   "List of the variables of the list 0 ending with the suffix \"E\":\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      fprintf (wf, "%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      namelist = xx_seeksuffix (0, "", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seeksuffix(0,\"\")\n");
      else
	{
	  fprintf (wf, "List of the variables of the list 0 :\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      fprintf (wf, "%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      /* Now the list 1 */
      if (!xx_addvars (1, nlist, vlist))
	fprintf (stderr, "Cannot load variables inside the varlist 1\n");
      else
	printf ("Variables loaded inside the varlist 1\n");
      fprintf (wf, "The varlist 1 after its loading:\n");
      if (xx_fwrt (wf, 20, 1) == FAILURE)
	fprintf (stderr, "Cannot download any variable from varlist 1\n");
      else
	printf ("Wrote varlist 1 on ./varlist.doc\n");
      namelist = xx_seekprefix (1, "E", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seekprefix(1,\"E\")\n");
      else
	{
	  fprintf (wf,
		   "List of the variables of the list 1 starting with the prefix \"E\":\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      fprintf (wf, "%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      namelist = xx_seekprefix (1, "", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seekprefix(1,\"\")\n");
      else
	{
	  fprintf (wf, "List of the variables of the list 1 :\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      fprintf (wf, "%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      namelist = xx_seeksuffix (1, "X", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seeksuffix(1,\"X\")\n");
      else
	{
	  fprintf (wf,
		   "List of the variables of the list 1 ending with the suffix \"X\":\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      fprintf (wf, "%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      namelist = xx_seeksuffix (1, "", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seeksuffix(1,\"\")\n");
      else
	{
	  fprintf (wf, "List of the variables of the list 1 :\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      fprintf (wf, "%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      /* Now the list 2 (is empty !!!) */
      fprintf (wf, "The varlist 2 after its loading:\n");
      if (xx_fwrt (wf, 20, 2) == FAILURE)	/* An empty list !!! */
	fprintf (stderr, "Cannot download any variable from varlist 2\n");
      else
	printf ("Wrote varlist 2 on ./varlist.doc\n");
      namelist = xx_seekprefix (2, "A0", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seekprefix(2,\"A0\")\n");
      else
	{
	  fprintf (wf,
		   "List of the variables of the list 2 starting with the prefix \"A0\":\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      fprintf (wf, "%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      namelist = xx_seeksuffix (2, "0XX_", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seeksuffix(2,\"0XX_\")\n");
      else
	{
	  fprintf (wf,
		   "List of the variables of the list 2 ending with the suffix \"0XX\":\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      fprintf (wf, "%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      /* And now some inexistent lists. */
      if (!xx_addvars (3, nlist, vlist))
	fprintf (stderr, "Cannot load variables inside the varlist 3\n");
      else
	printf ("Variables loaded inside the varlist 3\n");
      if (xx_fwrt (wf, 20, 3) == FAILURE)
	fprintf (stderr, "Cannot download any variable from varlist 3\n");
      else
	printf ("Variables downloaded from the varlist 3\n");
      if (xx_fload (rf, 4) == FAILURE)
	fprintf (stderr, "Cannot load variables inside the varlist 4\n");
      else
	printf ("Variables loaded inside the varlist 4\n");
      if (xx_fbuild (rf, 5) == FAILURE)
	fprintf (stderr, "Cannot load variables inside the varlist 5\n");
      else
	printf ("Variables loaded inside the varlist 5\n");
      namelist = xx_seekprefix (3, "A0", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seekprefix(3,\"A0\")\n");
      else
	{
	  fprintf (wf,
		   "List of the variables of the list 3 starting with the prefix \"A0\":\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      fprintf (wf, "%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      namelist = xx_seeksuffix (3, "0XX_", &valuelist);
      if (!namelist)
	fprintf (stderr, "*** Error occurred in xx_seeksuffix(3,\"0XX_\")\n");
      else
	{
	  fprintf (wf,
		   "List of the variables of the list 3 ending with the suffix \"0XX\":\n");
	  for (i = 0; namelist[i] != NULL; i++)
	    {
	      fprintf (wf, "%s:\t", namelist[i]);
	      c_fwrt (wf, 1, 6, valuelist[i]);
	      fputc ('\n', wf);
	      free ((void *) namelist[i]);
	    }
	  free ((void *) namelist);
	  free ((void *) valuelist);
	}
      fclose (rf);
      fclose (wf);
      printf ("We are going to delete all varlists...");
      xx_rmlists ();
      printf ("done\n");
      printf ("Now we have %u list(s)\n", xx_gettnl ());
      printf ("We are going to delete all stacks...");
      xx_rmstacks ();
      printf ("done\n");
      printf ("Now we have %u stacks(s)\n", xx_gettns ());
      printf ("Program terminated, bye!\n");
    }
  return 0;
}
