/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include<stdio.h>
#include<string.h>
#include<xxcalc/compl.h>
#include<xxcalc/evaluate.h>

#define IFILE "./exprlist.txt"
#define OFILE "./results.txt"

int
main (void)
{
  char expr[200];
  c_omplex z;
  unsigned long counter;
  const char *names[] = {
    "X",
    "Y",
    "ZZ",
    NULL
  };
  c_omplex values[] = {
    {1, 0},
    {0, 1},
    {1, -1}
  };
  FILE *rf, *wf;

  printf ("This program is a test for the routines of libcalc\n");
  if (!(rf = fopen (IFILE, "r")))
    {
      fprintf (stderr, "Cannot open %s for reading\n\n", IFILE);
      return -1;
    }
  else if (!(wf = fopen (OFILE, "w")))
    {
      fprintf (stderr, "Cannot open %s for writing\n\n", OFILE);
      return -1;
    }
  else
    {
      xx_mkstacks (0);
      xx_mklists (0);
    }				/* Initialization terminated */
  if (!xx_addvars (0, names, values))
    {
      fprintf (stderr, "Cannot loading built-in variables :)\n\n");
      return -1;
    }
  else
    {
      counter = 0;
      while (!ferror (rf) && !feof (rf))
	{
	  fgets (expr, 200, rf);
	  if (expr[strlen (expr)] == '\n')
	    expr[strlen (expr)] = '\0';
	  if (expr[0] != '#')
	    z = xx_eval (expr, 0, 0, 1);
	  else
	    z = xx_eval (NULL, 0, 0, 1);
	  fprintf (wf, "[%lu]  %s\nResult=\t", ++counter, expr);
	  c_fwrt (wf, 1, 12, z);
	  fputc ('\n', wf);
	  fprintf (wf, "%s\n", xx_errmsg ());
	  fprintf (wf,
		   ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
	}
    }
  /* Closure's operations */
  xx_rmstacks ();
  xx_rmlists ();
  if (fclose (rf))
    {
      fprintf (stderr, "Cannot close %s\n\n", IFILE);
      return -1;
    }
  else if (fclose (wf))
    {
      fprintf (stderr, "Cannot close %s\n\n", OFILE);
      return -1;
    }
  else
    {
      printf ("Program terminated successfully, bye!\n\n");
      return 0;
    }
}
