/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* Functions not defined in compl.h */
#include<math.h>
#include"compl.h"      /* Warning: <stdio.h> is included by "compl.h" */

#if !defined(STOP_AT_ERROR)
extern int c_errno;
#else
#include<stdlib.h>
#endif

#ifdef DMALLOC
#include <dmalloc.h>
#endif

static r_eal
rround (r_eal x)
{
  if (x >= 0)
    {
      if (x - floor (x) <= 0.5)
	return floor (x);
      else
	return ceil (x);
    }
  else
    {
      if (x - floor (x) < 0.5)
	return floor (x);
      else
	return ceil (x);
    }
}

static r_eal
rtrunc (r_eal x)
{
  if (x >= 0)
    return floor (x);
  else
    return ceil (x);
}

static r_eal
rfrac (r_eal x)
{
  return x - rtrunc (x);
}

c_omplex
c_dms (c_omplex z)
{
  r_eal g, p, s;

#if !defined(STOP_AT_ERROR)
  c_errno = 0;
  if (z.im != 0)
    {
      c_errno = C_EDOM;
      return c_convert (0);
    }
#else
  if (z.im != 0)
    {
      fprintf (stderr, "\"%s\", %u: Out of domain(dms)\n\n", __FILE__,
	       __LINE__);
      exit (EXIT_FAILURE);
    }
#endif
  else
    {
      g = 360 * (rfrac (z.re / 360));
      if (g < 0)
	g += 360;
      p = rtrunc (60 * rfrac (g));
      s = 3600 * rfrac (g - p / 60);
      g = rtrunc (g);
      return c_convert (g + p / 100 + s / 10000);
    }
}

c_omplex
c_deg (c_omplex z)
{
  r_eal g, p, s;

#if !defined(STOP_AT_ERROR)
  c_errno = 0;
  if (z.im != 0)
    {
      c_errno = C_EDOM;
      return c_convert (0);
    }
#else
  if (z.im != 0)
    {
      fprintf (stderr, "\"%s\", %u: Out of domain(deg)\n\n", __FILE__,
	       __LINE__);
      exit (EXIT_FAILURE);
    }
#endif
  else
    {
      g = rtrunc (z.re);
      p = rround (100 * (z.re - g));
      s = 10000 * (z.re - g - p / 100);
      return c_convert (g + p / 60 + s / 3600);
    }
}

c_omplex
c_rtod (c_omplex z)
{
  return c_reset (z.re * 180 / MATH_PI, z.im * 180 / MATH_PI);
}

c_omplex
c_dtor (c_omplex z)
{
  return c_reset (z.re * MATH_PI / 180, z.im * MATH_PI / 180);
}

c_omplex
c_fact (c_omplex z)
{
  int i;
  r_eal p;

#if !defined(STOP_AT_ERROR)
  c_errno = 0;
  if (z.im != 0 || z.re < 0 || z.re > 170 || rfrac (z.re) > 0)
    {
      c_errno = C_EDOM;
      return c_convert (0);
    }
#else
  if (z.im != 0 || z.re < 0 || z.re > 170 || rfrac (z.re) > 0)
    {
      fprintf (stderr, "\"%s\", %u: Out of domain(fact)\n\n", __FILE__,
	       __LINE__);
      exit (EXIT_FAILURE);
    }
#endif
  else
    {
      for (p = 1.0, i = 2; i < rtrunc (z.re) + 0.1; p *= i++)
	;
      return c_convert (p);
    }
}
