/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _MATHTOK_H_
#define _MATHTOK_H_

#include"compl.h"

#ifdef __cplusplus
extern "C" {
#endif

#define XX_NUMBER   0		/* May also be a value stored in a variable */

#define XX_UNARYMINUS 9

#define XX_OPERATOR  10
#define XX_OPNUM     19
/* List of the macros which define the available operators */

#define XX_PL        10		/* + */
#define XX_MN        11		/* - */
#define XX_TM        12		/* * */
#define XX_DV        13		/* / */
#define XX_PC        14		/* % */
#define XX_MD        15		/* modulus */
#define XX_ID        16		/* integer division */
#define XX_PW        17		/* ^ == power */
#define XX_LT        18		/*  <  */
#define XX_GT        19		/*  >  */
#define XX_LE        20		/* <=  */
#define XX_GE        21		/* >=  */
#define XX_EQ        22		/* ==  */
#define XX_NE        23		/* !=  */
#define XX_AND       24		/* &&  */
#define XX_OR        25		/* ||  */
#define XX_XOR       26		/* ^^  */
#define XX_MIN_OP    27         /* ><  (minimum) */
#define XX_MAX_OP    28         /* <>  (maximum) */


#define XX_FUNCTION 100
#define XX_FUNCNUM   48
/* List of the macros which define the available functions */

#define XX_RE       100		/* re()    --> c_re()        */
#define XX_IM       101		/* im()    --> c_im()        */
#define XX_ABS      102		/* abs()   --> c_abs()       */
#define XX_ARG      103		/* arg()   --> c_arg()       */
#define XX_NEG      104		/* neg()   --> c_neg()       */
#define XX_CONJ     105		/* conj()  --> c_conj()      */
#define XX_INV      106		/* inv()   --> c_inv()       */
#define XX_SWAP     107         /* swap()  --> c_swap()      */
#define XX_SQR      108		/* sqr()   --> c_sqr()       */
#define XX_SQRT     109		/* sqrt()  --> c_sqrt()      */
#define XX_CBRT     110		/* cbrt()  --> c_root( ,0,3) */
#define XX_EXP      111		/* exp()   --> c_exp()       */
#define XX_EXP10    112		/* expx()  --> c_exp10()     */
#define XX_LOG      113		/* log()   --> c_log()       */
#define XX_LOG10    114		/* logx()  --> c_log10()     */
#define XX_SIN      115		/* sin()   --> c_sin()       */
#define XX_COS      116		/* cos()   --> c_cos()       */
#define XX_TAN      117		/* tan()   --> c_tan()       */
#define XX_ASIN     118		/* asin()  --> c_asin()      */
#define XX_ACOS     119		/* acos()  --> c_acos()      */
#define XX_ATAN     120		/* atan()  --> c_atan()      */
#define XX_SINH     121		/* sinh()  --> c_sinh()      */
#define XX_COSH     122		/* cosh()  --> c_cosh()      */
#define XX_TANH     123		/* tanh()  --> c_tanh()      */
#define XX_ASINH    124		/* asinh() --> c_asinh()     */
#define XX_ACOSH    125		/* acosh() --> c_acosh()     */
#define XX_ATANH    126		/* atanh() --> c_atanh()     */
#define XX_FLOOR    127		/* floor() --> c_floor()     */
#define XX_CEIL     128		/* ceil()  --> c_ceil()      */
#define XX_ROUND    129		/* round() --> c_round()     */
#define XX_FIX      130		/* fix()   --> c_fix()       */
#define XX_FRAC     131         /* frac()  --> c_frac()      */
#define XX_CHCC     132         /* Xcc()  --> c_chcc()       */
#define XX_CHCO     133         /* Xco()  --> c_chco()       */
#define XX_CHOC     134         /* Xoc()  --> c_choc()       */
#define XX_CHOO     135         /* Xoo()  --> c_choo()       */
#define XX_CHLC     136         /* Xlc()  --> c_chlc()       */
#define XX_CHLO     137         /* Xlo()  --> c_chlo()       */
#define XX_CHRC     138         /* Xrc()  --> c_chrc()       */
#define XX_CHRO     139         /* Xro()  --> c_chro()       */
#define XX_STEP     140         /* step()  --> c_chrc()      */ 
#define XX_ERF      141         /* erf()   --> c_erf()       */
#define XX_ERFC     142         /* erfc()  --> c_erfc()      */
/* Special functions, not defined in compl.c */
#define XX_DMS      143		/* dms()  */
#define XX_DEG      144		/* deg()  */
#define XX_RTOD     145		/* rtod() */
#define XX_DTOR     146		/* dtor() */
#define XX_FACT     147		/* fact() */

/* Parentheses */
#define XX_OPEN_PAR   200
#define XX_CLOSE_PAR  201

/* 2 special macros */
#define XX_UNDEFINED 254
#define XX_NULLTOK   255

#define xx_isop(type) ((type)>= XX_OPERATOR && (type) < XX_OPERATOR+XX_OPNUM ? 1:0)
#define xx_isfn(type) ((type)>= XX_FUNCTION && (type) < XX_FUNCTION+XX_FUNCNUM ? 1:0)

/* Highest possible size for an expanded varname. */
/* If you change this value, mind to update also  */
/* the definition of FMTSTR_FOR_VAR (see below).  */ 
#define XX_MAX_VNSIZE 13

/* Highest possible size for a varname            */	
#define XX_MAX_NDIM   42U

/* 
   XX_FMTSTR_FOR_VAR is the format string that should be passed
   to a function of the *scanf() family whenever a variable  
   should be read. The number in the format string must be 
   equal to MAX_VNSIZE - 1.               
   Thus, it must be changed if the value of XX_MAX_VNSIZE is modified.
   XX_FMTSTR_FOR_VAR is currently used by the functions xx_fload() 
   anf xx_fbuild() in evaluate.c .     
*/
#ifdef  USE_LONG_DOUBLE
#define XX_FMTSTR_FOR_VAR  "%12s %Lf %Lf"
#else
#define XX_FMTSTR_FOR_VAR  "%12s %lf %lf"
#endif

typedef struct
{
  b_yte type;			/* May be one of the constant defined before */
  long pr;			/* Priority level, -1 for numbers */
  c_omplex value;		/* value of a number or variable  */
  char name[XX_MAX_NDIM];	/* Name (used only for variables) */
}
xx_mathtoken;

/* Modified on Oct 31, 2003 to avoid too many calls to malloc() */
/* within parser.c                                              */
/* b_yte xx_toktype (const char *name);                         */
b_yte xx_toktype (const char *name, str_s_ize length);

#ifdef __cplusplus
}
#endif
#endif /* _MATHTOK_H_ */
