/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef IOCTYPE_H
#define IOCTYPE_H

#ifdef __cplusplus
extern "C" {
#endif

#if ('0' < '9')\
&&  ('0' + 1 == '1') && ('1' + 1 == '2') && ('2' + 1 == '3')\
&&  ('3' + 1 == '4') && ('4' + 1 == '5') && ('5' + 1 == '6')\
&&  ('6' + 1 == '7') && ('7' + 1 == '8') && ('8' + 1 == '9')
#define CONSEC_DIGITS 1
#else 
#define CONSEC_DIGITS 0
#endif

#if ('a' < 'z')\
&&  ('a' + 1 == 'b') && ('b' + 1 == 'c') && ('c' + 1 == 'd')\
&&  ('d' + 1 == 'e') && ('e' + 1 == 'f') && ('f' + 1 == 'g')\
&&  ('g' + 1 == 'h') && ('h' + 1 == 'i') && ('i' + 1 == 'j')\
&&  ('j' + 1 == 'k') && ('k' + 1 == 'l') && ('l' + 1 == 'm')\
&&  ('m' + 1 == 'n') && ('n' + 1 == 'o') && ('o' + 1 == 'p')\
&&  ('p' + 1 == 'q') && ('q' + 1 == 'r') && ('r' + 1 == 's')\
&&  ('s' + 1 == 't') && ('t' + 1 == 'u') && ('u' + 1 == 'v')\
&&  ('v' + 1 == 'w') && ('w' + 1 == 'x') && ('x' + 1 == 'y') && ('y' + 1 == 'z')
#define CONSEC_LOWER_LETTERS 1
#else 
#define CONSEC_LOWER_LETTERS 0
#endif

#if ('A' < 'Z')\
&&  ('A' + 1 == 'B') && ('B' + 1 == 'C') && ('C' + 1 == 'D')\
&&  ('D' + 1 == 'E') && ('E' + 1 == 'F') && ('F' + 1 == 'G')\
&&  ('G' + 1 == 'H') && ('H' + 1 == 'I') && ('I' + 1 == 'J')\
&&  ('J' + 1 == 'K') && ('K' + 1 == 'L') && ('L' + 1 == 'M')\
&&  ('M' + 1 == 'N') && ('N' + 1 == 'O') && ('O' + 1 == 'P')\
&&  ('P' + 1 == 'Q') && ('Q' + 1 == 'R') && ('R' + 1 == 'S')\
&&  ('S' + 1 == 'T') && ('T' + 1 == 'U') && ('U' + 1 == 'V')\
&&  ('V' + 1 == 'W') && ('W' + 1 == 'X') && ('X' + 1 == 'Y') && ('Y' + 1 == 'Z')
#define CONSEC_UPPER_LETTERS 1
#else 
#define CONSEC_UPPER_LETTERS 0
#endif

/*
  The ASCII table (from the 'ascii' man page).

       Oct   Dec   Hex   Char           Oct   Dec   Hex   Char
       ------------------------------------------------------------
       000   0     00    NUL '\0'       100      40    @
       001   1     01    SOH            101      41    A
       002   2     02    STX            102      42    B
       003   3     03    ETX            103      43    C
       004   4     04    EOT            104      44    D
       005   5     05    ENQ            105      45    E
       006   6     06    ACK            106      46    F
       007   7     07    BEL '\a'       107      47    G
       010   8     08    BS  '\b'       110      48    H
       011   9     09    HT  '\t'       111      49    I
       012   10    0A    LF  '\n'       112      4A    J
       013   11    0B    VT  '\v'       113      4B    K
       014   12    0C    FF  '\f'       114      4C    L
       015   13    0D    CR  '\r'       115      4D    M
       016   14    0E    SO             116      4E    N
       017   15    0F    SI             117      4F    O
       020   16    10    DLE            120      50    P
       021   17    11    DC1            121      51    Q
       022   18    12    DC2            122      52    R
       023   19    13    DC3            123      53    S
       024   20    14    DC4            124      54    T
       025   21    15    NAK            125      55    U
       026   22    16    SYN            126      56    V
       027   23    17    ETB            127      57    W
       030   24    18    CAN            130      58    X
       031   25    19    EM             131      59    Y
       032   26    1A    SUB            132      5A    Z
       033   27    1B    ESC            133      5B    [
       034   28    1C    FS             134      5C    \   '\\'
       035   29    1D    GS             135      5D    ]
       036   30    1E    RS             136      5E    ^
       037   31    1F    US             137      5F    _
       040   32    20    SPACE          140      60    `
       041   33    21    !              141      61    a
       042   34    22    "              142      62    b
       043   35    23    #              143      63    c
       044   36    24    $              144      64    d
       045   37    25    %              145      65    e
       046   38    26    &              146      66    f
       047   39    27    '              147      67    g
       050   40    28    (              150      68    h
       051   41    29    )              151      69    i
       052   42    2A    *              152      6A    j
       053   43    2B    +              153      6B    k
	       				       	  	   
       054   44    2C    ,              154      6C    l
       055   45    2D    -              155      6D    m
       056   46    2E    .              156      6E    n
       057   47    2F    /              157      6F    o
       060   48    30    0              160      70    p
       061   49    31    1              161      71    q
       062   50    32    2              162      72    r
       063   51    33    3              163      73    s
       064   52    34    4              164      74    t
       065   53    35    5              165      75    u
       066   54    36    6              166      76    v
       067   55    37    7              167      77    w
       070   56    38    8              170      78    x
       071   57    39    9              171      79    y
       072   58    3A    :              172      7A    z
       073   59    3B    ;              173      7B    {
       074   60    3C    <              174      7C    |
       075   61    3D    =              175      7D    }
       076   62    3E    >              176      7E    ~
       077   63    3F    ?              177      7F    DEL
*/

#if (' ' == 32) && ('!' == 33) && ('"' == 34) && ('#' == 35)\
&&  ('$' == 36) && ('%' == 37) && ('&' == 38) && ('\'' == 39)\
&&  ('(' == 40) && (')' == 41) && ('*' == 42) && ('+' == 43)\
&&  (',' == 44) && ('-' == 45) && ('.' == 46) && ('/' == 47)\
&&  ('0' == 48) && ('1' == 49) && ('2' == 50) && ('3' == 51)\
&&  ('4' == 52) && ('5' == 53) && ('6' == 54) && ('7' == 55)\
&&  ('8' == 56) && ('9' == 57) && (':' == 58) && (';' == 59)\
&&  ('<' == 60) && ('=' == 61) && ('>' == 62) && ('?' == 63)\
&&  ('@' == 64) && ('A' == 65) && ('B' == 66) && ('C' == 67)\
&&  ('D' == 68) && ('E' == 69) && ('F' == 70) && ('G' == 71)\
&&  ('H' == 72) && ('I' == 73) && ('J' == 74) && ('K' == 75)\
&&  ('L' == 76) && ('M' == 77) && ('N' == 78) && ('O' == 79)\
&&  ('P' == 80) && ('Q' == 81) && ('R' == 82) && ('S' == 83)\
&&  ('T' == 84) && ('U' == 85) && ('V' == 86) && ('W' == 87)\
&&  ('X' == 88) && ('Y' == 89) && ('Z' == 90) && ('[' == 91)\
&&  ('\\' == 92) && (']' == 93) && ('^' == 94) && ('_' == 95)\
&&  ('`' == 96) && ('a' == 97) && ('b' == 98) && ('c' == 99)\
&&  ('d' == 100) && ('e' == 101) && ('f' == 102) && ('g' == 103)\
&&  ('h' == 104) && ('i' == 105) && ('j' == 106) && ('k' == 107)\
&&  ('l' == 108) && ('m' == 109) && ('n' == 110) && ('o' == 111)\
&&  ('p' == 112) && ('q' == 113) && ('r' == 114) && ('s' == 115)\
&&  ('t' == 116) && ('u' == 117) && ('v' == 118) && ('w' == 119)\
&&  ('x' == 120) && ('y' == 121) && ('z' == 122) && ('{' == 123)\
&&  ('|' == 124) && ('}' == 125) && ('~' == 126)
#define CHARSET_IS_ASCII 1
#else
#define CHARSET_IS_ASCII 0
#endif

int io_islower (int ch);
int io_isupper (int ch);
int io_isdigit (int ch);
int io_isxdigit(int ch);
int io_isalpha (int ch);
int io_isalnum (int ch);
int io_isspace (int ch);
int io_isblank (int ch);
int io_isprint (int ch);
int io_isgraph (int ch);
int io_iscntrl (int ch);
int io_ispunct (int ch);
int io_tolower (int ch);
int io_toupper (int ch);

#ifdef __cplusplus
}
#endif

#endif /* IOCTYPE_H */
