/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _EVALUATE_H_
#define _EVALUATE_H_

#include"compl.h"
#include"varlist.h"
#include"tokstack.h"
#include"parser.h"

#ifdef __cplusplus
extern "C" {
#endif

void        xx_clearerr(void);
int         xx_errno   (void);
const char *xx_errmsg  (void);
void        xx_perror  (void);
const char *xx_strerror(int n);

void xx_setscale (int scale);
int  xx_getscale (void);
int  xx_defscale (void);
int  xx_maxscale (void);

#define XX_MAX_NUM_STACKS   100
#define XX_DEF_NUM_STACKS    10

int      xx_mkstacks (unsigned how_much);
int      xx_addnewstack (void);
unsigned xx_gettns (void);
void     xx_rmstackno (unsigned which_stack);
void     xx_rmstacks (void);
char**   xx_findvars (unsigned which_stack, ui_nteger* number_of_vars);

#define XX_MAX_NUM_LISTS   12
#define XX_DEF_NUM_LISTS    1
#define XX_MAX_VLLENGTH  10240

int       xx_validname  (const char *name);
i_nteger  xx_validnames (const char **namelist);
int       xx_mklists    (unsigned how_much);
int       xx_addnewlist (void);
unsigned  xx_gettnl     (void);
int       xx_fload  (FILE * rf, unsigned which_list);
int       xx_fbuild (FILE * rf, unsigned which_list);
int       xx_fwrt   (FILE * wf, int prec, unsigned which_list);
int       xx_is_list_empty (unsigned which_list);
ui_nteger xx_getll  (unsigned which_list);
i_nteger  xx_getpos (unsigned which_list, const char* name, 
		     i_nteger from, i_nteger to);
i_nteger  xx_getpointer (unsigned which_list, const char* name);
c_omplex  xx_getvar   (unsigned which_list, const char *name, int *isdef);
c_omplex *xx_getvars (unsigned from, const char **namelist);
const char* xx_at    (unsigned which_list, ui_nteger pos, c_omplex *value);
int      xx_readlist (unsigned which_list, char ***varname, c_omplex ** value);
void     xx_getrange (unsigned which_list, const char* prefix, i_nteger* from,
		      i_nteger* to);
char **xx_seekprefix (unsigned where, const char *prefix, c_omplex ** value);
char **xx_seeksuffix (unsigned where, const char *suffix, c_omplex ** value);
int  xx_mergevl (unsigned to, unsigned from);
int  xx_dupvl   (unsigned dest, unsigned src);
int  xx_copyvars(unsigned to, unsigned from, ui_nteger first, ui_nteger last);
int  xx_assign  (unsigned which_list, ui_nteger pos, c_omplex z);
int  xx_setvar  (unsigned where, const char *name, c_omplex z);
int  xx_setvars (unsigned where, const char **namelist, const c_omplex * z);
int  xx_addvar  (unsigned where, const char *name, c_omplex z);
int  xx_addvars (unsigned which_list, const char **name,
		 const c_omplex * value);
int  xx_rebuild (unsigned which_list, const char **name,
		 const c_omplex * value);
int  xx_rmvar   (unsigned where, const char *name);
int  xx_rmvars  (unsigned where, const char **namelist);
void xx_rmlistno(unsigned which_list);
void xx_rmlists (void);

c_omplex    xx_comp  (const char *expr, unsigned which_stack,
		      unsigned which_list, const char *vname, int hp);

const char *xx_split (const char *expr, const char **rightp);

c_omplex    xx_eval  (const char *expr, unsigned which_stack,
		      unsigned which_list, int hp);

#ifdef __cplusplus
}
#endif
#endif /* _EVALUATE_H_ */
