/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _COMPL_H_
#define _COMPL_H_

#include<stdio.h>
#include<float.h>
#include"numtypes.h"

#ifdef __cplusplus
extern "C" {
#endif

/* #ifdef USE_LONG_DOUBLE */
/* #define EPS  1.0e-24 */
/* #else */
/* #define EPS  1.0e-18 */
/* #endif */

#ifdef USE_LONG_DOUBLE
#define EPS  LDBL_MIN
#else
#define EPS  DBL_MIN
#endif

typedef struct
{
  r_eal re, im;
}
c_omplex;

typedef struct
{
  i_nteger re, im;
}
gauss_int;

#ifndef STOP_AT_ERROR
#define C_EDIV    1
#define C_EDOM    2
#define C_EBADEXP 3
#define C_ECVRES  4

const char *strc_error (int errnum);
void pc_error (const char *s);
#endif

c_omplex c_reset (r_eal re, r_eal im);	
c_omplex c_convert (r_eal x);	        
c_omplex c_init (void);		        
gauss_int gi_reset (i_nteger re, i_nteger im);
gauss_int gi_convert (i_nteger n);
gauss_int gi_init (void);
c_omplex c_fromgi (gauss_int w);
gauss_int gi_fromc (c_omplex z);

r_eal c_re (c_omplex z);		        
r_eal c_im (c_omplex z);		        
r_eal c_abs (c_omplex z);		
r_eal c_arg (c_omplex z);		

c_omplex c_sum (c_omplex z1, c_omplex z2);	
c_omplex c_diff (c_omplex z1, c_omplex z2);	
c_omplex c_prod (c_omplex z1, c_omplex z2);	
c_omplex c_div (c_omplex z1, c_omplex z2);	
c_omplex c_idiv (c_omplex z1, c_omplex z2);	
c_omplex c_idiv_ (c_omplex z1, c_omplex z2);
c_omplex c_mod (c_omplex z1, c_omplex z2);	
c_omplex c_mod_ (c_omplex z1, c_omplex z2);
c_omplex c_ipow (c_omplex z, i_nteger n);	
c_omplex c_sqr (c_omplex z);		        
c_omplex c_pow (c_omplex z1, c_omplex z2);	
c_omplex c_root (c_omplex z, i_nteger i, i_nteger n);	
c_omplex c_sqrt (c_omplex z);		

i_nteger c_is0 (c_omplex z);	                
i_nteger c_not0 (c_omplex z);	                
i_nteger c_eq (c_omplex z1, c_omplex z2);	
i_nteger c_neq (c_omplex z1, c_omplex z2);	
i_nteger c_gt (c_omplex z1, c_omplex z2);	
i_nteger c_ge (c_omplex z1, c_omplex z2);	
i_nteger c_lt (c_omplex z1, c_omplex z2);	
i_nteger c_le (c_omplex z1, c_omplex z2);	

c_omplex c_neg (c_omplex z);		
c_omplex c_conj (c_omplex z);		
c_omplex c_inv (c_omplex z);		
c_omplex c_swap (c_omplex z);           

c_omplex c_exp (c_omplex z);		
c_omplex c_exp10 (c_omplex z);	        
c_omplex c_log (c_omplex z);
c_omplex c_log10 (c_omplex z);
c_omplex c_sin (c_omplex z);
c_omplex c_cos (c_omplex z);
c_omplex c_tan (c_omplex z);
c_omplex c_sinh (c_omplex z);
c_omplex c_cosh (c_omplex z);
c_omplex c_tanh (c_omplex z);
c_omplex c_asin (c_omplex z);
c_omplex c_acos (c_omplex z);
c_omplex c_atan (c_omplex z);
c_omplex c_asinh (c_omplex z);
c_omplex c_acosh (c_omplex z);
c_omplex c_atanh (c_omplex z);

c_omplex c_floor (c_omplex z);
c_omplex c_ceil (c_omplex z);
c_omplex c_round (c_omplex z);
c_omplex c_fix (c_omplex z);
c_omplex c_frac (c_omplex z);
c_omplex c_chcc (c_omplex z); 
c_omplex c_chco (c_omplex z); 
c_omplex c_choc (c_omplex z); 
c_omplex c_choo (c_omplex z); 
c_omplex c_chlc (c_omplex z); 
c_omplex c_chlo (c_omplex z); 
c_omplex c_chrc (c_omplex z); 
c_omplex c_chro (c_omplex z); 
c_omplex c_erf (c_omplex z);
c_omplex c_erfc (c_omplex z);

/* Input and output functions plus related macro's definitions */
#define C_FMT_NOCHANGE -1
#define C_FMT_SIMPLE    0
#define C_FMT_STD       1
#define C_FMT_NICE      2

#define C_OUT_FIXED      0
#define C_OUT_SCIENTIFIC 1

int  c_setoutflags (int  fmt, int  notat, int  sf, int  wd, int  pr);
void c_getoutflags (int* fmt, int* notat, int *sf, int *wd, int *pr);
/* First type of output functions */
int r_fprint (FILE * pf, r_eal x);
int c_fprint (FILE * pf, c_omplex z);
int r_print (r_eal x);
int c_print (c_omplex z);
int r_sprint (char *s, str_s_ize n, r_eal x);
int c_sprint (char *s, str_s_ize n, c_omplex z);
/* Second type of output functions */
int c_fwrt (FILE * pf, int stdfmt, int prec, c_omplex z);
int c_wrt (int stdfmt, int prec, c_omplex z);
int c_swrt (char *s, str_s_ize n, int stdfmt, int prec, c_omplex z);
/* Input functions */
int c_fscan (FILE * pf, c_omplex * p);
int c_scan (c_omplex * p);
int c_sscan (const char* s, c_omplex * p);

#ifdef __cplusplus
}
#endif
#endif
