/*
    GTKmathplot - a simple GTK+ based program
    to plot mathematical functions.
    Copyright (C) 2012, 2013  Ivano Primi  <ivprimi@libero.it>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __CONTROLS__
#define __CONTROLS__

#include<glib.h>
#include"gr.h"
#include"gr2d.h"
#include"gr3d.h"
#include"par2d.h"
#include"par3d.h"
#include"utils.h"

#define FORMAT_STRING_DBL      "%+.12G"
#define FORMAT_STRING_UINT     "%lu"
#define FORMAT_STRING_INT      "%d"
#define CONV_FACTOR_D2R        (3.14159265358979323846/180)
#define NUMBER_OF_2DOBJECTS    10  /* If you change it, do not forget to adjust RGB_*_2D in cairo_driver.h */
#define NUMBER_OF_3DOBJECTS     5  /* If you change it, do not forget to adjust RGB_*_3D in cairo_driver.h */
#define MAX_NUMBER_OF_OBJECTS  (NUMBER_OF_2DOBJECTS > NUMBER_OF_3DOBJECTS ? NUMBER_OF_2DOBJECTS : NUMBER_OF_3DOBJECTS)

#define EVAL_TMP              0
#define X_EVAL_TMP            1 + 2*NUMBER_OF_2DOBJECTS+3*NUMBER_OF_3DOBJECTS
#define Y_EVAL_TMP            2 + 2*NUMBER_OF_2DOBJECTS+3*NUMBER_OF_3DOBJECTS
#define Z_EVAL_TMP            3 + 2*NUMBER_OF_2DOBJECTS+3*NUMBER_OF_3DOBJECTS

#define X_COLOR               100
#define Y_COLOR               101
#define Z_COLOR               102
#define GRID_COLOR            103
#define XYPLANE_GRID_COLOR    104
#define XZPLANE_GRID_COLOR    105
#define YZPLANE_GRID_COLOR    106
#define TICS_COLOR            107
#define DEFAULT_CURRENT_OBJECT  0
#define DEFAULT_STYLE          GRSTYLE_STROKED
#define DEFAULT_ORIGIN_2D      (gr2d_point){0.0, 0.0}
#define DEFAULT_ORIGIN_3D      (gr3d_point){0.0, 0.0, 0.0}
#define DEFAULT_LONGITUDE      45.0
#define DEFAULT_LATITUDE       45.0
#define DUMMY_LONGITUDE       270.0
#define DUMMY_LATITUDE         90.0
#define DEFAULT_ROTATION_ANGLE  0.0
#define DEFAULT_ZOOM          100.0  /* 100% */
#define DEFAULT_SMOKE_DENSITY   0.5
#define DEFAULT_SHOW_MAIN_DIRS  0
#define DEFAULT_SHOW_GRID       0
#define DEFAULT_SHOW_TICS       0
#define DEFAULT_SHOW_DISC       0
#define DEFAULT_R               0.0
#define DEFAULT_R_MAG_FACTOR    1.25
#define DEFAULT_GRID_STEP       0.0
#define MIN_EXP               -50
#define MAX_EXP               +50
#define DEFAULT_SIDE           480
#define DEFAULT_LBORDER         70
#define DEFAULT_RBORDER         20
#define DEFAULT_TBORDER         40
#define DEFAULT_BBORDER         40
#define DEFAULT_HEIGHT       (DEFAULT_SIDE + DEFAULT_TBORDER + DEFAULT_BBORDER)
#define DEFAULT_WIDTH        (DEFAULT_SIDE + DEFAULT_LBORDER + DEFAULT_RBORDER)

#define DEFAULT_DIVISOR_2D       5.0
#define DEFAULT_DIVISOR_3D       5.0
#define DEFAULT_TIC_DIVISOR      3
#define DEFAULT_YTIC_DIVISOR     6
#define DEFAULT_NSTEPS         200
#define DEFAULT_NSTEPS_ST       50
#define DEFAULT_INF             0.0
#define DEFAULT_SUP             0.0
#define TRUNC_FACTOR           16.0
#define DISC_FACTOR             4.0

#define LABEL_SIZE              25
#define STRING_FMT_TICS     "%+.3G"
#define STRING_FMT_X   "x0 = %+.3G"
#define STRING_FMT_Y   "y0 = %+.3G"
#define STRING_FMT_Z   "z0 = %+.3G"
#define STRING_FMT_G   "grid step = %+.3G" 

typedef enum {
  CARTESIAN = 1,
  PARAMETRIC = 2
} repr_type;

typedef enum {
  WRONG_UPDATE = -1,
  UP_TO_DATE = 0,
  TO_UPDATE = 1
} update_flag;

typedef struct {
  grmathtype type;
  const char *x_eq, *y_eq, *z_eq;
  const char *inf_s, *sup_s, *inf_t, *sup_t;
  const char *nsteps_s, *nsteps_t, *caption; 
  grstyle style;
} mathobj_description;

#define DEFAULT_GRAPHIC_MODE GRAPHIC_2D
#define DEFAULT_REPR_TYPE CARTESIAN
#define DEFAULT_UPDATE_FLAG UP_TO_DATE

void init_internal_structs (void);
void reset_internal_structs (void);

void set_graphic_mode (graphic_mode gm);
graphic_mode get_graphic_mode (void);

void set_current_object (int id);
int get_current_object (void);
int* get_free_ids (graphic_mode for_which_graphic_mode);

/* Return NULL in case of memory exhaustion */
gchar* get_formatted_captions (void);

grexitstatus define_math_object (const char* x_eq, const char* y_eq,
				 const char* z_eq,
				 const char* inf_s, const char* sup_s, 
				 const char* nsteps_s,
				 const char* inf_t, const char* sup_t, 
				 const char* nsteps_t,
				 grstyle style, const char* caption,
				 int cartesian_mode_is_active);
mathobj_description get_description_2dmath_object (const par2d_object* p2d);
mathobj_description get_description_3dmath_object (const par3d_object* p3d);
mathobj_description retrieve_math_object (void);

grexitstatus upgrade_pipeline (void);
double get_half_side_of_the_draw (void);

void set_longitude_and_update (double longitude);
double get_longitude (void);
void set_latitude_and_update (double latitude);
double get_latitude (void);
void set_rotation_angle_and_update (double rotation_angle);
double get_rotation_angle (void);
void translate_origin_and_update (grint dx, grint dy, grint dz);
void reset_origin_position_and_update (void);
void retrieve_origin_position (double* ox, double* oy, double* oz);
double get_grid_step (void);

void toggle_show_main_directions (int boolean_value);
int get_show_main_directions (void);
void toggle_show_grid (int boolean_value);
int get_show_grid (void);
void toggle_show_tics (int boolean_value);
int get_show_tics (void);
void toggle_show_discontinuities (int boolean_value);
int get_show_discontinuities (void);
void set_zoom_factor (double zoom);
double get_zoom_factor (void);
void set_smoke_density (double smoke_density);
double get_smoke_density (void);
grexitstatus save_pipeline (const char* filepath);
const char* mgr_filename (const char* new_filepath);
grexitstatus load_into_pipeline (const char* filepath, int file_in_native_format);

const gr2d_object* get_pointer_to_2dpipeline (void);
const gr3d_object* get_pointer_to_3dpipeline (void);
char* get_formatted_equations (print_specs settings, cursor_position* start_position, int first_equation, int* until_equation);

#endif /* __CONTROLS__ */

