/*
    GTKmathplot - a simple GTK+ based program
    to plot mathematical functions.
    Copyright (C) 2012, 2013  Ivano Primi  <ivprimi@libero.it>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __CALLBACKS__
#define __CALLBACKS__

#include<gtk/gtk.h>
#include"gr.h"

typedef struct {
  GtkWidget *notebook;
  GtkWidget *cart_radiob, *param_radiob;
  GtkWidget *x_hbox, *y_hbox, *z_hbox;
  GtkWidget *x_entry, *y_entry, *z_entry;
  GtkWidget *y_label, *z_label;
  GtkWidget *s_frame, *t_frame;
  GtkWidget *inf_s_entry, *sup_s_entry, *nsteps_s_entry;  
  GtkWidget *inf_t_entry, *sup_t_entry, *nsteps_t_entry;  
  GtkWidget *caption_entry;
  grstyle style;
  GtkWidget *dotted_radiob, *stroked_radiob, *filled_radiob;
  GtkWidget *selection_combo_box;

  GtkWidget *long_spinb, *lat_spinb, *rotangle_spinb;
  GtkWidget *zoom_hscale, *smoke_hscale;
  GtkWidget *axes_checkb, *grid_checkb, *tics_checkb, *jumps_checkb;
  GtkWidget *zimage_up_button, *zimage_down_button;
  GtkWidget *draw_area;
} pointers_to_fields;

gboolean on_close (GtkWidget* wd, GdkEvent* ev, gpointer user_data);
void on_display (GtkWidget* wd, gpointer user_data);
void on_back_input_mask (GtkWidget* wd, gpointer user_data);

void on_set_2dmode (GtkWidget* wd, gpointer user_data);
void on_set_3dmode (GtkWidget* wd, gpointer user_data);
void on_changed_selection (GtkWidget* wd, gpointer user_data);
void on_set_cartesian (GtkWidget* wd, gpointer user_data);
void on_set_parametric (GtkWidget* wd, gpointer user_data);
void on_set_dotted_style (GtkWidget* wd, gpointer user_data);
void on_set_stroked_style (GtkWidget* wd, gpointer user_data);
void on_set_filled_style (GtkWidget* wd, gpointer user_data);

void on_load_definition (GtkWidget* wd, gpointer user_data);
void on_save_definition (GtkWidget* wd, gpointer user_data);
void on_clear_definition (GtkWidget* wd, gpointer user_data);

void on_save_evaluation (GtkWidget* wd, gpointer user_data);

gint on_draw (GtkWidget* wd, GdkEventExpose* ev, gpointer user_data);
void on_load_image (GtkWidget* wd, gpointer user_data);
void on_save_image (GtkWidget* wd, gpointer user_data);
void on_set_longitude (GtkWidget* wd, gpointer user_data);
void on_set_latitude (GtkWidget* wd, gpointer user_data);
void on_set_rotation_angle (GtkWidget* wd, gpointer user_data);
void on_toggle_show_main_dirs (GtkWidget* wd, gpointer user_data);
void on_toggle_show_grid (GtkWidget* wd, gpointer user_data);
void on_toggle_show_tics (GtkWidget* wd, gpointer user_data);
void on_toggle_show_discontinuities (GtkWidget* wd, gpointer user_data);
void on_set_zoom_factor (GtkWidget* wd, gpointer user_data);
void on_set_smoke_density (GtkWidget* wd, gpointer user_data);
void on_ximage_up (GtkWidget* wd, GdkEventButton* ev, gpointer user_data);
void on_ximage_down (GtkWidget* wd, GdkEventButton* ev, gpointer user_data);
void on_yimage_up (GtkWidget* wd, GdkEventButton* ev, gpointer user_data);
void on_yimage_down (GtkWidget* wd, GdkEventButton* ev, gpointer user_data);
void on_zimage_up (GtkWidget* wd, GdkEventButton* ev, gpointer user_data);
void on_zimage_down (GtkWidget* wd, GdkEventButton* ev, gpointer user_data);
void on_reset_imagepos (GtkWidget* wd, gpointer user_data);

void on_toggle_print_addinfo (GtkWidget* wd, gpointer user_data);
void on_toggle_print_disclaimer (GtkWidget* wd, gpointer user_data);
void on_set_paper_format (GtkWidget* wd, gpointer user_data);
void on_set_orientation (GtkWidget* wd, gpointer user_data);
void on_set_color_2d (GtkWidget* wd, gpointer user_data);
void on_set_color_3d (GtkWidget* wd, gpointer user_data);
void on_set_symbol_2d (GtkWidget* wd, gpointer user_data);
void on_set_symbol_3d (GtkWidget* wd, gpointer user_data);
 
#endif /* __CALLBACKS__ */
