/*
    GTKmathplot - a simple GTK+ based program
    to plot mathematical functions.
    Copyright (C) 2012, 2013  Ivano Primi  <ivprimi@libero.it>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __CAIRO_DRIVER__
#define __CAIRO_DRIVER__

#include<gtk/gtk.h>
#include"controls.h"

#define DEFAULT_PAPER_FORMAT A4
#define DEFAULT_ORIENTATION  Portrait

typedef struct {
  GtkWidget* wd;
  gchar* ps;
  gchar* pdf;
  gchar* svg;
} cairo_initializer;

typedef struct {
  const gchar* name;
  double w, h;
} cairo_paper_format_prop;

typedef enum {
  A3 = 0,
  A4,
  Letter,
  Legal,
  NSUPPORTED_PAPER_FORMATS
} cairo_paper_format;

typedef enum {
  Portrait = 0,
  Landscape,
  NSUPPORTED_ORIENTATIONS
} cairo_orientation;

typedef enum {
  Black = 0,
  Dark_Red,
  Nigth_Blue,
  Frog_Green, 
  Dark_Cyan,  
  Dark_Violet,
  Vermilion,     
  Cream,      
  Light_Blue, 
  Lilla,
  Grass_Green, 
  Dark_Gray,   
  Black_Smoke,
  Nr_Colors_2d
} cairo_color_2d;

#define RGB_0_2D {0.0, 0.0, 0.0} /* Black         */
#define RGB_1_2D {0.7, 0.1, 0.1} /* Dark Red      */
#define RGB_2_2D {0.0, 0.0, 0.8} /* Nigth blue    */
#define RGB_3_2D {0.0, 0.9, 0.0} /* Frog green    */
#define RGB_4_2D {0.0, 0.6, 0.6} /* Dark Cyan     */
#define RGB_5_2D {0.6, 0.0, 0.5} /* Dark Violet   */
#define RGB_6_2D {1.0, 0.4, 0.0} /* Vermilion     */
#define RGB_7_2D {0.88, 0.79, 0.44} /* Cream        */
#define RGB_8_2D {0.4, 0.9, 0.9}    /* Light blue   */
#define RGB_9_2D {0.8, 0.4, 0.8}    /* Lilla        */
#define RGB_10_2D {0.0, 0.75, 0.5}  /* Grass green  */
#define RGB_11_2D {0.3, 0.3, 0.3}   /* Dark Gray    */
#define RGB_12_2D {0.1, 0.1, 0.1}   /* Black Smoke  */

typedef enum {
  Red = 0,
  Sea_Green,     
  Violet,
  Orange,
  Pompei_Red, 
  Green,
  Cyan,       
  Blue,       
  Gray,       
  Bluish,
  Cyanish, 
  Greenish,
  Almost_Black,
  Nr_Colors_3d
} cairo_color_3d;

#define RGB_0_3D {1.0, 0.0, 0.0}   /* Red          */ 
#define RGB_1_3D {0.23, 0.7, 0.44} /* Sea Green    */
#define RGB_2_3D {1.0, 0.0, 1.0}   /* Violet       */
#define RGB_3_3D {1.0, 0.5, 0.0}   /* Orange       */
#define RGB_4_3D {1.0, 0.0, 0.4}   /* Pompei red   */
#define RGB_5_3D {0.0, 1.0, 0.0}   /* Green        */
#define RGB_6_3D {0.0, 1.0, 1.0}   /* Cyan         */
#define RGB_7_3D {0.0, 0.0, 1.0}   /* Blue         */
#define RGB_8_3D {0.5, 0.5, 0.5}   /* Gray         */
#define RGB_9_3D {0.3, 0.1, 1.0}   /* Bluish       */
#define RGB_10_3D {0.2, 1.0, 1.0}  /* Cyanish      */
#define RGB_11_3D {0.2, 1.0, 0.2}  /* Greenish     */ 
#define RGB_12_3D {0.1, 0.1, 0.1}  /* Almost black */

typedef enum {
  Plus = 0,
  Square,
  Diamond,
  Cross,
  Bullet,
  Nr_Symbols
} cairo_symbol;

/* Return NULL in case of failure */
gchar* get_formatted_caption (const char* caption, graphic_mode mode, 
			      int object_id);
gchar* wrap_string (const gchar* str, unsigned indentation);

void init_cairo_driver (void);

/* Return NULL in case of failure */
cairo_t* new_cairo_context (cairo_initializer in, int* r, gboolean* pdf_or_ps_surface);

cairo_paper_format get_paper_format (void);
void set_paper_format (cairo_paper_format new_format);
cairo_orientation get_orientation (void);
void set_orientation (cairo_orientation new_orientation);

const char* get_color_2d_name (cairo_color_2d color);
const char* get_color_3d_name (cairo_color_3d color);
cairo_color_2d get_default_color_2d (int object_id);
cairo_color_3d get_default_color_3d (int object_id);
void set_color_for_2dobject (int object_id, cairo_color_2d color);
void set_color_for_3dobject (int object_id, cairo_color_3d color);

const char* get_symbol_name (cairo_symbol symbol);
cairo_symbol get_default_symbol (int object_id);
void set_symbol_for_2dobject (int object_id, cairo_symbol symbol);
void set_symbol_for_3dobject (int object_id, cairo_symbol symbol);

gboolean are_addinfo_printed (void);
void please_print_addinfo (gboolean yesno);
gboolean is_copyright_printed (void);
void please_print_disclaimer (gboolean yesno);
void draw (cairo_t* cr, int r, gboolean exported_picture);

#endif /* __CAIRO_DRIVER__ */

