/* Created by Anjuta version 1.0.0 */
/*	This file will not be overwritten */
/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <locale.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "config.h"
#include "gtk/gtk.h"
#include "glade/glade.h"
#include "gtkacl.h"
#include "gtkacl-callbacks.h"


//#include "bonobo_gtkacl.h"


void on_destroy(GtkWidget widget, gpointer data);


//
int main(gint argc, gchar **argv)
{
	gtk_set_locale();
	gtk_init(&argc, &argv);
	
	/***** Check parameters *****/
	
	if (argc < 2) 
	{
		g_print(_("Usage : gtk-acl <filename>\n"));
		exit(0);
	}		
	
	if (g_strcasecmp(argv[1], "--help") == 0)
	{
		g_print(_("Usage : gtk-acl <filename>\n"));
		exit(0);
	}
	
	if (g_strcasecmp(argv[1], "--version") == 0)
	{
		g_print("%s version %s\n", PACKAGE, VERSION);
		exit(0);
	}

	struct stat s_stat;
		
	if (stat(argv[1], &s_stat) == -1)
	{
		g_print(_("Wrong path!\n"));
		return 1;
	}
	
	/***** *****/

	GtkWidget *gtk_acl;
	
	gtk_acl = gtk_acl_new();
	g_signal_connect(G_OBJECT(gtk_acl), "destroy", G_CALLBACK(on_destroy), NULL);
	gtk_widget_show(GTK_WIDGET(gtk_acl));
	
	
	gtk_acl_load_file(GTK_ACL(gtk_acl), argv[1]);
	
	gtk_main();

	return 0;
	
}



//
void on_destroy(GtkWidget widget, gpointer data)
{
	gtk_main_quit();
}
